#include "dia_FactoryPluginTests.h"

#ifndef __INCLUDED_DIA_COMMON_APPLICATION__
#include "common/framework/application/dia_common_application.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_RUNLEVEL__
#include "common/framework/application/dia_PredicateRunlevel.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_REGISTRATION_CCA__
#include "common/framework/platform/cca/dia_PredicateServiceRegistrationCCA.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_STATE_CCA__
#include "common/framework/platform/cca/dia_PredicateServiceStateCCA.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_PROGRAMMING_SERVICE__
#include "project/framework/platform/session/dia_PredicateProgrammingSession.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CONFIG_HASH_AIVI_H_
#include "project/framework/test/dia_TestConfigHash_AIVI.h"
#endif

#ifndef __INCLUDED_DIA_TEST_FACTORY_MODE_H_
#include "project/framework/test/dia_TestFactoryMode.h"
#endif

#ifndef __INCLUDED_DIA_TEST_LOUDSPEAKER_H_
#include "project/framework/test/dia_TestLoudspeaker.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_GENERIC_CONFIGITEM_VAR_LENGTH_WRITE__
#include "project/services/customer/dia_GenericConfigItemVarLengthWrite.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CALC_HASH_UPDATE_REGISTRY_H_
#include "common/framework/test/dia_TestCalcHashUpdateRegistry.h"
#endif

#ifndef __INCLUDED_DIA_TEST_PDXFlashing__
#include <common/framework/test/dia_TestPDXFlashing.h>
#endif

#ifndef __INCLUDED_DIA_TEST_XTRA_DATA__
#include <project/framework/test/dia_TestXtraData.h>
#endif

#ifndef __DIA_INCLUDED_TEST_ODOMETER__
#include <project/framework/test/dia_TestOdometer.h>
#endif

#ifndef __DIA_INCLUDED_TEST_VIN__
#include <project/framework/test/dia_TestVIN.h>
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

// tests

#ifdef __ENABLE_FEATURE_RUN_IN__

#ifndef __INCLUDED_DIA_TEST_RUNIN__
#include <common/framework/test/dia_TestRunIn.h>
#endif

#endif

#ifndef __INCLUDED_DIA_TEST_INPUT_EVENT__
#include "project/framework/test/dia_TestInputEvent.h"
#endif


#define DIA_PROP_CM_VARIANT_CODING_LENGTH          ((tU16)32)
#define DIA_CM_VARIANT_CODING_OEM_TYPE_INDEX       (3)
#define DIA_OEM_TYPE_NISSAN                        ((tU8)0x06)
#define DIA_OEM_TYPE_RENAULT                       ((tU8)0x08)


// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginTests)

//-----------------------------------------------------------------------------

dia_FactoryPluginTests::dia_FactoryPluginTests ( void )
   : dia_FactoryPlugin("dia_FactoryPluginTests",DIA_EN_FACTORY_PLUGIN_TYPE_TEST)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginTests::~dia_FactoryPluginTests ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginTests::setup ( dia_enInitLevel level )
{
   tU16 itc = 0;

   dia_tclFnctTrace oTrace("dia_FactoryPluginTests::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF TEST FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      // get the pointer to the test controller and the engine
      dia_TestController* pTestCtrl = getInstanceOfTestController();

      dia_EngineServer*  pEngine    = 0;
      dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
      if ( (!pEngineMgr) || ( pEngineMgr->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) != DIA_SUCCESS ) )
      {
         DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO CUSTOMER DIAGNOSIS ENGINE #####");
         return DIA_FAILED;
      }

      if ( !pEngine )
      {
         DIA_TR_ERR("##### INVALID POINTER TO CUSTOMER DIAGNOSIS ENGINE FOUND #####");
         return DIA_FAILED;
      }

      DIA_TR_INF("###############################################");
      DIA_TR_INF("# ADDING TESTS");
      DIA_TR_INF("###############################################");

      //lint -e429 custodial pointer is freed by this factory class

#ifdef __ENABLE_FEATURE_RUN_IN__
      dia_TestRunIn* pTestRunIn = OSAL_NEW dia_TestRunIn;
      if ( pTestRunIn )
      {
         DIA_TR_INF("# ADDING TEST dia_TestRunIn ...");
         (void) pTestRunIn->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_NORMAL_STATE);
         (void) pTestRunIn->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_RUNIN);
         (void) pTestRunIn->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_1) );
         pTestCtrl->addTest(pTestRunIn);
         pEngine->bAddServiceHandler(pTestRunIn);
      }
#endif

      dia::TestPDXFlashing* pTestPDXFlashing = DIA_NEW dia::TestPDXFlashing;
      if ( pTestPDXFlashing )
      {
         DIA_TR_INF("# ADDING TEST dia::TestPDXFlashing ...");
         (void) pTestPDXFlashing->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_NORMAL_STATE);
         (void) pTestPDXFlashing->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_PDX_FLASHING);
         (void) pTestPDXFlashing->addPredicate( DIA_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_1) );
         pTestCtrl->addTest(pTestPDXFlashing);
         pEngine->bAddServiceHandler(pTestPDXFlashing);
      }

      dia::TestXtraData* pTestXtraData = DIA_NEW dia::TestXtraData;
      if ( pTestXtraData )
      {
         DIA_TR_INF("# ADDING TEST dia::TestXtraData ...");
         (void) pTestXtraData->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_NORMAL_STATE);
         (void) pTestXtraData->addTestCondition(DIA_EN_TESTCONDITION_XTRA_DATA);
         (void) pTestXtraData->addPredicate( DIA_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_1) );
         pTestCtrl->addTest(pTestXtraData);
         pEngine->bAddServiceHandler(pTestXtraData);
      }

      // test objects that read out Factory Mode and set/clear corresponding DTC
      {
         dia_TestService* pServiceFactoryMode = OSAL_NEW dia_TestFactoryMode(ITC_AIVI_FACTORY_MODE);
         if (pServiceFactoryMode)
         {
            (void) pServiceFactoryMode->addTestCondition(DIA_EN_TESTCONDITION_ERROR_MEMORY_RESET);
            (void) pServiceFactoryMode->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_NORMAL_STATE);
            (void) pServiceFactoryMode->addTestCondition(DIA_EN_TESTCONDITION_FACTORY_MODE);
            (void) pServiceFactoryMode->addPredicate( OSAL_NEW dia_PredicateProgrammingSession() );   /* skip test trigger in programming session */
            (void) pServiceFactoryMode->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_2) );
            (void) pServiceFactoryMode->addPredicate( OSAL_NEW dia_PredicateServiceRegistrationCCA(CCA_C_U16_SRV_DIAGLOG, CCA_C_U16_APP_DIAGLOG) );
            (void) pServiceFactoryMode->addPredicate( OSAL_NEW dia_PredicateServiceStateCCA(CCA_C_U16_SRV_DIAGLOG, CCA_C_U16_APP_DIAGLOG, TRUE) );
            if (DIA_SUCCESS!=pTestCtrl->addTest(pServiceFactoryMode))
            {
               DIA_TR_ERR("##### ERROR. dia_TestFactoryMode NOT ADDED. #####");
            }

            (void) pEngine->bAddServiceHandler(pServiceFactoryMode);
         }
      }

      // test objects that contain virtual buffers for writing variable length parameter sets
      struct TestServices
      {
         tCString name;
         tU16 did;
         tU32 propID;
         tBool bCheckCrc;
      };
      static const TestServices varLengthConfigItems[] =
      {
            {"SrvHandler_WritePhone_ECNR_NBS",              DIA_C_U16_DID_AIVI_PHONE_ECNR_NBS_BASE_SCOPE2,  DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB, TRUE},
            {"SrvHandler_WritePhone_ECNR_WBS",              DIA_C_U16_DID_AIVI_PHONE_ECNR_WBS_BASE_SCOPE2,  DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB, TRUE},
            {"SrvHandler_WriteCarplay_Phone_ECNR_NBS",      DIA_C_U16_DID_AIVI_CARPLAY_PHONE_ECNR_NBS,      DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB, TRUE},
            {"SrvHandler_WriteCarplay_Phone_ECNR_WBS",      DIA_C_U16_DID_AIVI_CARPLAY_PHONE_ECNR_WBS,      DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB, TRUE},
            {"SrvHandler_WriteCarplay_Facetime_ECNR_SWB",   DIA_C_U16_DID_AIVI_CARPLAY_FACETIME_ECNR_SWB,   DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB, TRUE}
           ,{"SrvHandler_WriteAcoustic_Param",              DIA_C_U16_DID_AIVI_ACOUSTIC_PARAM_BASE_SCOPE2,  DIA_PROP_AIVI_ACOUSTIC_PARAM, FALSE}, /* No CRC check */  /* valid for Scope 2.0, keep in Scope 2.1 also (due to customer request) */
      };

      for (tU32 i = 0; i < sizeof(varLengthConfigItems)/sizeof(TestServices); i++)
      {
         dia_TestService* pVarLengthConfigItem = OSAL_NEW dia_GenericConfigItemVarLengthWrite(varLengthConfigItems[i].name,
               DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER, varLengthConfigItems[i].did, varLengthConfigItems[i].bCheckCrc);
         if (pVarLengthConfigItem)
         {
            (void) pVarLengthConfigItem->addTestCondition(DIA_EN_TESTCONDITION_GENERIC_CONFIG_ITEM_VAR_LENGTH_WRITE); //Flush the temporary buffer to the ConfigItem
            (void) pVarLengthConfigItem->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_1) );
            (void) pTestCtrl->addTest(pVarLengthConfigItem);

            tU8 sessions[] = {0x60}; //Production Session
            void* args[] = {(void*) varLengthConfigItems[i].propID};
            (void) pEngine->bAddServiceHandler(pVarLengthConfigItem, sizeof(sessions)/sizeof(tU8), sessions, sizeof(args)/sizeof(void*), args);
         }
      }

      /* ************************************************************************************ */
      /* test object that calculate and check the hash value over customer configuration item */
      /* test object is different for each set (project scope)                                */
      /* ************************************************************************************ */

      // select currently configured set (AIVI scope).
      tU8 currentSet = 0;

      if(dia_getPropertySize(DIA_PROP_AIVI_VARIANT_CODING)==DIA_AIVI_VARIANT_CODING_LENGTH)
      {
         tU8 aiviVariantCoding[DIA_AIVI_VARIANT_CODING_LENGTH] = { 0 };
         tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, aiviVariantCoding, DIA_AIVI_VARIANT_CODING_LENGTH);
         if(getPropRes==DIA_SUCCESS)
         {
            currentSet = (aiviVariantCoding[0] & 0xF0) >> 4;
            DIA_TR_INF("dia_FactoryPluginTests::setup Set Customer Fingerprints according scope/set. Current Set = 0x%02x .", currentSet);
         }
         else
         {
            DIA_TR_ERR("dia_FactoryPluginTests::setup ==============================================================");
            DIA_TR_ERR("dia_FactoryPluginTests::setup FAILURE WITH READING CONTENT OF DIA_PROP_AIVI_VARIANT_CODING !");
            DIA_TR_ERR("dia_FactoryPluginTests::setup ==============================================================");
         }
      }
      else
      {
         DIA_TR_ERR("dia_FactoryPluginTests::setup ======================================================");
         DIA_TR_ERR("dia_FactoryPluginTests::setup AIVI_VARIANT_CODING_LENGTH WRONG! IS=%d SHOULD=%d !", dia_getPropertySize(DIA_PROP_AIVI_VARIANT_CODING), DIA_AIVI_VARIANT_CODING_LENGTH);
         DIA_TR_ERR("dia_FactoryPluginTests::setup NO FINGERPRINTS CONFIGURED !");
         DIA_TR_ERR("dia_FactoryPluginTests::setup ======================================================");
      }

#if 0 /*This part of code will only be disabled for the feature branch heading towards the development in Scope2.1. Could be taken up in future.*/
      !defined(VARIANT_S_FTR_ENABLE_RIVIE)  //Only Scope1 and Scope2.0
      tU8 currentOEMType;
      currentOEMType = 0xFF;  //init value

      if(dia_getPropertySize(DIA_PROP_CM_VARIANT_CODING)==DIA_PROP_CM_VARIANT_CODING_LENGTH)
      {
         tU8 CMVariantCoding[DIA_PROP_CM_VARIANT_CODING_LENGTH] = { 0 };
         tDiaResult getPropRes = dia_getProperty(DIA_PROP_CM_VARIANT_CODING, CMVariantCoding, DIA_PROP_CM_VARIANT_CODING_LENGTH);
         if (DIA_SUCCESS==getPropRes)
         {
            currentOEMType = CMVariantCoding[DIA_CM_VARIANT_CODING_OEM_TYPE_INDEX];
            DIA_TR_INF("dia_FactoryPluginTests::setup currentOEMType = 0x%02x", currentOEMType);
         }
         else
         {
            DIA_TR_ERR("dia_FactoryPluginTests::setup ==============================================================");
            DIA_TR_ERR("dia_FactoryPluginTests::setup ErrCode = 0x%08X. FAILURE WITH READING CONTENT OF DIA_PROP_CM_VARIANT_CODING !", getPropRes);
            DIA_TR_ERR("dia_FactoryPluginTests::setup ==============================================================");
         }
      }
      else
      {
         DIA_TR_ERR("dia_FactoryPluginTests::setup ======================================================");
         DIA_TR_ERR("dia_FactoryPluginTests::setup CM_VARIANT_CODING_LENGTH WRONG! IS=%d SHOULD=%d !", dia_getPropertySize(DIA_PROP_CM_VARIANT_CODING), DIA_PROP_CM_VARIANT_CODING_LENGTH);
         DIA_TR_ERR("dia_FactoryPluginTests::setup ======================================================");
      }

      switch(currentOEMType)
      {
         case DIA_OEM_TYPE_NISSAN:
            DIA_TR_INF("dia_FactoryPluginTests::setup DIA_OEM_TYPE_NISSAN CUSTOMER1");
            itc = ITC_DIAG_CUSTOMER1_CONFIG_INVALID;
         break;

         case DIA_OEM_TYPE_RENAULT:
            DIA_TR_INF("dia_FactoryPluginTests::setup DIA_OEM_TYPE_RENAULT CUSTOMER2");
            itc = ITC_DIAG_CUSTOMER2_CONFIG_INVALID;
         break;

         default:
            DIA_TR_ERR("dia_FactoryPluginTests::setup ERROR! unknown OEM type (%d)", currentOEMType);
            itc = ITC_DIAG_CUSTOMER1_CONFIG_INVALID;
         break;
      }
#endif

#if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_RIVIE)     //Required for Scope2.1 both Nissan and Renault
      DIA_TR_INF("dia_FactoryPluginTests::setup DIA_OEM_TYPE_RENAULT Scope2.1");
      itc = ITC_DIAG_CUSTOMER2_CONFIG_INVALID;
#endif

      DIA_TR_INF("dia_FactoryPluginTests::setup itc = 0x%04X", itc);

      const dia_FingerprintInfo* currCustomerFingerprintData = NULL;
      tU16 currElementNum = 0;

      dia_TestConfigHash_AIVI* pTestConfigHash        = OSAL_NEW dia_TestConfigHash_AIVI(        DIA_PROP_CUSTOMER_CONFIG_HASH_VALUE,         DIA_PROP_CUSTOMER_CONFIG_FINGERPRINT, itc);
      dia_TestCalcHashUpdateRegistry* pTestHashPd     = OSAL_NEW dia_TestCalcHashUpdateRegistry( "dia_TestCalcHashUpdateRegistry for PD",     DIA_C_U16_DID_RBCM_TEST_CONFIG_PD_HASH,      DIA_PROP_CM_CONFIG_ID);
      dia_TestCalcHashUpdateRegistry* pTestHashCdDef  = OSAL_NEW dia_TestCalcHashUpdateRegistry( "dia_TestCalcHashUpdateRegistry for CD-DEF", DIA_C_U16_DID_RBCM_TEST_CONFIG_CD_DEF_HASH,  DIA_PROP_CUSTOMER_DEFAULT_CONFIG_ID);

      if ( pTestConfigHash )
      {
    	 DIA_TR_INF("# ADDING TEST dia_TestConfigHash_AIVI ...");
         std::string postFix;
         DIA_TR_INF("# dia_TestConfigHash_AIVI uses ConfigHash for Production table .");
         currCustomerFingerprintData = aCMFingerprintData;
         currElementNum = (const tU16) (sizeof(aCMFingerprintData) / sizeof(dia_FingerprintInfo));
         postFix = std::string("CMC");

//         switch (currentSet)
//         {
//            case 0x01:
//               DIA_TR_INF("# dia_TestConfigHash_AIVI uses ConfigHash for Set 1 .");
//               currCustomerFingerprintData = aCustomerFingerprintData_Set1;
//               currElementNum = (const tU16) (sizeof(aCustomerFingerprintData_Set1) / sizeof(dia_FingerprintInfo));
//               postFix = std::string("_Scope1");
//            break;
//
//            case 0x02:
//               DIA_TR_INF("# dia_TestConfigHash_AIVI uses ConfigHash for Set 2 .");
//               currCustomerFingerprintData = aCMFingerprintData;
//               currElementNum = (const tU16) (sizeof(aCMFingerprintData) / sizeof(dia_FingerprintInfo));
//               postFix = std::string("CMC");
//            break;
//
//            default:
//               // Use Set 0x01
//               DIA_TR_INF("# Unknown currentSet = %d -- dia_TestConfigHash_AIVI uses ConfigHash for Set 1 .", currentSet);
//               currCustomerFingerprintData = aCustomerFingerprintData_Set1;
//               currElementNum = (const tU16) (sizeof(aCustomerFingerprintData_Set1) / sizeof(dia_FingerprintInfo));
//               postFix = std::string("_Scope1");
//            break;
//         }

         pTestConfigHash->setPropData(currCustomerFingerprintData, currElementNum);
         pTestConfigHash->setTestName(std::string(pTestConfigHash->getTestName()) + postFix);
         (void) pTestConfigHash->addTestCondition(DIA_EN_TESTCONDITION_PDX_FLASHING_END);
         (void) pTestConfigHash->addTestCondition(DIA_EN_TESTCONDITION_KDS_WRITE_FAIL);
//         (void) pTestConfigHash->addTestCondition(DIA_EN_TESTCONDITION_ERROR_MEMORY_RESET);
//         (void) pTestConfigHash->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_NORMAL_STATE);
//         (void) pTestConfigHash->addTestCondition(DIA_EN_TESTCONDITION_CODINGVALUE_CHANGE);   //necessary in A-IVI project for starting of embedded test
//         (void) pTestConfigHash->addTestCondition(DIA_EN_TESTCONDITION_KEY_OFF_ON_RESET);
         (void) pTestConfigHash->addPredicate( OSAL_NEW dia_PredicateProgrammingSession() );    /* skip test trigger in programming session */
         (void) pTestConfigHash->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_2) );
         (void) pTestConfigHash->addPredicate( OSAL_NEW dia_PredicateServiceRegistrationCCA(CCA_C_U16_SRV_DIAGLOG, CCA_C_U16_APP_DIAGLOG) );
         (void) pTestConfigHash->addPredicate( OSAL_NEW dia_PredicateServiceStateCCA(CCA_C_U16_SRV_DIAGLOG, CCA_C_U16_APP_DIAGLOG, TRUE) );
         if (DIA_SUCCESS!=pTestCtrl->addTest(pTestConfigHash))
         {
            DIA_TR_ERR("##### ERROR. dia_TestConfigHash_AIVI NOT ADDED. #####");
         }
         pEngine->bAddServiceHandler(pTestConfigHash);
      }

      if ( pTestHashPd )
      {
         DIA_TR_INF("# ADDING TEST dia_TestCalcHashUpdateRegistry for PD");
         pTestHashPd->setPropData(aCMFingerprintData, (const tU16) (sizeof(aCMFingerprintData) / sizeof(dia_FingerprintInfo)));

         (void) pTestHashPd->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_NORMAL_STATE);
         (void) pTestHashPd->addTestCondition(DIA_EN_TESTCONDITION_CODINGVALUE_CHANGE);   //necessary in A-IVI project for starting of embedded test
         (void) pTestHashPd->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_2) );
         if (DIA_SUCCESS!=pTestCtrl->addTest(pTestHashPd))
         {
            DIA_TR_ERR("##### ERROR. dia_TestCalcHashUpdateRegistry for PD NOT ADDED. #####");
         }
         pEngine->bAddServiceHandler(pTestHashPd);
      }

      if ( pTestHashCdDef )
      {
         DIA_TR_INF("# ADDING TEST dia_TestCalcHashUpdateRegistry for CD-DEF");
         switch (currentSet)
         {
            case 0x01:
               DIA_TR_INF("# dia_TestCalcHashUpdateRegistry uses CD-DEF config for Set 1 .");
               currCustomerFingerprintData = aCustomerDefaultFingerprintData_Set1;
               currElementNum = (const tU16) (sizeof(aCustomerDefaultFingerprintData_Set1) / sizeof(dia_FingerprintInfo));
            break;

            case 0x02:
               DIA_TR_INF("# dia_TestCalcHashUpdateRegistry uses CD-DEF config for Set 2 .");
               currCustomerFingerprintData = aCustomerDefaultFingerprintData_Set2;
               currElementNum = (const tU16) (sizeof(aCustomerDefaultFingerprintData_Set2) / sizeof(dia_FingerprintInfo));
            break;

            default:
               // Use Set 0x01
               DIA_TR_INF("# Unknown currentSet = %d -- dia_TestCalcHashUpdateRegistry uses CD-DEF config for Set 1 .", currentSet);
               currCustomerFingerprintData = aCustomerDefaultFingerprintData_Set1;
               currElementNum = (const tU16) (sizeof(aCustomerDefaultFingerprintData_Set1) / sizeof(dia_FingerprintInfo));
            break;
         }

         pTestHashCdDef->setPropData(currCustomerFingerprintData, currElementNum);

         (void) pTestHashCdDef->addTestCondition(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_NORMAL_STATE);
         (void) pTestHashCdDef->addTestCondition(DIA_EN_TESTCONDITION_CODINGVALUE_CHANGE);   //necessary in A-IVI project for starting of embedded test
         (void) pTestHashCdDef->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_2) );
         if (DIA_SUCCESS!=pTestCtrl->addTest(pTestHashCdDef))
         {
            DIA_TR_ERR("##### ERROR. dia_TestCalcHashUpdateRegistry for CD-DEF NOT ADDED. #####");
         }
         pEngine->bAddServiceHandler(pTestHashCdDef);
      }

#if 0
      dia_TestInputEvent* pTestInputEvent = OSAL_NEW dia_TestInputEvent;
      if ( pTestInputEvent )
      {
         DIA_TR_INF("# ADDING TEST dia_TestInputEvent ...");
         (void) pTestInputEvent->addTestCondition(DIA_EN_TESTCONDITION_DIAGNOSIS_ACTIVATED);
         (void) pTestInputEvent->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_2) );
         (void) pTestInputEvent->addPredicate( OSAL_NEW dia_PredicateServiceRegistrationCCA(CCA_C_U16_SRV_VD_INPUT, CCA_C_U16_APP_VD_INPUT) );
         (void) pTestInputEvent->addPredicate( OSAL_NEW dia_PredicateServiceStateCCA(CCA_C_U16_SRV_VD_INPUT, CCA_C_U16_APP_VD_INPUT, TRUE) );
         pTestCtrl->addTest(pTestInputEvent);
         pEngine->bAddServiceHandler(pTestInputEvent);
      }
#endif

#if 0
      /**************************************/
      /* LOUDSPEAKER TEST with parameter DC */
      /**************************************/

      dia_TestLoudspeaker* pTestLoudspeaker = OSAL_NEW dia_TestLoudspeaker();
      if ( pTestLoudspeaker )
      {
         DIA_TR_INF("# ADDING TEST dia_TestLoudspeaker ...");
         (void) pTestLoudspeaker->addTestCondition(DIA_EN_TESTCONDITION_ERROR_MEMORY_RESET);
         (void) pTestLoudspeaker->addTestCondition(DIA_EN_TESTCONDITION_DIAGNOSIS_ACTIVATED);
         (void) pTestLoudspeaker->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_2) );
         (void) pTestLoudspeaker->addPredicate( OSAL_NEW dia_PredicateServiceRegistrationCCA(CCA_C_U16_SRV_AUDIOFUNC, CCA_C_U16_APP_AUDIO) );
         (void) pTestLoudspeaker->addPredicate( OSAL_NEW dia_PredicateServiceStateCCA(CCA_C_U16_SRV_AUDIOFUNC, CCA_C_U16_APP_AUDIO, TRUE) );
         pTestCtrl->addTest(pTestLoudspeaker);
         pEngine->bAddServiceHandler(pTestLoudspeaker);
      }
#endif

      //lint -e429 custodial pointer is freed by this factory class

      /**************************************/
      /* ODOMETER TEST  */
      /**************************************/
      dia_TestOdometer* pTestOdometer = OSAL_NEW dia_TestOdometer;
      if(pTestOdometer)
      {
         mTestRep.push_back(pTestOdometer);
   
            //
            // Assign test conditions to the test object.
            // Whenever one of these conditions is triggered at dia_TestController the test will be started
            //
            (tVoid) pTestOdometer->addTestCondition(DIA_EN_TESTCONDITION_PROCESS_ODOMETER);
            // diagnosis application must have reached run level 2
            (tVoid) pTestOdometer->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_2) );
            //
            // Add newly created and configured test object to the test controller
            //
            if (DIA_SUCCESS!=pTestCtrl->addTest(pTestOdometer))
            {
               DIA_TR_ERR("##### ERROR. dia_TestOdometer NOT ADDED. #####");
            }
            //
            // Register the newly created and configured test object as service handler at the engine that shall execute the test
            //
            pEngine->bAddServiceHandler(pTestOdometer);
      }

      /**************************************/
      /* VIN TEST  */
      /**************************************/
      dia_TestVIN* pTestVin = OSAL_NEW dia_TestVIN;
      if(pTestVin)
      {
         mTestRep.push_back(pTestVin);
   
            //
            // Assign test conditions to the test object.
            // Whenever one of these conditions is triggered at dia_TestController the test will be started
            //
            (tVoid) pTestVin->addTestCondition(DIA_EN_TESTCONDITION_PROCESS_VIN);
            // diagnosis application must have reached run level 2
            (tVoid) pTestVin->addPredicate( OSAL_NEW dia_PredicateRunlevel(DIA_EN_RUNLEVEL_2) );
            //
            // Add newly created and configured test object to the test controller
            //
            if (DIA_SUCCESS!=pTestCtrl->addTest(pTestVin))
            {
               DIA_TR_ERR("##### ERROR. pTestVin NOT ADDED. #####");
            }
            //
            // Register the newly created and configured test object as service handler at the engine that shall execute the test
            //
            pEngine->bAddServiceHandler(pTestVin);
      }
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginTests::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginTests::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_Test,mTestRep)

      // destroy the routine control manager object
      dia_TestController::deleteInstance();
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

