#ifndef __FACTORY_PLUGIN_ROUTINE_CONTROLS__
#define __FACTORY_PLUGIN_ROUTINE_CONTROLS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include "common/framework/factory/dia_FactoryPlugin.h"
#endif

#ifndef DIA_ROUTINECTRLCHECKREPROGRAMMINGDTC_H_
#include "project/services/customer/dia_RoutineCtrlCheckReprogrammingDtc.h"
#endif


class dia_Routine;
class dia_RoutineCtrlManager;

class dia_FactoryPluginRoutineControls
   : public dia_FactoryPlugin
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_FactoryPluginRoutineControls);

public:
   //! setup (create objects,...)
   virtual tDiaResult setup ( dia_enInitLevel level );
   //! tear down (destroy objects,...)
   virtual tDiaResult tearDown ( dia_enInitLevel level ); // { return tearDownObjects(level); }

protected:
   //! class constructor
   dia_FactoryPluginRoutineControls ( tVoid );
   //! class destructor
   virtual ~dia_FactoryPluginRoutineControls ( tVoid );

   //! tear down all objects created by this class
//   tDiaResult tearDownObjects ( dia_enInitLevel level=DIA_EN_INITLEVEL_ALL );

protected:
   //! pointer to the routine control manager object
   dia_RoutineCtrlManager* mpRCtrlMgr;
   //! list of routine control objects
   std::list<dia_Routine*> mRoutineRep;
   //! map of Logical Blocks to pair of properties storing the Data and the Digests
   std::map<dia_e_logical_block,std::pair <tU32,tU32> > mPropRepo;
};

#endif
