#include "dia_FactoryPluginIOControls.h"

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include "common/framework/application/dia_SessionController.h"
#endif

#ifndef __DIA_UNIT_TESTING__
#ifndef __INCLUDED_DIA_COMMON_SERVICES_UDS_PRODUCTION__
#include "common/services/uds/production/dia_common_services_uds_production.h"
#endif
#ifndef DIA_PROJECT_SERVICES_PRODUCTION_H_
#include "project/services/production/dia_project_services_production.h"
#endif
#else
#include "common/services/uds/production/dia_IOCtrlTunerDAB_Antenna_1_EnsembleFrequency.h"
#endif

#ifndef __DIA_SERVICES_CUSTOMER__
#include "project/services/customer/dia_services_customer.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

using namespace dia;

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginIOControls)

//-----------------------------------------------------------------------------

dia_FactoryPluginIOControls::dia_FactoryPluginIOControls ( void )
   : dia_FactoryPlugin("dia_FactoryPluginIOControls",DIA_EN_FACTORY_PLUGIN_TYPE_IO_CONTROL),
     mpIOCtrlMgr(0)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginIOControls::~dia_FactoryPluginIOControls ( void )
{
   /*(void) tearDownObjects();*/
   mpIOCtrlMgr = 0;
}

//-----------------------------------------------------------------------------

#define ADD_SIGNAL(className) \
   { \
      className* pSignal = OSAL_NEW className; \
      (void) mpIOCtrlMgr->addSignal(pSignal); \
      mSignalRep.push_back(pSignal); \
   }

//-----------------------------------------------------------------------------

#define ADD_SIGNAL_WITH_ONE_PARAM(className,classParam) \
   { \
      className* pSignal = OSAL_NEW className(classParam); \
      (void) mpIOCtrlMgr->addSignal(pSignal); \
      mSignalRep.push_back(pSignal); \
   }

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginIOControls::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginIOControls::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF IOCONTROL FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // get the pointer to the IOCtrl manager
      mpIOCtrlMgr = dia_IOCtrlManager::getInstance();
      if ( !mpIOCtrlMgr ) {
         DIA_TR_ERR("dia_FactoryPluginIOControls::setup(DIA_EN_INITLEVEL_0) - creation of input/output control manager failed !!");
         return DIA_FAILED;
      }
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      if  ( mpIOCtrlMgr )
      {
         DIA_TR_INF("###############################################");
         DIA_TR_INF("# ADDING IO CONTROL SIGNALS");
         DIA_TR_INF("###############################################");

#ifndef __DIA_UNIT_TESTING__
         //lint -e429 custodial pointer is freed by this factory class
#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
		 ADD_SIGNAL(dia_IOCtrl_KeyIllumination)
         ADD_SIGNAL(dia_IOCtrlCompressedAudioTitle)
         ADD_SIGNAL(dia_IOCtrlHmiRemoteControl)
		 //ADD_SIGNAL(dia_IOCtrlDisplayTestPattern) //Bosch
		 //ADD_SIGNAL(dia_IOCtrlHMILanguage)
		 ADD_SIGNAL(dia_IOCtrlTunerAMFM_SelectActiveTuner)
         ADD_SIGNAL(dia_IOCtrlTunerAMFM_Frequency)
         ADD_SIGNAL(dia_IOCtrlTunerAMFM_Band)
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlTunerAMFM_Antenna_PowerSupply,DIA_EN_ANTENNA_1)
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlTunerAMFM_Antenna_PowerSupply,DIA_EN_ANTENNA_2)
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_PowerSupply)
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_EnsembleFrequency)
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_ServiceID)
#endif
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlUSB_PowerSupply,USB_DEVICE_1)
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlUSB_PowerSupply,USB_DEVICE_2)
         ADD_SIGNAL_WITH_ONE_PARAM(dia_IOCtrlUSB_PowerSupply,USB_DEVICE_3)
         ADD_SIGNAL(dia_IOCtrlDisplayBrightness)
         ADD_SIGNAL(dia_IOCtrlCDModeControl)
         ADD_SIGNAL(dia_IOCtrlSystemHmiOn)
         ADD_SIGNAL(dia_IOCtrlDatasetBlockSize)
		 ADD_SIGNAL(dia_IOCtrlTunerDRM_Antenna_ServiceID)
         ADD_SIGNAL(dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency)
#endif
#if 0 //STC2HI
         ADD_SIGNAL(dia_IOCtrl_PressedKey)
         ADD_SIGNAL(dia_IOCtrlGNSSPositioningSystem)
         ADD_SIGNAL(dia_IOCtrl_PlayedTrack)
#endif //STC2HI
         ADD_SIGNAL(dia_IOCtrlRVCControlLine)
         ADD_SIGNAL(dia_IOCtrlCDResetLine)
         
         
         ADD_SIGNAL(dia_IOCtrlDisplayTestPatternAIVI) //AIVI
         ADD_SIGNAL(dia_IOCtrlFanSpeed) // FanSpeed
         ADD_SIGNAL(dia_IOCtrlDisplayTest) //RN A-IVI (only White or Black)
         ADD_SIGNAL(dia_IOCtrlLoudspeakerTestTone)
         ADD_SIGNAL(dia_IOCtrlTunerSettings)
         ADD_SIGNAL(dia_IOCtrlTweeterTest)
         ADD_SIGNAL(dia_IOCtrlSpeakerTest)
         ADD_SIGNAL(dia_IOCtrlRearCameraActivation)
         ADD_SIGNAL(dia_IOCtrlSystemAmpOnOutput)
         ADD_SIGNAL(dia_IOCtrlAudioExtOutTelMode)
         ADD_SIGNAL(dia_IOCtrlAudioExtOutHfVr)

         ADD_SIGNAL(dia_IOCtrlGNSSPositioningSystem)
         ADD_SIGNAL(dia_IOCtrlTunerXM_1_Channel)
         ADD_SIGNAL(dia_IOCtrlActiveVideoSource)
         ADD_SIGNAL(dia_IOCtrlHMILanguage_set)
         ADD_SIGNAL(dia_IOCtrlDisplayTestScreenCMC)
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
         ADD_SIGNAL(dia_IOCtrlCDEject)
         ADD_SIGNAL(dia_IOCtrlExtOutSpare3)
#endif
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
         ADD_SIGNAL(dia_IOCtrlResetTouchCtrlExtDisplay)
#endif
#if 0 //STC2HI
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_PowerSupply)
         ADD_SIGNAL(dia_IOCtrlGNSSPositioningSystem)
         ADD_SIGNAL(dia_IOCtrlAudioExternalAmplifierContLine)
#endif //STC2HI
         ADD_SIGNAL(dia_IOCtrl_KeyIlluminationPWM)
#if 0 //STC2HI: midw_kbd_fi not available in Gen3g
         ADD_SIGNAL(dia_IOCtrlInputHdlPressedKey)
#endif //STC2HI
#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
		 ADD_SIGNAL(dia_IOCtrlAudioSourceSet)
         ADD_SIGNAL(dia_IOCtrlAudioGain)
         ADD_SIGNAL(dia_IOCtrlAudioTestTone)
         ADD_SIGNAL(dia_IOCtrlAudioBalance)
         ADD_SIGNAL(dia_IOCtrlAudioFader)
         ADD_SIGNAL(dia_IOCtrlAudioLinearMode)
         ADD_SIGNAL(dia_IOCtrlWifiMode)
         ADD_SIGNAL(dia::IOCtrlAudioSinkSet)
#endif
         ADD_SIGNAL(dia_IOCtrlBtModuleReset)
         ADD_SIGNAL(dia_IOCtrlWifiModuleReset)
         ADD_SIGNAL(dia_IOCtrlBluetoothMode)
         ADD_SIGNAL(dia_IOCtrlExternalAmplifierControlLine)

#if 0 //STC2HI
         ADD_SIGNAL_WITH_INITIALIZER(dia_IOCtrlBluetoothMode)
         ADD_SIGNAL_WITH_INITIALIZER(dia_IOCtrlBluetoothModuleReset)
         ADD_SIGNAL(dia_IOCtrlMicrophonePowerSupply)
#endif //STC2HI
         //lint +e429 custodial pointer is freed by this factory class
#else    //__DIA_UNIT_TESTING__
         //only one example
#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
         ADD_SIGNAL(dia_IOCtrlTunerDAB_Antenna_1_EnsembleFrequency)
#endif
#endif

         dia_EngineServer* pEngine = 0;
         tDiaResult queryEngineRet;
         if ( ((queryEngineRet = getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine)) == DIA_SUCCESS) &&
              (NULL!=pEngine) )
         {
            pEngine->getSessionController()->addListener(mpIOCtrlMgr);
         }
         else
         {
            if (DIA_SUCCESS!=queryEngineRet)    DIA_TR_INF("dia_FactoryPluginIOControls::setup queryEngine failed");
            else if (NULL==pEngine)             DIA_TR_INF("dia_FactoryPluginIOControls::setup pEngine is NULL.");
         }
      }
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginIOControls::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginIOControls::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_IOCtrlSignal,mSignalRep)
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy the input output control manager object
      if ( mpIOCtrlMgr ) {
         dia_IOCtrlManager::deleteInstance();
         mpIOCtrlMgr = 0;
      }
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}
