#ifndef __INCLUDED_FACTORY_PLUGIN_FIELD_LOAD_DATA__
#include "dia_FactoryPluginFieldLoadData.h"
#endif

#ifndef __INCLUDED_DIA_FIELD_LOAD_DATA_MANAGER__
#include "common/framework/fieldloaddata/dia_FieldLoadDataManager.h"
#endif

#ifndef __INCLUDED_DIA_TEMPERATUREHISTOGRAM_PLUGIN__
#include "common/framework/fieldloaddata/dia_TemperatureHistogramPlugin.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif


namespace dia {
// implementation of the singleton methods
DIA_IMPL_SINGLETON(FactoryPluginFieldLoadData)

//-----------------------------------------------------------------------------

FactoryPluginFieldLoadData::FactoryPluginFieldLoadData ( void )
   : dia_FactoryPlugin("FactoryPluginFieldLoadData",DIA_EN_FACTORY_PLUGIN_TYPE_FIELD_LOAD_DATA),
     mFieldLoadDataManager(nullptr)
{}

//-----------------------------------------------------------------------------

FactoryPluginFieldLoadData::~FactoryPluginFieldLoadData ( void )
{
   mFieldLoadDataManager = nullptr;
}

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------

tDiaResult
FactoryPluginFieldLoadData::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("FactoryPluginFieldLoadData::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF IOCONTROL FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // get the pointer to the IOCtrl manager
      mFieldLoadDataManager = FieldLoadDataManager::getInstance();
      if ( !mFieldLoadDataManager ) {
         DIA_TR_ERR("FactoryPluginFieldLoadData::setup(DIA_EN_INITLEVEL_0) - creation of FieldLoadDataManager failed !!");
         return DIA_FAILED;
      }
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      if  ( mFieldLoadDataManager )
      {
         DIA_TR_INF("###############################################");
         DIA_TR_INF("# ADDING FIELD LOAD DATA PLUGINS");
         DIA_TR_INF("###############################################");

         TemperatureHistogramPlugin *temperatureHistogramPlugin=new TemperatureHistogramPlugin;
         mFieldLoadDataManager->addFieldLoadDataPlugin( std::shared_ptr<FieldLoadDataPlugin>(temperatureHistogramPlugin));
         mFieldLoadDataManager->start();
      }
   }
   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
FactoryPluginFieldLoadData::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("FactoryPluginFieldLoadData::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      mFieldLoadDataManager->stop();
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      if (mFieldLoadDataManager) {
         FieldLoadDataManager::deleteInstance();
         mFieldLoadDataManager=nullptr;
      }
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

}
