

#ifndef __INCLUDED_FACTORY_PLUGIN_EXTENSIONS__
#include "dia_FactoryPluginExtensions.h"
#endif

#ifndef DIA_COMMON_UDS_GENERIC_SERVICES_H_
#include "common/services/uds/generic/dia_common_uds_generic_services.h"
#endif

#ifndef __DIA_SERVICES_CUSTOMER__
#include "project/services/customer/dia_services_customer.h"
#endif

#ifndef DIA_SRV_HANDLER_GENERIC_READ_FAULT_MEMORY_CMC_H_
#include "project/services/customer/dia_SrvHandlerGenericReadFaultMemoryCMC.h"
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include <vd_diaglog_if.h>


// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginExtensions)

//-----------------------------------------------------------------------------

dia_FactoryPluginExtensions::dia_FactoryPluginExtensions ( tVoid )
   : dia_FactoryPlugin("dia_FactoryPluginExtensions"),
     mpEngine(NULL)
{
}

//-----------------------------------------------------------------------------

dia_FactoryPluginExtensions::~dia_FactoryPluginExtensions ( tVoid )
{
}

//-----------------------------------------------------------------------------

#define ADD_NEW_SRVHDL(className) \
      (void) mpEngine->bAddServiceHandler(OSAL_NEW className());

#define ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(className,name,sid,did,...) \
      {                                                     \
         static const void* args[] = __VA_ARGS__ ;           \
         (void) mpEngine->bAddServiceHandler(OSAL_NEW className(name, sid, (tU16) did), (tU16) (sizeof(args)/sizeof(void*)), (void**) args); \
      }

#define ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(obj,sessionVec,...) \
      {                                                     \
         static const void* args[] = __VA_ARGS__ ;           \
       (void) mpEngine->bAddServiceHandler(obj, (tU16) (sizeof(sessionVec)/sizeof(tU8)), (tU8*) sessionVec, (tU16) (sizeof(args)/sizeof(void*)), (void**) args); \
     }

#define ADD_SRVHDL_FOR_SPECIFIC_SESSION(obj,sessionVec) \
      (void) mpEngine->bAddServiceHandler(obj, (tU16) (sizeof(sessionVec)/sizeof(tU8)), (tU8*) sessionVec);

#define ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(className,name,sid,did,propID) \
      {                                                     \
         static const void* args[] = {(void*) propID};              \
         (void) mpEngine->bAddServiceHandler(OSAL_NEW className(name, sid, (tU16) did, (tU32) propID), (tU16) (sizeof(args)/sizeof(void*)), (void**) args); \
      }

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginExtensions::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginExtensions::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF EXTENSIONS FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS, &mpEngine) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO CUSTOMER DIAGNOSIS ENGINE #####");
         return DIA_FAILED;
      }
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      if (mpEngine)
      {
         tU8 arProgrammingSessions[]  = { DIA_C_U8_UDS_SESSION_PROGRAMMING };
         tU8 arCustomerSessions[]     = { DIA_C_U8_UDS_SESSION_DEFAULT, DIA_C_U8_UDS_SESSION_EXTENDED };

         ////////////////////////////////////////////////////////////////////////////
         //
         // Service 0x19 (read fault memory) sub functions during ProgrammingSession
         //
         ////////////////////////////////////////////////////////////////////////////

         ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(OSAL_NEW dia_SrvHandlerGenericReadFaultMemoryCMC(UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK),
                                                      arProgrammingSessions,{ (void*) DIAGLOG_MEMORY_REPROGRAMMING })
         ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(OSAL_NEW dia_SrvHandlerGenericReadFaultMemoryCMC(UDS_REPORT_DTC_BY_STATUS_MASK),
                                                      arProgrammingSessions,{ (void*) DIAGLOG_MEMORY_REPROGRAMMING })
         ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(OSAL_NEW dia_SrvHandlerGenericReadFaultMemoryCMC(UDS_REPORT_READ_SUPPORTED_DTCS),
                                                      arProgrammingSessions,{ (void*) DIAGLOG_MEMORY_REPROGRAMMING })

         ////////////////////////////////////////////////////////////////////////////
         //
         // Service 0x22 (read data by identifier)
         //
         ////////////////////////////////////////////////////////////////////////////

         ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_Srvhandler_RadioState_Get(),arCustomerSessions)
         ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_ECUTemperatureRead("SrvHandler_ReadECUTemperature", 0x22, DIA_C_U16_DID_AIVI_ECU_TEMP,DIA_EN_HEATCTRL_TEMPERATURE_ID_SYSTEM),arCustomerSessions)
         ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_GPSReceptionLevel(),arCustomerSessions)
         ADD_NEW_SRVHDL(dia_SrvHandler_ReadCalibrationXtraData); //Also in ProgrammingSession
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD00_ReferenceChk",               0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_REFERENCE_CHECKSUM,        { (void*) DIA_PROP_AIVI_DIGEST_FD00_REFERENCE_CHECKSUM })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD01_PHONE_ECNR_NBS",             0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_NBS,            { (void*) DIA_PROP_AIVI_DIGEST_FD01_PHONE_ECNR_NBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD02_PHONE_ECNR_WBS",             0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_WBS,            { (void*) DIA_PROP_AIVI_DIGEST_FD02_PHONE_ECNR_WBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD03_VR_PARAM",                   0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_VR_PARAM,                  { (void*) DIA_PROP_AIVI_DIGEST_FD03_VR_PARAM })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD04_CARPLAY_PHONE_ECNR_NBS",     0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_NBS,    { (void*) DIA_PROP_AIVI_DIGEST_FD04_CARPLAY_PHONE_ECNR_NBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD05_CARPLAY_PHONE_ECNR_WBS",     0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_WBS,    { (void*) DIA_PROP_AIVI_DIGEST_FD05_CARPLAY_PHONE_ECNR_WBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD06_CARPLAY_FACETIME_ECNR_SWB",  0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_FACETIME_ECNR_SWB, { (void*) DIA_PROP_AIVI_DIGEST_FD06_CARPLAY_FACETIME_ECNR_SWB })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD07_ACOUSTIC_PARAM",             0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ACOUSTIC_PARAM,            { (void*) DIA_PROP_AIVI_DIGEST_FD07_ACOUSTIC_PARAM })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD08_ESE_PARAM",                  0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ESE_PARAM,                 { (void*) DIA_PROP_AIVI_DIGEST_FD08_ESE_PARAM })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD09_BT_VOICE_ECNR_NBS",          0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_NBS,         { (void*) DIA_PROP_AIVI_DIGEST_FD09_BT_VOICE_ECNR_NBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD0A_BT_VOICE_ECNR_WBS",          0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_WBS,         { (void*) DIA_PROP_AIVI_DIGEST_FD0A_BT_VOICE_ECNR_WBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD0B_BT_SIRI_ECNR_WBS",           0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_SIRI_ECNR_WBS,          { (void*) DIA_PROP_AIVI_DIGEST_FD0B_BT_SIRI_ECNR_WBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD0C_CARPLAY_SIRI_ECNR_WBS",      0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_SIRI_ECNR_WBS,     { (void*) DIA_PROP_AIVI_DIGEST_FD0C_CARPLAY_SIRI_ECNR_WBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD0D_ANDROID_AUTO_VR_ECNR_WBS",   0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ANDROID_AUTO_VR_ECNR_WBS,  { (void*) DIA_PROP_AIVI_DIGEST_FD0D_ANDROID_AUTO_VR_ECNR_WBS })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadDigest,   "SrvHandler_ReadDigestLB_FD0E_ECNR_VPA_VOICE_WB",          0x22, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ECNR_VPA_VOICE_WB,         { (void*) DIA_PROP_AIVI_DIGEST_FD0E_ECNR_VPA_VOICE_WB })
         ADD_NEW_SRVHDL(dia_SrvHandler_ReadSecurityFingerprint)
         ADD_NEW_SRVHDL(dia_SrvHandler_IndexSrvData)
         ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_ReadDegradedModeCounter(),arCustomerSessions)
         ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_ReadDegradedModeTime(),arCustomerSessions)
         ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_ReadEngineStoppedTime(),arCustomerSessions)
         ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_ReadVehicleIdentifier(),arCustomerSessions)

#ifdef VARIANT_S_FTR_ENABLE_RIVIE //Scope3.0
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_VehicleManufacurerHWNumber",                   0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_HW_D_NR,                { (void*) DIA_PROP_AIVI_VEH_MANUFACTURER_HW_D_NR })
#endif

         ////////////////////////////////////////////////////////////////////////////
         //
         // Service 0x2E (write data by identifier)
         //
         ////////////////////////////////////////////////////////////////////////////

         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD00_ReferenceChk",              0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_REFERENCE_CHECKSUM,        DIA_PROP_AIVI_DIGEST_FD00_REFERENCE_CHECKSUM)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD01_PHONE_ECNR_NBS",            0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_NBS,            DIA_PROP_AIVI_DIGEST_FD01_PHONE_ECNR_NBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD02_PHONE_ECNR_WBS",            0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_WBS,            DIA_PROP_AIVI_DIGEST_FD02_PHONE_ECNR_WBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD03_VR_PARAM",                  0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_VR_PARAM,                  DIA_PROP_AIVI_DIGEST_FD03_VR_PARAM)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD04_CARPLAY_PHONE_ECNR_NBS",    0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_NBS,    DIA_PROP_AIVI_DIGEST_FD04_CARPLAY_PHONE_ECNR_NBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD05_CARPLAY_PHONE_ECNR_WBS",    0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_WBS,    DIA_PROP_AIVI_DIGEST_FD05_CARPLAY_PHONE_ECNR_WBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD06_CARPLAY_FACETIME_ECNR_SWB", 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_FACETIME_ECNR_SWB, DIA_PROP_AIVI_DIGEST_FD06_CARPLAY_FACETIME_ECNR_SWB)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD07_ACOUSTIC_PARAM",            0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ACOUSTIC_PARAM,            DIA_PROP_AIVI_DIGEST_FD07_ACOUSTIC_PARAM)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD08_ESE_PARAM",                 0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ESE_PARAM,                 DIA_PROP_AIVI_DIGEST_FD08_ESE_PARAM)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD09_BT_VOICE_ECNR_NBS",         0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_NBS,         DIA_PROP_AIVI_DIGEST_FD09_BT_VOICE_ECNR_NBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD0A_BT_VOICE_ECNR_WBS",         0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_WBS,         DIA_PROP_AIVI_DIGEST_FD0A_BT_VOICE_ECNR_WBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD0B_BT_SIRI_ECNR_WBS",          0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_SIRI_ECNR_WBS,          DIA_PROP_AIVI_DIGEST_FD0B_BT_SIRI_ECNR_WBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD0C_CARPLAY_SIRI_ECNR_WBS",     0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_SIRI_ECNR_WBS,     DIA_PROP_AIVI_DIGEST_FD0C_CARPLAY_SIRI_ECNR_WBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD0D_ANDROID_AUTO_VR_ECNR_WBS",  0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ANDROID_AUTO_VR_ECNR_WBS,  DIA_PROP_AIVI_DIGEST_FD0D_ANDROID_AUTO_VR_ECNR_WBS)
         ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteBootDigestClearITC, "SrvHandler_WriteDigestLB_FD0E_ECNR_VPA_VOICE_WB",         0x2E, DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ECNR_VPA_VOICE_WB,         DIA_PROP_AIVI_DIGEST_FD0E_ECNR_VPA_VOICE_WB)

      } //if (mpEngine)
   } //if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginExtensions::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginExtensions::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

