/*
 * \file        dia_FactoryPluginEcuResets.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 24, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#include "dia_FactoryPluginEcuResets.h"

#ifndef DIA_ECU_RESET_HARD_RESET_PRJ_H_
#include "project/services/customer/dia_EcuResetHardResetPrj.h"
#endif

#ifndef DIA_ECU_RESET_FAST_SHUTDOWN_H_
#include "common/services/uds/production/dia_EcuResetFastShutdown.h"
#endif

#ifndef DIA_NISSAN_ECU_RESET_KEY_ON_OFF_RESET_H_
#include "project/services/customer/dia_NissanEcuResetKeyOnOffReset.h"
#endif

#ifndef DIA_ECU_RESET_CONFIG_TO_DELIVERY_STATE_H_
#include "project/services/customer/dia_EcuResetConfigToDeliveryState.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ECU_RESET_LISTENER__
#include <common/interfaces/dia_IEcuResetListener.h>
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginEcuResets)

//-----------------------------------------------------------------------------

dia_FactoryPluginEcuResets::dia_FactoryPluginEcuResets ( void )
   : dia_FactoryPlugin("dia_FactoryPluginEcuResets",DIA_EN_FACTORY_PLUGIN_TYPE_RESET),
     mpEcuResetMgr(0)
{
}

//-----------------------------------------------------------------------------

dia_FactoryPluginEcuResets::~dia_FactoryPluginEcuResets ( void )
{
   /*(void) tearDownObjects();*/
   mpEcuResetMgr = 0;
}

//-----------------------------------------------------------------------------

#define ADD_RESET(className, resetType) \
   { \
      className* pResetSrvHnd = OSAL_NEW className(#className, resetType); \
      if (DIA_SUCCESS!=mpEcuResetMgr->addReset(pResetSrvHnd)) failureCnt++; \
      mResetRep.push_back(pResetSrvHnd); \
   }

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginEcuResets::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginEcuResets::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF ECU RESET FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // get the pointer to the Reset manager
      mpEcuResetMgr = getInstanceOfEcuResetManager();
      if ( !mpEcuResetMgr )
      {
         DIA_TR_ERR("dia_FactoryPluginEcuResets::setup(DIA_EN_INITLEVEL_0) - creation of input/output control manager failed !!");
         return DIA_FAILED;
      }
   }

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      if  ( mpEcuResetMgr )
      {
         tU32 failureCnt = 0;

         DIA_TR_INF("###############################################");
         DIA_TR_INF("# ADDING RESET");
         DIA_TR_INF("###############################################");

         //lint -e429 custodial pointer is freed by this factory class
         ADD_RESET(dia_EcuResetHardResetPrj,       DIA_C_U8_UDS_RESET_HARD)
         ADD_RESET(dia_EcuResetFastShutdown,    DIA_C_U8_UDS_SHUTDOWN_FAST)
         ADD_RESET(dia_NissanEcuResetKeyOnOffReset,   DIA_C_U8_UDS_RESET_KEYONOFF)
         ADD_RESET(dia_EcuResetConfigToDeliveryState,    DIA_C_U8_SUBFUNC_AIVI_RESET_CONFIG_TO_DELIVERY_STATE)

         if (0!=failureCnt)
         {
            DIA_TR_ERR("##### AT LEAST ONE OF ADD_RESET WAS FAILED: failureCnt=%d #####", failureCnt );
            return DIA_FAILED;
         }
      }

      tDiaResult res = assignInterfaceAndNotifier<dia_IEcuReset,dia_IEcuResetListener,dia_IEcuResetNotifier>(mpEcuResetMgr);

      if (DIA_SUCCESS!=res)
      {
         DIA_TR_ERR("##### assignInterfaceAndNotifier FAILED #####");
         return DIA_FAILED;
      }
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginEcuResets::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginEcuResets::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_2 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_EcuResetPlugin,mResetRep)
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      // destroy the input output control manager object
      if ( mpEcuResetMgr )
      {
         releaseInstanceOfEcuResetManager();
         mpEcuResetMgr = 0;
      }
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}
