#ifndef __INCLUDED_FACTORY_PLUGIN_CORE_PROJECT__
#define __INCLUDED_FACTORY_PLUGIN_CORE_PROJECT__

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include "common/framework/factory/dia_FactoryPlugin.h"
#endif

class dia_Engine;
class dia_EngineConfiguration;
class dia_RemoteControl;
class dia_LineParser;
class dia_UpdatePlugin;
class dia_UpdateManager;

class dia_FactoryPluginCoreProject
   : public dia_FactoryPlugin
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_FactoryPluginCoreProject);

public:
   //! setup (create objects,...)
   virtual tDiaResult setup ( dia_enInitLevel level );
   //! tear down (destroy objects,...)
   virtual tDiaResult tearDown ( dia_enInitLevel level );

protected:
   //! class constructor
   dia_FactoryPluginCoreProject ( void );
   //! class destructor
   virtual ~dia_FactoryPluginCoreProject ( void );

   //! tear down all objects created by this class
//   tDiaResult tearDownObjects ( dia_enInitLevel level=DIA_EN_INITLEVEL_ALL );

   //! configure the ConfigManager
   virtual tDiaResult makeEngines ( void );
   //! configure the ConfigManager
   virtual tDiaResult setupConfigManager ( void );

protected:
   //! pointer to the remote control manager
   dia_RemoteControl* mpRemoteCtrl;
   //! list of engine objects
   std::list<dia_Engine*> mEngineRep;
   //! list of engine configuration objects
   std::list<dia_EngineConfiguration*> mEngineConfigRep;
   //! list of engine configuration objects
   std::list<dia_IDriver*> mDriverRep;
   //! pointer to the update manager
   dia_UpdateManager* pUpdateMgr;
   //! list of parsers objects
   std::list<dia_LineParser*> mParserRep;
   //! list of update strategies
   std::list<dia_UpdatePlugin*> mUpdatePluginRep;
};

#endif
