
#include "dia_FactoryPluginCoreProject.h"

#include <project/framework/config/dia_defsProjectConfig.h>
#include <project/framework/config/dia_EngineConfigGen3g.h>

#ifndef __INCLUDED_DIA_OSAL_DRIVER__
#include <common/framework/platform/osal/dia_OSALDriver.h>
#endif


#ifndef __INCLUDED_DIA_ENGINE_BODY_UDS__
#include "common/framework/protocols/uds/dia_EngineBodyUDS.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_OSAL_DRIVER_KDS__
#include <common/framework/platform/osal/dia_OSALDriverKDS.h>
#endif

#ifndef __INCLUDED_DIA_UPDATE_MANAGER__
#include "common/framework/update/dia_UpdateManager.h"
#endif

#ifndef __INCLUDED_DIA_KDS_MAP_PARSER__
#include "common/framework/update/dia_KdsMapParser.h"
#endif

#ifndef OSAL_GEN3_SIM
#ifndef __INCLUDED_DIA_SIMPLE_UPDATE_PLUGIN__
#include "common/framework/update/dia_SimpleUpdatePlugin.h"
#endif
#endif

#ifndef __INCLUDED_DIA_DS_MAP_PARSER__
#include "common/framework/update/dia_DsMapParser.h"
#endif

#ifndef OSAL_GEN3_SIM
#ifndef __INCLUDED_DIA_SIMPLE_DATASET_UPDATE_PLUGIN__
#include "common/framework/update/dia_SimpleDataSetUpdatePlugin.h"
#endif
#endif

#ifdef OSAL_GEN3_SIM
#ifndef __INCLUDED_DIA_UPDATE_PLUGIN_LSIM__
#include "common/framework/update/dia_KDSUpdatePluginLSIM.h"
#endif
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_REMOTECONTROL__
#include "common/framework/application/dia_RemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION_UDS__
#include "common/depricated/dia_tclDiagSessionUds.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG_REGISTRY__
#include "common/framework/config/dia_PropertyBagRegistry.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
#ifndef __INCLUDED_DIA_PROPERTY_ENGINE_CLIENT__
#include "common/framework/config/dia_PropertyBagEngineClient.h"
#endif
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__
#include <common/framework/engine/dia_EngineClientConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_INTERNAL_TESTER__
#include <common/framework/engine/dia_EngineInternalTester.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIG_INTERNAL_TESTER__
#include <project/framework/config/dia_EngineClientConfigInternalTester.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_AUDIO_MANAGER__
#include <common/framework/platform/cmd/dia_AudioManager.h>
#endif

#if 0  /* kaa1hi AIVI-59871 to be finished */
#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_XTRA_DATA__
#include <project/framework/factory/dia_FactoryPluginXtraData.h>
#endif
#endif

#ifndef __DIA_UNIT_TESTING__

#ifndef __INCLUDED_DIA_DATALOGGER__
#include <common/framework/datalogger/dia_DataLogger.h>
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG_KDS_VARLEN__
#include <common/framework/config/dia_PropertyBagKDSVarLen.h>
#endif

#ifndef __DIA_READCONFIGITEM_H___
#include "project/services/customer/dia_ReadConfigItem.h"
#endif

#ifndef __INCLUDED_DIA_SIGMA__
#include <project/framework/sigma/dia_Sigma.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
#ifndef __INCLUDED_DIA_VIN_ENGINE__
#include "project/framework/vin/dia_EngineVIN.h"
#endif
#endif

#endif // __DIA_UNIT_TESTING__

/* Project specific NRC mapping can be added here */
const dia_NRCConfig
aProjectNRCMapping[] =
{
    //{ DIA_E_ACCESS_SUBFUNC_NOT_SUPPORTED, DIA_E_U8_UDS_OUT_OF_RANGE }
};

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginCoreProject)

//-----------------------------------------------------------------------------

dia_FactoryPluginCoreProject::dia_FactoryPluginCoreProject ( void )
   : dia_FactoryPlugin("dia_FactoryPluginCoreProject",DIA_EN_FACTORY_PLUGIN_TYPE_CORE_PROJECT),
     mpRemoteCtrl(0),
    pUpdateMgr(0)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginCoreProject::~dia_FactoryPluginCoreProject ( void )
{
   /*(void) tearDownObjects();*/
   mpRemoteCtrl = 0;
   pUpdateMgr = 0;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginCoreProject::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginCoreProject::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF CORE PROJECT FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      (void) setupConfigManager();

      // create the diagnostic engine used for customer and production diagnosis
      (void) makeEngines();

      // load project specific NRC mapping
      getInstanceOfFactory()->loadNRCMappings(aProjectNRCMapping,sizeof(aProjectNRCMapping)/sizeof(dia_NRCConfig));

      dia::AudioManager::vLoadSourceMappings();
      dia::AudioManager::addAudioSourceMatcher(dia::AudioSourceMatcher("EXT_CD",dia_getHashCodeFromString("EXT_CD")));
      dia::AudioManager::addSourceMapping(0x18,dia_getHashCodeFromString("EXT_CD"),"EXT_CD");
      dia::AudioManager::addAudioSourceMatcher(dia::AudioSourceMatcher("SPARE_CD",dia_getHashCodeFromString("SPARE_CD")));
      dia::AudioManager::addSourceMapping(0x19,dia_getHashCodeFromString("SPARE_CD"),"SPARE_CD");
      dia::AudioManager::addAudioSourceMatcher(dia::AudioSourceMatcher("DTV",dia_getHashCodeFromString("DTV")));
      dia::AudioManager::addSourceMapping(0x1A,dia_getHashCodeFromString("DTV"),"DTV");
      dia::AudioManager::addAudioSourceMatcher(dia::AudioSourceMatcher("WX#0",dia_getHashCodeFromString("WX#0")));
      dia::AudioManager::addSourceMapping(0x06,dia_getHashCodeFromString("WX#0"),"WX#0");
      dia::AudioManager::addAudioSourceMatcher(dia::AudioSourceMatcher("MIC_PRIVATE_DIAG",dia_getHashCodeFromString("MIC_PRIVATE_DIAG")));
      dia::AudioManager::addSourceMapping(0x08,dia_getHashCodeFromString("MIC_PRIVATE_DIAG"),"MIC_PRIVATE_DIAG");
      // create session object. will be completely replaced by engine class later
      DIA_TR_INF("diagnostics_tclApp::bOnInit - Start Customer Session");
      diagnostics_tclApp* pMainApp = diagnostics_tclApp::getInstance();
      if ( pMainApp ) {
         // to meet customer performance criteria start now the engine to process customer requests
         pMainApp->poDiagSessionUds = getInstanceOfDiagSessionUDS();
         if ( OSAL_NULL != pMainApp->poDiagSessionUds )
         {
            // empty
         }
         else
         {
            DIA_TR_ERR(" #### pMainApp->poDiagSessionUds IS NULL #### ");
         }
      }

#if 0 //STC2HI: TODO
      // create remote control manager class
      mpRemoteCtrl = dia_RemoteControl::getInstance();
      if ( !mpRemoteCtrl ) {
         ETG_TRACE_ERR(("dia_FactoryPluginCoreProject::setup(DIA_EN_INITLEVEL_0) - creation of remote control failed !!"));
         return DIA_FAILED;
      }
#endif
   }

   if ( level == DIA_EN_INITLEVEL_1 || level == DIA_EN_INITLEVEL_ALL )
   {
   }

   if ( level == DIA_EN_INITLEVEL_4 || level == DIA_EN_INITLEVEL_ALL )
   {
      DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG UPDATE START");


      // get the pointer to the update manager
      pUpdateMgr = getInstanceOfUpdateManager();
      if ( !pUpdateMgr ) {
         DIA_TR_ERR("dia_FactoryPluginCoreProject::setup(DIA_EN_INITLEVEL_4) - creation of update manager failed !!");
         return DIA_FAILED;
      }

      //lint -e429 custodial pointer is freed by this factory class
#ifndef __DIA_UNIT_TESTING__
      DIA_TR_INF("###############################################");
      DIA_TR_INF("# ADDING UPDATE PLUGINS");
      DIA_TR_INF("###############################################");

#ifndef OSAL_GEN3_SIM
      dia_KdsMapParser* pLineParser = OSAL_NEW dia_KdsMapParser;
      DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG UPDATE 1");
      if ( pLineParser )
      {
         mParserRep.push_back(pLineParser);
         DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG UPDATE 2");
         dia_SimpleUpdatePlugin* pSimpleUpdateStrategy = OSAL_NEW dia_SimpleUpdatePlugin(pLineParser);
         DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG UPDATE 3");
         if ( pSimpleUpdateStrategy )
         {
            mUpdatePluginRep.push_back(pSimpleUpdateStrategy);
            DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG UPDATE 4");
            pUpdateMgr->addUpdatePlugin(pSimpleUpdateStrategy);
            DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG UPDATE 5");
         }
      }
#endif

#ifndef OSAL_GEN3_SIM
     dia_DsMapParser* pDsLineParser = OSAL_NEW dia_DsMapParser;
      DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- DS UPDATE 1");
      if ( pDsLineParser )
      {
         mParserRep.push_back(pDsLineParser);
         DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- DS UPDATE 2");
         dia_SimpleDataSetUpdatePlugin* pSimpleDataSetUpdateStrategy = OSAL_NEW dia_SimpleDataSetUpdatePlugin(pDsLineParser);
         DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- DS UPDATE 3");
         if ( pSimpleDataSetUpdateStrategy )
         {
            mUpdatePluginRep.push_back(pSimpleDataSetUpdateStrategy);
            DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- DS UPDATE 4");
            pUpdateMgr->addUpdatePlugin(pSimpleDataSetUpdateStrategy);
            DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- DS UPDATE 5");
         }
      }
#endif

#ifdef OSAL_GEN3_SIM
     dia_KdsMapParser* pLSIMLineParser = OSAL_NEW dia_KdsMapParser;
      DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG LSIM UPDATE 1");
      if ( pLSIMLineParser )
      {
         mParserRep.push_back(pLSIMLineParser);
         DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG LSIM UPDATE 2");
         dia_KDSUpdatePluginLSIM* pUpdateStrategyLSIM = OSAL_NEW dia_KDSUpdatePluginLSIM(pLSIMLineParser);
         DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG LSIM UPDATE 3");
         if ( pUpdateStrategyLSIM )
         {
            mUpdatePluginRep.push_back(pUpdateStrategyLSIM);
            DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG LSIM UPDATE 4");
            pUpdateMgr->addUpdatePlugin(pUpdateStrategyLSIM);
            DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG LSIM UPDATE 5");
         }
      }
#endif

      DIA_TR_INF("###############################################");
      DIA_TR_INF("# EXECUTE UPDATE STRATEGIES");
      DIA_TR_INF("###############################################");

      DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG UPDATE 6");

      (void) pUpdateMgr->runUpdate();
      DIA_TR_INF("# dia_FactoryPluginCoreProject::setup :- CONFIG UPDATE END");

      // Convert slot number to CAN generation
      {
         const tU32 propID = DIA_PROP_AIVI_VEHICLE_INFO;
         const tU32 propLenAiviVehInfo = 64;            // according definition in dia_defsProjectConfig.h
         const tU32 MaxSlotNumber = 10;
         const tU32 AIVI_VEHICLE_INFO__BYTE_OFFSET = 15; //according to CDD
         const eCanGen slot2CanGenMapping[MaxSlotNumber] =
         {
               AIVI_CAN_GEN_UNKNOWN,   //Slot 0
               AIVI_CAN_GEN_6,         //Slot 1
               AIVI_CAN_GEN_UNKNOWN,   //Slot 2
               AIVI_CAN_GEN_UNKNOWN,   //Slot 3
               AIVI_CAN_GEN_UNKNOWN,   //Slot 4
               AIVI_CAN_GEN_5,         //Slot 5
               AIVI_CAN_GEN_3,         //Slot 6
               AIVI_CAN_GEN_UNKNOWN,   //Slot 7
               AIVI_CAN_GEN_UNKNOWN,   //Slot 8
               AIVI_CAN_GEN_UNKNOWN,   //Slot 9
         };

         tU16 propLen = dia_getPropertySize(propID);
         if (propLenAiviVehInfo==propLen)
         {
            tU8 aiviVehicleInfo[propLenAiviVehInfo] = { 0 };
            tDiaResult getPropRes = dia_getProperty(propID, aiviVehicleInfo, propLen);

            if (DIA_SUCCESS == getPropRes)
            {
               tU8 slot = aiviVehicleInfo[AIVI_VEHICLE_INFO__BYTE_OFFSET];
               DIA_TR_INF("Convert slot number: V-CAN diversity = 0x%02X.", slot);

               if (slot<MaxSlotNumber)
               {
                  eCanGen canGen = slot2CanGenMapping[slot];
                  DIA_TR_INF("Convert slot number: Slot 0x%02X was mapped to CAN GEN 0x%02X.", slot, canGen);

                  if (DIA_SUCCESS!=dia_setProperty(DIA_PROP_AIVI_CAN_GEN_NUMBER, (tU8)canGen))
                  {
                     DIA_TR_ERR("Convert slot number: write of CAN GEN property (0x%08X) failed", DIA_PROP_AIVI_CAN_GEN_NUMBER);
                  }
                  else
                  {
                     DIA_TR_INF("Convert slot number: CAN GEN %d was write successfully.", canGen);
                  }
               }
               else
               {
                  DIA_TR_ERR("Convert slot number: Slot number (0x%02X) is wrong, because it is greater than 0x%02X.", slot, MaxSlotNumber);
               }
            }
            else
            {
               DIA_TR_ERR("Convert slot number: dia_getProperty(0x%08X) failed with retCode 0x%08X.", propID, getPropRes);
            }
         }
         else
         {
            DIA_TR_ERR("Convert slot number: property (0x%08X) length different than expected!", propID);
            DIA_TR_ERR("Convert slot number: property current len is %d and exp len is %d.", propLen, propLenAiviVehInfo);
         }
      }
	  
#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT

	  dia_EngineVIN* _poVinEngine = dia_EngineVIN::getInstance();
	  if( _poVinEngine == 0 )
	  {
		  DIA_TR_ERR("ERROR - dia_FactoryPluginCoreProject::setup: Cannot create VIN ENGINE ");
          return DIA_FAILED;
	  }
#endif

      if(dia_Sigma::isConfigured())
      {
         dia_DataLogger* pDataLogger = getInstanceOfDataLogger();
         if(pDataLogger == 0)
         {
            DIA_TR_ERR("ERROR - dia_FactoryPluginCoreProject::setup: Cannot create SIGMA object");
            return DIA_FAILED;
         }
         pDataLogger->startLogging();

         dia_Sigma* pSigma = getInstanceOfSigma();
         if(pSigma == 0)
         {
            DIA_TR_ERR("ERROR - dia_FactoryPluginCoreProject::setup: Cannot create SIGMA object");
            return DIA_FAILED;
         }
         pSigma->start();
      }

#if 0  /* kaa1hi AIVI-59871 to be finished */
      DIA_TR_INF("Create Plugin Xtra Data");
      dia::FactoryPluginXtraData* xtraDataFactory = getInstanceOfFactoryPluginXtraData();
      if ( xtraDataFactory )
      {
         xtraDataFactory->addPDXFolder(std::string("/var/opt/bosch/persistent/diagnosis/swu/xtradata/"));
      }
#endif
#endif   // __DIA_UNIT_TESTING__

      //lint -e429 custodial pointer is freed by this factory class
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginCoreProject::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginCoreProject::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      DIA_TR_INF("dia_FactoryPluginCoreProject::tearDown DIA_EN_INITLEVEL_0");

      if ( mpRemoteCtrl )
      {
         dia_RemoteControl::deleteInstance();
         mpRemoteCtrl = 0;
      }

      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_Engine,mEngineRep)
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_EngineConfiguration,mEngineConfigRep)
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_IDriver,mDriverRep)

      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_LineParser,mParserRep)
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_UpdatePlugin,mUpdatePluginRep)
      // destroy the update manager object
      dia_UpdateManager::deleteInstance();

      releaseInstanceOfDiagSessionUDS();
#ifndef __DIA_UNIT_TESTING__
      releaseInstanceOfdiaEngineInternalTesterConfiguration();
#endif
   }

   if ( level == DIA_EN_INITLEVEL_4 || level == DIA_EN_INITLEVEL_ALL )
   {
      DIA_TR_INF("dia_FactoryPluginCoreProject::tearDown DIA_EN_INITLEVEL_4");

#ifndef __DIA_UNIT_TESTING__

#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
    dia_EngineVIN* _poVinEngine = dia_EngineVIN::getInstance();
	 if( _poVinEngine )
	 {
		  dia_EngineVIN::deleteInstance();
        _poVinEngine = 0;
	 }
#endif
	  
      if(dia_Sigma::isConfigured())
      {
         dia_Sigma* pSigma = getInstanceOfSigma();
         if(pSigma != 0)
         {
            pSigma->stop();
            releaseInstanceOfSigma();
         }

         dia_DataLogger* pDataLogger = getInstanceOfDataLogger();
         if(pDataLogger != 0)
         {
            pDataLogger->stopLogging();
            releaseInstanceOfDataLogger();
         }
      }
#endif
      // destroy the update manager object
      if ( pUpdateMgr ) {
         dia_UpdateManager::deleteInstance();
         pUpdateMgr = 0;
      }
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginCoreProject::setupConfigManager ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginCoreProject::setupConfigManager");

   dia_ConfigManager* pConfigMgr = getInstanceOfConfigManager();

   if ( pConfigMgr )
   {
      // load project specific configuration items
      pConfigMgr->loadProperties(aDiaGen3gPropData,sizeof(aDiaGen3gPropData)/sizeof(dia_PropertyInfo));

      dia_PropertyBagRegistry* pRegistry = OSAL_NEW dia_PropertyBagRegistry;
      if ( pRegistry )
      {
         DIA_TR_INF("dia_FactoryPluginCoreProject: Registry Property Bag Created !!");

         pRegistry->loadRegKeys(aCommonRegKeyData,sizeof(aCommonRegKeyData)/sizeof(dia_RegKeyInfo));
         //pRegistry->loadRegKeys(aNissanRegKeyData,sizeof(aNissanRegKeyData)/sizeof(dia_RegKeyInfo));
		 /* Added project specific registry keys for Center CM C-19 */
		 pRegistry->loadRegKeys(aCommonRegKeyDataCenterCMC19,sizeof(aCommonRegKeyDataCenterCMC19)/sizeof(dia_RegKeyInfo));
         pRegistry->loadRegPaths(aCommonRegPathData,sizeof(aCommonRegPathData)/sizeof(dia_RegPathInfo));	 


         // add this plugin to the ConfigManager (instance will be destroyed by ConfigManager destructor)
         pConfigMgr->addPropertyBag(pRegistry);
      }
      else
      {
         DIA_TR_INF("dia_FactoryPluginCoreProject: Failed to create Registry Property Bag !");
      }

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
      dia_PropertyBagEngineClient* pEngineClient = OSAL_NEW dia_PropertyBagEngineClient();
      if ( pEngineClient)
      {
         DIA_TR_INF("dia_FactoryPluginCoreProject: Engine Client Property Bag Created !!");

         // add this plugin to the ConfigManager (instance will be destroyed by ConfigManager destructor)
         pConfigMgr->addPropertyBag(pEngineClient);
      }
      else
      {
         DIA_TR_INF("dia_FactoryPluginCoreProject: Failed to create Engine Client Property Bag !");
      }
#endif

#ifndef __DIA_UNIT_TESTING__
      dia_OSALDriver*     pDrvKDS          = OSAL_NEW dia_OSALDriver(OSAL_C_STRING_DEVICE_KDS);
      dia_OSALDriverKDS*  pDrvKDSDecorator = OSAL_NEW dia_OSALDriverKDS(pDrvKDS);
      dia_PropertyBagKDS* pPropBagKDS      = OSAL_NEW dia_PropertyBagKDS(pDrvKDSDecorator);
      mDriverRep.push_back(pDrvKDSDecorator);
      mDriverRep.push_back(pDrvKDS);

      if ( pPropBagKDS )
      {
         DIA_TR_INF("dia_FactoryPluginCoreProject: KDS Property Bag Created !!");

         // add this plugin to the ConfigManager (instance will be destroyed by ConfigManager destructor)
         pConfigMgr->addPropertyBag(pPropBagKDS);
         pConfigMgr->setInterface<dia_IKDS>(pPropBagKDS);

         dia::PropertyBagKDSVarLen* propBagKDSVarLen = OSAL_NEW dia::PropertyBagKDSVarLen(*pPropBagKDS);
         if ( propBagKDSVarLen )
         {
            DIA_TR_INF("dia_FactoryPluginCoreProject: KDS VarLen Property Bag Created !!");

            // add this plugin to the ConfigManager (instance will be destroyed by ConfigManager destructor)
            pConfigMgr->addPropertyBag(propBagKDSVarLen);
         }

         propBagKDSVarLen = 0; //lint !e423 Warning: no creation of memory leak in assignment, because object lifetime is controlled by ConfigManager
      } //lint !e438 Warning: last value assigned to variable 'propBagKDSVarLen'

      dia_PropertyBagGPIO* pGPIO = OSAL_NEW dia_PropertyBagGPIO;
      if ( pGPIO )
      {
         DIA_TR_INF("dia_tclFactoryPlugin: GPIO Property Bag Created !!");
#if 0 //STC2HI: TODO
         pGPIO->loadGPIOKeys(aNissanGPIOData,sizeof(aNissanGPIOData)/sizeof(dia_RegKeyInfo));
#endif //STC2HI: TODO
         pGPIO->loadGPIOPaths(aCommonRegPathData,sizeof(aCommonRegPathData)/sizeof(dia_RegPathInfo));

         // add this plugin to the ConfigManager (instance will be destroyed by ConfigManager destructor)
         pConfigMgr->addPropertyBag(pGPIO);
      }

      dia_PropertyBagADC* pADC = OSAL_NEW dia_PropertyBagADC;
      if ( pADC )
      {
         DIA_TR_INF("dia_tclFactoryPlugin: ADC Property Bag Created !!");

         // add this plugin to the ConfigManager (instance will be destroyed by ConfigManager destructor)
         pConfigMgr->addPropertyBag(pADC);
      }

      dia_PropertyBagFile* pFile = OSAL_NEW dia_PropertyBagFile;
      if ( pFile )
      {
         DIA_TR_INF("dia_tclFactoryPlugin: File Property Bag Created !!");

         // add this plugin to the ConfigManager (instance will be destroyed by ConfigManager destructor)
         pConfigMgr->addPropertyBag(pFile);
      }

      dia_ReadConfigItem* pItem = OSAL_NEW dia_ReadConfigItem;
      if( pItem )
      {
         DIA_TR_INF("dia_tclFactoryPlugin: Read ConfigItem Created !!");

         pConfigMgr->setInterface<dia_IConfigItem>(pItem);
      }

      //To change pConfigMgr->setInterface<dia_IKDS>

      pRegistry = 0; //lint !e423 Warning: no creation of memory leak in assignment, because object lifetime is controlled by ConfigManager
      pPropBagKDS = 0; //lint !e423 Warning: no creation of memory leak in assignment, because object lifetime is controlled by ConfigManager
      pGPIO = 0;     //lint !e423 Warning: no creation of memory leak in assignment, because object lifetime is controlled by ConfigManager
      pADC = 0;      //lint !e423 Warning: no creation of memory leak in assignment, because object lifetime is controlled by ConfigManager
      pFile = 0;      //lint !e423 Warning: no creation of memory leak in assignment, because object lifetime is controlled by ConfigManager
      pDrvKDS = 0;          //lint !e423 Warning: no creation of memory leak in assignment, because object is destroyed in tearDown method
      pDrvKDSDecorator = 0; //lint !e423 Warning: no creation of memory leak in assignment, because object is destroyed in tearDown method
      pItem = 0; //lint !e423 Warning: no creation of memory leak in assignment, because object is destroyed in tearDown method
#endif
   } //lint !e438 Warning: last value assigned to variable 'pADC', 'pGPIO', 'pKDS', 'pRegistry' not used

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginCoreProject::makeEngines ( void )
{
   dia_tclFnctTrace oTrace("dia_tclFactoryPlugin::makeEngines");

   tDiaResult retCode = DIA_FAILED;

   //
   // UDS engine for production diagnosis
   //

   dia_EngineConfigGen3g* pConfig = OSAL_NEW dia_EngineConfigGen3g;
   if ( pConfig )
   {
      // add engine configurations to repository for proper shutdown
      mEngineConfigRep.push_back(pConfig);

      dia_EngineServer* pEngine = OSAL_NEW dia_EngineServer(DIA_NAME_ENGINE_CUSTOMER_UDS,*pConfig);
      if ( pEngine )
      {
         // add engine instance to the engine repository for proper shutdown
         mEngineRep.push_back(pEngine);

         // instantiate the protocol state machine
         dia_EngineBodyUDS* pBodyUDS = OSAL_NEW dia_EngineBodyUDS(*pEngine);
         if ( pBodyUDS )
         {
            // compose concrete engine
            pEngine->setBody(*pBodyUDS);
         // pEngine->setMessageProcessor(enMsgProcID_WorkerUDS);

            dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
            if ( pEngineMgr )
            {
               // register created engines at the engine controller
               pEngineMgr->addEngine(*pEngine);
            }

            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_INF("### FAILED TO CREATE ENGINE BODY OBJECT !!! ###");
         }

         // make lint happy
         pBodyUDS = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pBodyUDS'. --> lifetime is controlled by instance of this class

      } //lint !e438 Warning: last value assigned to variable 'pBodyUDS' not used
      else
      {
         DIA_TR_INF("### FAILED TO CREATE ENGINE OBJECT !!! ###");
      }

      // make lint happy
      pEngine = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pEngine'. --> lifetime is controlled by instance of this class

   } //lint !e438 Warning: last value assigned to variable 'pEngine' not used
   else
   {
      DIA_TR_INF("### FAILED TO CREATE ENGINE CONFIGURATION OBJECT !!! ###");
   }

#ifndef __DIA_UNIT_TESTING__
   dia_EngineClientConfiguration* pEngineClientConfiguration = OSAL_NEW dia_EngineClientConfiguration("dia_EngineClientConfiguration", DIA_EN_PROTOCOL_UDS);

   if(pEngineClientConfiguration)
   {
      dia_EngineInternalTester* pEngineInternalTester = OSAL_NEW dia_EngineInternalTester("dia_EngineInternalTester", *pEngineClientConfiguration);
      if(pEngineInternalTester)
      {
         (void) pEngineInternalTester->setup();
         (void) getInstanceOfFactory()->assignInterfaceImplementation<dia_IInternalTester>(pEngineInternalTester);

         dia_EngineClientConfigInternalTester* pInternalTester = getInstanceOfdiaEngineInternalTesterConfiguration();
         if ( OSAL_NULL != pInternalTester )
         {
            // empty
         }
         else
         {
            DIA_TR_ERR(" #### pInternalTester IS NULL #### ");
         }
         //(void) getInstanceOfdiaEngineInternalTeseterConfiguration()->loadIntClientEngineConfigServiceInfo(aInternalClientserviceInfoRep, sizeof(aInternalClientserviceInfoRep)/sizeof(InternalClientServiceInfo));
         //(void) getInstanceOfdiaEngineInternalTeseterConfiguration()->loadIntClientEngineConfigServiceData(aInternalClientServiceDataItem, sizeof(aInternalClientServiceDataItem)/sizeof(InternalClientServiceDataItem));
      }
   }

   // make lint happy
   pEngineClientConfiguration = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pEngineClientConfiguration'. --> lifetime is controlled by instance of this class
#endif
   pConfig = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pConfig'. --> lifetime is controlled by instance of this class

   return retCode; //lint !e438 Warning: last value assigned to variable 'pConfig' not used
}
