/**
 * \file      dia_FactoryObjectSAVehicleData.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 *      -----------------------------------------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      14.12.2015  bsu9kor		Added code to implement setHMIlanguage service
 *
 *      ------------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureVehicleData.h"

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_VEHICLEDATA__
#include "dia_FactoryObjectSAVehicleData.h"
#endif

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_BUS_STATE__
#include "project/interfaces/dia_INissanBusStateListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE_LISTENER__
#include "project/interfaces/dia_INissanLanguageListener.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAVehicleData)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAVehicleData::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAVehicleData::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_VEHICLE_DATA_MINOR_VERSION = 0;
   static const tU16 CCA_C_U16_SRV_VEHICLE_DATA_MAJOR_VERSION = 1;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SA_VEH_D",
         CCA_C_U16_APP_VD_VEHICLE_DATA
   );

   //
   // Service Plugins
   //

   // vehicle data standard service
   dia_SystemAdapterServicePlugin* pSAVehicleDataService = pFactory->createSystemAdapterServicePlugin(
         "DIA_SAHVehDSrv",
         CCA_C_U16_SRV_VEHICLE_DATA,
         CCA_C_U16_SRV_VEHICLE_DATA_MAJOR_VERSION,
         CCA_C_U16_SRV_VEHICLE_DATA_MINOR_VERSION,
         mpObj
   );

   if (pSAVehicleDataService)
   {
      pSAVehicleDataService->setCondVarRetries(20);
   }

#if defined (__ENABLE_FEATURE_SYSSET_INCLUDE_VEHICLE_DATA__) || defined(__ENABLE_FEATURE_CONFIG_NOTIFICATION_INCLUDE_VEHICLE_DATA__)
   // vehicle data diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSAVehicleDataServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SAVehDataSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
   );
#endif

   // Feature Plugins
   //

   // feature implementation for the Reverse Gear base services

   dia_SAFeatureVehicleData* pSAFeatureVehicleData = pFactory->createSystemAdapterFeature < dia_SAFeatureVehicleData > (
         "SAFeatureVehD",
         pSAVehicleDataService
         );

   if (pSAFeatureVehicleData)
   {
      (void) assignInterfaceAndNotifier <dia_INissanVCanInfo,dia_INissanVCanInfoListener,dia_NissanVCanInfoNotifier> (pSAFeatureVehicleData);
      (void) assignInterfaceAndNotifier <dia_IParkingBrake,dia_IParkingBrakeListener,dia_IParkingBrakeNotifier> (pSAFeatureVehicleData);
      (void) assignInterfaceAndNotifier <dia_IReverseGear,dia_IReverseGearListener,dia_IReverseGearNotifier> (pSAFeatureVehicleData);
      (void) assignNotifier<dia_INissanBusStateListener, dia_NissanBusStateNotifier>();
      (void) assignInterfaceAndNotifier <dia_INissanLanguage,dia_INissanLanguageListener,dia_INissanLanguageNotifier> (pSAFeatureVehicleData);
      (void) assignInterfaceAndNotifier <dia_ISensorSpeed,dia_ISensorSpeedListener,dia_ISensorSpeedNotifier> (pSAFeatureVehicleData);
      (void) assignInterfaceAndNotifier <dia_IVehicleClient,dia_IVehicleClientListener,dia_IVehicleClientNotifier> (pSAFeatureVehicleData);
   }

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_VEHICLE_DATA__
   //--- system settings feature via the diaglib service ----------------------
   dia_SAFeatureSystemSettings* pSAFeatureVehicleDataSystemSettings = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings> (
         "SAFeatureVehDatSysset",
         SYSSETID_VEHI_FUNC_EXTE,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT |
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION |
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSAVehicleDataServiceDiagLib
   );

   if ( pSAFeatureVehicleDataSystemSettings ) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureVehicleDataSystemSettings);
   }
#endif

#ifdef __ENABLE_FEATURE_CONFIG_NOTIFICATION_INCLUDE_VEHICLE_DATA__
   dia_SAFeatureCodingUpdate* pSAFeatureVehicleDataConfigUpdate = pFactory->createSystemAdapterConfigUpdateFeature<dia_SAFeatureCodingUpdate>(
         "SAFeatureVehicleDataConfigUpdate",
         DIA_PROP_NISSAN_VEHICLE_INFO,
         SYSSETID_VEHI_FUNC_EXTE,
         pSAVehicleDataServiceDiagLib
   );

   if (pSAFeatureVehicleDataConfigUpdate) {
      (void) getInstanceOfConfigManager()->addConfigNotifier(pSAFeatureVehicleDataConfigUpdate);
   }

   dia_SAFeatureCodingUpdate* pSAFeatureConfigPartNumberUpdate = pFactory->createSystemAdapterConfigUpdateFeature<dia_SAFeatureCodingUpdate>(
         "SAFeatureConfigPartNumberUpdate",
         DIA_PROP_NISSAN_PARTS_NUMBER,
         SYSSETID_VEHICLE_CFG_PRTNUM,
         pSAVehicleDataServiceDiagLib
   );

   if (pSAFeatureConfigPartNumberUpdate) {
      (void) getInstanceOfConfigManager()->addConfigNotifier(pSAFeatureConfigPartNumberUpdate);
   }

#endif

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAVehicleData::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAVehicleData::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



