/**
 * \file      dia_FactoryObjectSAVDDeviceMGR.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif


#ifndef DIA_SAFEATUREDEVICEMGR_H_
#include "common/framework/sysadapters/dia_SAFeatureDeviceMGR.h"
#endif

#ifndef DIA_SAFEATUREVDDEVICEMANAGER_H_
#include "common/framework/sysadapters/dia_SAFeatureVDDeviceMGR.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_VDDEVICEMGR__
#include "dia_FactoryObjectSAVDDeviceMGR.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_SERVICEINFO
#include "mplay_fi_if.h"

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAVDDeviceMGR)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAVDDeviceMGR::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAVDDeviceMGR::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_VDDMGR_MAJOR_VERSION = MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_MAJORVERSION;
   static const tU16 CCA_C_U16_SRV_VDDMGR_MINOR_VERSION = MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_MINORVERSION;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
           "DIA_SAVDDMGR",
           CCA_C_U16_APP_DEVICEMANAGER
           );

   //
   // Service Plugins
   //

   dia_SystemAdapterServicePlugin* pSAVDDMGRService = pFactory->createSystemAdapterServicePluginNoMonitoring (
           "DIA_SAVDDMGRSrv",
           CCA_C_U16_SRV_DEVICEMANAGER,
           CCA_C_U16_SRV_VDDMGR_MAJOR_VERSION,
           CCA_C_U16_SRV_VDDMGR_MINOR_VERSION,
           mpObj
           );

   // device manager diaglib standard service
   dia_SystemAdapterServicePluginDiaglib* pSAVDDeviceMGRServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         //"DIA_SAVDDeviceManagerSrvDiagLib",
         "DIA_SAVDDeviceMGRSrvDiagLib", //String length should be less than 32, else OSAL error: NAMETOOLONG
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
   );

   //
   // Feature Plugins
   //

   // add feature for basic Audio functionality
   dia_SAFeatureDeviceMGR* pSAFeatureVDDMGR = pFactory->createSystemAdapterFeature<dia_SAFeatureDeviceMGR> (
           "SAFeatureVDDMGR",
           pSAVDDMGRService
           );

   if ( pSAFeatureVDDMGR ) {
       (tVoid) assignInterfaceAndNotifier<dia_IDeviceMGR,dia_IDeviceMGRListener,dia_IDeviceMGRNotifier>(pSAFeatureVDDMGR);
   }

    //Diaglib antenna feed feature
   dia_SAFeatureVDDeviceMGR* pSAVDDeviceMGRDiaglib = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureVDDeviceMGR>(
         "SAVDDeviceMGRDiaglib",
         pSAVDDeviceMGRServiceDiagLib
   );

   if ( pSAVDDeviceMGRDiaglib )
   {
      (tVoid) assignInterfaceAndNotifier<dia_IDeviceMGRUSB,dia_IDeviceMGRUSBListener,dia_IDeviceMGRUSBNotifier>(pSAVDDeviceMGRDiaglib);
   }

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAVDDeviceMGR::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAVDDeviceMGR::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}
