/**
 * \file      dia_FactoryObjectSATunerXM.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 *      --------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *		08.01.2016	bsu9kor		Added header guards for TunerXM SA. (AIVI-11617)
 *   	----------------------------------------------------------------------------------------
 */

/*
#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif
*/

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

/*
#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif
*/
#ifndef DIA_SAFEATURETUNERXM_H_
#include "project/framework/sysadapters/dia_SAFeatureTunerXM.h"
#endif

#ifndef DIA_SAFEATURETUNERXMCONTROL_H_
#include "project/framework/sysadapters/dia_SAFeatureTunerXMControl.h"
#endif

//#include "project/framework/sysadapters/dia_SAFeatureDefaultSettingControl.h"

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TUNER_XM__
#include "dia_FactoryObjectSATunerXM.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_SERVICEINFO
#include "midw_ext_fi_if.h"

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSATunerXM)

//-----------------------------------------------------------------------------

tDiaResult dia_FactoryObjectSATunerXM::setup(tVoid)
{
   dia_tclFnctTrace trc("dia_FactoryObjectSATunerXM::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_SXM_AUDIO_MAJOR_VERSION = MIDW_EXT_SXM_AUDIOFI_C_U16_SERVICE_MAJORVERSION;
   static const tU16 CCA_C_U16_SRV_SXM_AUDIO_MINOR_VERSION = MIDW_EXT_SXM_AUDIOFI_C_U16_SERVICE_MINORVERSION;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter(
         "DIA_SATunerXM",
         CCA_C_U16_APP_FC_SXM
         );

   //
   // Service Plugins == Communication Channels
   //

   // XM tuner standard service
   dia_SystemAdapterServicePlugin* pSATunerXMService = pFactory->createSystemAdapterServicePlugin(
         "DIA_SATunerXMSrv",
         CCA_C_U16_SRV_SXM_AUDIO,
         CCA_C_U16_SRV_SXM_AUDIO_MAJOR_VERSION,
         CCA_C_U16_SRV_SXM_AUDIO_MINOR_VERSION,
         mpObj
         );

   // XM tuner diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSATunerXMServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib(
         "DIA_SATunerXMSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
         );

   //
   // Feature Plugins
   //

   // feature implementation for the XM base services
   dia_SAFeatureTunerXM* pSAFeatureTunerXM = pFactory->createSystemAdapterFeature<dia_SAFeatureTunerXM>(
         "SAFeatureTunerXM",
         pSATunerXMService
         );

   if (pSAFeatureTunerXM) {
      (tVoid) assignInterfaceAndNotifier<dia_ITunerXM, dia_ITunerXMListener, dia_ITunerXMNotifier>(pSAFeatureTunerXM);
   }

   // add feature implementation for the diaglib services
   dia_SAFeatureTunerXMControl* pSAFeatureTunerXMControl = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureTunerXMControl>(
         "SAFeatureTunerXMControl",
         pSATunerXMServiceDiagLib
         );

   if (pSAFeatureTunerXMControl) {
      (tVoid) assignInterfaceAndNotifier<dia_ITunerXMControl, dia_ITunerXMControlListener, dia_ITunerXMControlNotifier>(pSAFeatureTunerXMControl);
   }


#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_TUNER_XM__
   // system settings feature via the diaglib service
   dia_SAFeatureSystemSettings* pSAFeatureTunerXMSysset = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings>(
         "SAFeatureTunerXMSysset",
         SYSSETID_TUNE_XM,
#if 0 //STC2HI: Not supported
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT |
#endif
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION |
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSATunerXMServiceDiagLib
         );

   if (pSAFeatureTunerXMSysset) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureTunerXMSysset);
   }
#endif

#ifdef __ENABLE_FEATURE_REMOTE_CONTROL_INCLUDE_TUNER_XM__
   dia_SAFeatureRemoteControl* pSAFeatureRemoteCtrl = pFactory->createSystemAdapterRemoteControlFeature<dia_SAFeatureRemoteControl> (
         "SAFeatureTunerXMRemoteControl",
         pSATunerXMServiceDiagLib
         );

   if ( pSAFeatureRemoteCtrl )
   {
      (tVoid) dia_RemoteControl::getInstance()->addRemoteControlPlugin(pSAFeatureRemoteCtrl);
   }
#endif

/*   // add feature implementation for SXM default setting services
   dia_SAFeatureDefaultSettingControl* pSAFeatureDefaultSettingControl = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureDefaultSettingControl>(
         "SAFeatureDefaultSettingControl",
         pSATunerXMServiceDiagLib
         );

   if (pSAFeatureDefaultSettingControl) {
      (tVoid) assignInterfaceAndNotifier<dia_IDefaultSettingControl, dia_IDefaultSettingControlListener, dia_IDefaultSettingControlNotifier>(pSAFeatureDefaultSettingControl);
   }*/

   //
   // Prepare Environment
   //
/*
#ifdef __ENABLE_FEATURE_NISSAN_TUNERXM_UPDATE_TESTMODE__
   DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - TUNERXM_UPDATE_TESTMODE active.");
   tU8 propValueString[DIA_PROP_LENGTH_MAX_REG] = { 0 };
   tU8 propValueVersion[DIA_PROP_LENGTH_MAX_REG] = { 0 };

   // Test if registry items exist and are filled
   if (dia_ConfigManager::getProperty(DIA_PROP_CM_SXM_SW_DOWNLOAD_STRING, *propValueString) == DIA_SUCCESS) {
//      DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - Registry item \"FILE\" EXISTS.");
   } else {
      DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - Registry item \"FILE\" is empty -> fill it.");

      std::string newFile = "/var/opt/bosch/static/siriusxm/C65firmware_X65H2i_v9.12.132.bin";
      std::vector<tU8> vecFile;

      for (tU8 i = 0; i < newFile.length(); i++) {
         vecFile.push_back((tU8)newFile.at(i));
      }

      if (dia_ConfigManager::setProperty(DIA_PROP_CM_SXM_SW_DOWNLOAD_STRING, vecFile) == DIA_SUCCESS) {
//         DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - New FILE successfully set.");
      } else {
         DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - FAILURE WITH REG-WRITING!");
      }
   }

   if (dia_ConfigManager::getProperty(DIA_PROP_CM_SXM_SW_DOWNLOAD_VERSION, *propValueVersion) == DIA_SUCCESS) {
//      DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - Registry item \"VERSION\" EXISTS.");
   } else {
      DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - Registry item \"VERSION\" is empty -> fill it.");

      std::string newVersion = "x09-0c-84";
      std::vector<tU8> vecVers;

      for (tU32 i = 0; i < newVersion.length(); i++) {
         vecVers.push_back((tU8)newVersion.at(i));
      }

      if (dia_ConfigManager::setProperty(DIA_PROP_CM_SXM_SW_DOWNLOAD_VERSION, vecVers) == DIA_SUCCESS) {
//         DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - New VERSION successfully set.");
      } else {
         DIA_TR_INF("dia_FactoryObjectSATunerXM::setup - FAILURE WITH REG-WRITING!");
      }
   }
#endif
*/


   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_FactoryObjectSATunerXM::tearDown(tVoid)
{
   dia_tclFnctTrace trc("dia_FactoryObjectSATunerXM::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}

