/**
 * \file      dia_FactoryObjectSATunerMaster.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      31.01.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureTunerMaster.h"
#include "project/framework/sysadapters/dia_SAFeatureTunerMasterControl.h"

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TUNER_MASTER__
#include "dia_FactoryObjectSATunerMaster.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSATunerMaster)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSATunerMaster::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSATunerMaster::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_TUNERMASTERCONTROL_MAJOR_VERSION = 3;
   static const tU16 CCA_C_U16_SRV_TUNERMASTERCONTROL_MINOR_VERSION = 0;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter(
         "DIA_SATunerMaster",
         CCA_C_U16_APP_TUNERMASTER
   );

   //
   // Service Plugins
   //

   // tuner tunermaster service
   dia_SystemAdapterServicePlugin* pSATunerMasterService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SATunerMasterSrv",
         CCA_C_U16_SRV_TUNERMASTERCONTROL,
         CCA_C_U16_SRV_TUNERMASTERCONTROL_MAJOR_VERSION,
         CCA_C_U16_SRV_TUNERMASTERCONTROL_MINOR_VERSION,
         mpObj
   );

   // tuner diaglib standard service
   dia_SystemAdapterServicePluginDiaglib* pSATunerMasterServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SATunerMasterSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
   );

   //
   // Feature Plugins
   //

   // tuner master feature
   dia_SAFeatureTunerMaster* pSAFeatureTunerMaster = pFactory->createSystemAdapterFeature<dia_SAFeatureTunerMaster> (
         "pSAFeatureTunerMaster",
         pSATunerMasterService
   );

   if ( pSAFeatureTunerMaster ) {
      (tVoid) assignInterfaceAndNotifier<dia_ITunerMaster,dia_ITunerMasterListener,dia_ITunerMasterNotifier>(pSAFeatureTunerMaster);
   }

   // Diaglib antenna feed feature
   dia_SAFeatureTunerMasterControl* pSATunerMasterDiaglib = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureTunerMasterControl>(
         "pSATunerMasterDiaglib",
         pSATunerMasterServiceDiagLib
   );

   if ( pSATunerMasterDiaglib ) {
      (tVoid) assignInterfaceAndNotifier<dia_ITunerMasterControl,dia_ITunerMasterControlListener,dia_ITunerMasterControlNotifier>(pSATunerMasterDiaglib);
   }


#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_TUNER_MASTER__
   //--- system settings feature via the diaglib service ----------------------
   dia_SAFeatureSystemSettings* pSAFeatureTunerMasterSysset = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings>(
         "SAFeatureTunerMasterSysset",
         SYSSETID_TUNE_MASTER,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSATunerMasterServiceDiagLib
   );

   if (pSAFeatureTunerMasterSysset) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureTunerMasterSysset);
   }
#endif

#ifdef __ENABLE_FEATURE_REMOTE_CONTROL_INCLUDE_TUNER_MASTER__
   dia_SAFeatureRemoteControl* pSAFeatureRemoteCtrl = pFactory->createSystemAdapterRemoteControlFeature<dia_SAFeatureRemoteControl> (
         "SAFeatureTunerMasterRemoteControl",
         DIA_EN_REMOTE_PLUGIN_TUNER_MASTER,
         pSATunerMasterServiceDiagLib
   );

   if ( pSAFeatureRemoteCtrl )
   {
      (tVoid) dia_RemoteControl::getInstance()->addRemoteControlPlugin(pSAFeatureRemoteCtrl);
   }
#endif

#ifdef __ENABLE_FEATURE_CONFIG_NOTIFICATION_INCLUDE_TUNER_MASTER__
   dia_SAFeatureCodingUpdate* pSAFeatureTunerMasterConfigUpdate = pFactory->createSystemAdapterConfigUpdateFeature<dia_SAFeatureCodingUpdate>(
         "SAFeatureTunerMasterConfigUpdate",
         DIA_PROP_NISSAN_FMAMTUNER_PARAM_SET,
         SYSSETID_TUNE_MASTER,
         pSATunerMasterServiceDiagLib
   );

   if (pSATunerMasterServiceDiagLib) {
      (tVoid) dia_ConfigManager::getInstance()->addConfigNotifier(pSAFeatureTunerMasterConfigUpdate);
   }
#endif

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSATunerMaster::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSATunerMaster::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



