/**
 * \file      dia_FactoryObjectSATunerDAB.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      31.01.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#ifndef DIA_SAFEATURETUNERDAB_H_
#include "project/framework/sysadapters/dia_SAFeatureTunerDAB.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef DIA_SAFEATURETUNERDABCONTROL_H_
#include "project/framework/sysadapters/dia_SAFeatureTunerDABControl.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_TUNER_DAB__
#include "dia_FactoryObjectSATunerDAB.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSATunerDAB)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSATunerDAB::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSATunerDAB::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_TUNER_DAB_MAJOR_VERSION = 2;
   static const tU16 CCA_C_U16_SRV_TUNER_DAB_MINOR_VERSION = 0;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SATunerDAB",
         CCA_C_U16_APP_FC_DABTUNER
   );

   //
   // Service Plugins
   //

   // DAB tuner standard service
   dia_SystemAdapterServicePlugin* pSADABTunerService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SATunerDABSrv",
         CCA_C_U16_SRV_DAB_TUNER,
         CCA_C_U16_SRV_TUNER_DAB_MAJOR_VERSION,
         CCA_C_U16_SRV_TUNER_DAB_MINOR_VERSION,
         mpObj
   );

   // DAB tuner diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSATunerDABServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SATunerDABSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
   );

   // Feature Plugins

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_TUNER_DAB__
   //--- system settings feature via the diaglib service ----------------------
   dia_SAFeatureSystemSettings* pSAFeatureDABTunerSysset = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings>(
         "SAFeatureTunerDABSysset",
         SYSSETID_TUNE_DAB,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT,
         pSATunerDABServiceDiagLib
   );

   if ( pSATunerDABServiceDiagLib )
   {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureDABTunerSysset);
   }
#endif

#ifdef __ENABLE_FEATURE_REMOTE_CONTROL_INCLUDE_TUNER_DAB__
   dia_SAFeatureRemoteControl* pSAFeatureRemoteCtrl = pFactory->createSystemAdapterRemoteControlFeature<dia_SAFeatureRemoteControl> (
         "SAFeatureTunerDABRemoteControl",
         DIA_EN_REMOTE_PLUGIN_TUNER_DAB,
         pSATunerDABServiceDiagLib
   );

   if ( pSAFeatureRemoteCtrl )
   {
      (void) dia_RemoteControl::getInstance()->addRemoteControlPlugin(pSAFeatureRemoteCtrl);
   }
#endif

#ifdef __ENABLE_FEATURE_CONFIG_NOTIFICATION_INCLUDE_TUNER_DAB__
   dia_SAFeatureCodingUpdate* pSAFeatureConfigUpdate = pFactory->createSystemAdapterConfigUpdateFeature<dia_SAFeatureCodingUpdate>(
         "SAFeatureTunerDABConfigUpdate",
         DIA_PROP_NISSAN_DAB_SET,
         SYSSETID_TUNE_DAB,
         pSATunerDABServiceDiagLib
   );

   if (pSATunerDABServiceDiagLib) {
      (void) getInstanceOfConfigManager()->addConfigNotifier(pSAFeatureConfigUpdate);
   }
#endif

   //--- feature: tuner for DAB Standard ---------------------------------------------
   dia_SAFeatureTunerDAB* pSAFeatureTunerDAB = pFactory->createSystemAdapterFeature<dia_SAFeatureTunerDAB> (
         "SAFeatureTunerDAB",
         pSADABTunerService
   );

   if ( pSAFeatureTunerDAB ) {
      (void) assignInterfaceAndNotifier<dia_ITunerDAB,dia_ITunerDABListener,dia_ITunerDABNotifier>(pSAFeatureTunerDAB);
   }

   // Diaglib Tuner DAB Features
   dia_SAFeatureTunerDABControl* pSATunerDABDiagLib = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureTunerDABControl>(
         "SATunerDABDiagLib",
         pSATunerDABServiceDiagLib
   );

   if ( pSATunerDABDiagLib ) {
      (void) assignInterfaceAndNotifier<dia_ITunerDABControl,dia_ITunerDABControlListener,dia_ITunerDABControlNotifier>(pSATunerDABDiagLib);
   }

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSATunerDAB::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSATunerDAB::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}
