/**
 * \file      dia_FactoryObjectSASwitchCtrl.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    stc2hi
 * \date      27.01.2016
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureSwitchCtrl.h"

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_SWITCHCTRL__
#include "dia_FactoryObjectSASwitchCtrl.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSASwitchCtrl)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSASwitchCtrl::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSASwitchCtrl::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_SWITCHCTRL_MINOR_VERSION = 0;
   static const tU16 CCA_C_U16_SRV_SWITCHCTRL_MAJOR_VERSION = 1;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SASwitchCtrl",
         CCA_C_U16_APP_SWITCH_GW
   );

   //
   // Service Plugins
   //

   // vehicle data standard service
   dia_SystemAdapterServicePlugin* pSASwitchCtrlService = pFactory->createSystemAdapterServicePluginNoMonitoring(
         "DIA_SASwitchCtrlSrv",
         CCA_C_U16_SRV_SWITCH_GW,
         CCA_C_U16_SRV_SWITCHCTRL_MAJOR_VERSION,
         CCA_C_U16_SRV_SWITCHCTRL_MINOR_VERSION,
         mpObj
   );

   //
   // Feature Plugins
   //

   // feature implementation for the SwitchCtrl base services

   dia_SAFeatureSwitchCtrl* pSAFeatureSwitchCtrl = pFactory->createSystemAdapterFeature<dia_SAFeatureSwitchCtrl> (
         "SAFeatureSwitchCtrl",
         pSASwitchCtrlService
         );

   if (pSAFeatureSwitchCtrl)
   {
      (void) assignInterfaceAndNotifier<dia_IITCommander,dia_IITCommanderListener,dia_ITCommanderNotifier>(pSAFeatureSwitchCtrl);
      (void) assignInterfaceAndNotifier<dia_IRearControlSwitch,dia_IRearControlSwitchListener,dia_RearControlSwitchNotifier>(pSAFeatureSwitchCtrl);
   }

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSASwitchCtrl::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSASwitchCtrl::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



