/**
 * \file      dia_FactoryObjectSASPM.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */
#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_SYSTEM_ADAPTERS__
#include "project/framework/factory/dia_FactoryPluginSystemAdapters.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureSpmBase.h"
#ifndef __DIA_UNIT_TESTING__
#include "project/framework/sysadapters/dia_SAFeatureSpmTimerIntervalls.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_SPM__
#include "dia_FactoryObjectSASPM.h"
#endif

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_DBGVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES

//lint -e1516
//lint -e1712
//lint -e1735
//lint -e1739
//lint +e1516
//lint +e1712
//lint +e1735
//lint +e1739

#if !defined(SPM_U8_DEFSET_GROUPSPM) && defined(__ENABLE_FEATURE_SYSSET_INCLUDE_SPM__)
#ifndef SPM_U8_DEFSET_GROUPSPM
#define SPM_U8_DEFSET_GROUPSPM  ((tU8) 0x15)
#endif
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSASPM)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSASPM::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSASPM::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_SPM_MAJOR_VERSION = 0;
   static const tU16 CCA_C_U16_SRV_SPM_MINOR_VERSION = 0;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
           "DIA_SASpm",
           CCA_C_U16_APP_SPM
           );

   //
   // Service Plugins
   //

   dia_SystemAdapterServicePlugin* pSASpmService = pFactory->createSystemAdapterServicePlugin (
           "DIA_SASpmSrv",
           CCA_C_U16_SRV_SPM,
           CCA_C_U16_SRV_SPM_MAJOR_VERSION,
           CCA_C_U16_SRV_SPM_MINOR_VERSION,
           mpObj
           );

   //
   // Feature Plugins
   //

   // add feature for basic SPM functionality
   dia_SAFeatureSpmBase* pSAFeatureSpmBase = pFactory->createSystemAdapterFeature<dia_SAFeatureSpmBase> (
           "SAFeatureSpmBase",
           pSASpmService
           );

   if ( pSAFeatureSpmBase ) {
	  (void) assignInterfaceAndNotifier<dia_ISpm,dia_ISpmListener,dia_ISpmNotifier>(pSAFeatureSpmBase);
      (void) assignInterfaceAndNotifier<dia_ISpmSVP,dia_ISpmSVPListener,dia_ISpmSVPNotifier>(pSAFeatureSpmBase);

   }

   // add feature for system timing values
   dia_SAFeatureSpmTimerIntervalls* pSAFeatureSpmTimerIntervalls = pFactory->createSystemAdapterFeature<dia_SAFeatureSpmTimerIntervalls> (
           "SAFeatureSpmTimerIntervalls",
           pSASpmService
           );

   if ( pSAFeatureSpmTimerIntervalls ) {
      (void) assignInterfaceAndNotifier<dia_ISpmTimerIntervall,dia_ISpmTimerIntervallListener,dia_ISpmTimerIntervallNotifier>(pSAFeatureSpmTimerIntervalls);
   }

#if 0 //STC2HI: TODO
#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_SPM__
      // add feature for system settings (method based without using the diaglib --> compatibility mode)
   dia_SAFeatureDefaultSettingsCompatible* pSAFeatureSpmSysSet = pFactory->createSystemAdapterDefSetFeature<dia_SAFeatureDefaultSettingsCompatible> (
           "SAFeatureSpmSysset",
           SYSSETID_SYST_POWE_MANA,
           DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION,
           pSASpmService,
           SPM_U8_DEFSET_GROUPSPM,
           CFC_SPMFI_C_U16_DIAGCONFIGURATION
//           CFC_SPMFI_C_U16_FACTORYSETTING,
//           CFC_SPMFI_C_U16_FACTORYSETTINGSTATUS
           );

   if ( pSAFeatureSpmSysSet ) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureSpmSysSet);
   }
#endif
#endif //STC2HI: TODO

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSASPM::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSASPM::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



