/*
 * dia_FactoryObjectSASPI.cpp
 *
 *  Created on: Apr 13, 2016
 *      Author: bsu9kor
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif
#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif
#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif
#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif
#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif
#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h"
#endif
#ifndef DIA_FACTORYOBJECTSASPI_H_
#include "dia_FactoryObjectSASPI.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSASPI)
//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSASPI::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSASPI::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SASPI",
         CCA_C_U16_APP_SMARTPHONEINTEGRATION
   );

   //
   // Service Plugins
   //

   // SPI diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSASPIServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SASPISrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
    );

   //
   // Feature Plugins
   //

   //--- system settings feature via the diaglib service ----------------------
   dia_SAFeatureSystemSettings* pSAFeatureSPISystemSettings = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings> (
         "SAFeatureSPISysset",
         SYSSETID_SMARTPHONE_INTEGRATION,
         DIAGLIB_SYSTEM_SET_TYPE_MASK_HMI,
         pSASPIServiceDiagLib
   );

   // if ( pSAFeatureSPISystemSettings ) {
      // dia_SystemSetManager::getInstance()->addSystemSetModule(*pSAFeatureSPISystemSettings);
   // }
   if ( pSASPIServiceDiagLib )
   {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureSPISystemSettings);
   }
   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSASPI::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSASPI::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}
