/**
 * \file      dia_FactoryObjectSAMessaging.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    wgl2hi
 * \date      29.07.2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_MESSAGING__
#include "dia_FactoryObjectSAMessaging.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER__
#include <common/framework/sysadapters/dia_SystemAdapter.h>
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAMessaging)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAMessaging::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAMessaging::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SAMessaging",
         CCA_C_U16_APP_MESSAGING
   );

   // Messaging diaglib service
#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_MESSAGING__
   dia_SystemAdapterServicePluginDiaglib* pSAMessagingServiceDiagLib =
#else
    (void)
#endif
    pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SAMessagingSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
    );

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_MESSAGING__
   // system settings feature via the diaglib service
   dia_SAFeatureSystemSettings* pSAFeatureMessagingSysSet = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings> (
         "SAFeatureMessagingSysSet",
         SYSSETID_MESSAGING,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSAMessagingServiceDiagLib
   );

   if ( pSAFeatureMessagingSysSet ) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureMessagingSysSet);
   }

#endif

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAMessaging::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAMessaging::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}
