/**
 * \file      dia_FactoryObjectSAIPOD.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_PROJECT_FACTORY__
#include <project/framework/factory/dia_project_factory.h>
#endif

#include <common/framework/sysadapters/dia_SAFeatureIPOD.h>

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_IPOD__
#include "dia_FactoryObjectSAIPOD.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAIPOD)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAIPOD::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAIPOD::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SA_IPOD",
         CCA_C_U16_APP_IPODAUTH
         );

   //
   // Service Plugins
   //

   // IPOD diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSAIPODServiceDiaglib = pFactory->createSystemAdapterServicePluginDiaglib(
         "DIA_SAIPODSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
         );

   //
   // Feature Plugins
   //

   dia_SAFeatureIPOD* pSAFeatureIPOD = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureIPOD> (
         "SAFeatureIPOD",
         pSAIPODServiceDiaglib
         );

   if (pSAFeatureIPOD) {
      (tVoid) assignInterfaceAndNotifier <dia_IMediaIPOD,dia_IMediaIPODListener,dia_IMediaIPODNotifier> (pSAFeatureIPOD);
   }

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAIPOD::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAIPOD::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



