/**
 * \file      dia_FactoryObjectSAHeatControl.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef HEATCTRL_FI_S_ALREADY_INCLUDE_HEATCTRL_MAINFI_FUNCTIONIDS
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_FUNCTIONIDS
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_TYPES
#include "heatctrl_fi_if.h"
#endif

#include "project/framework/sysadapters/dia_SAFeatureHeatControl.h"

#ifndef __INCLUDED_DIA_SAFEATURE_FAN_STATISTICS__
#include "project/framework/sysadapters/dia_SAFeatureFanStatistics.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_HEATCONTROL__
#include "dia_FactoryObjectSAHeatControl.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAHeatControl)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAHeatControl::setup ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAHeatControl::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_HEATCTRL_MAJOR_VERSION = 1;
   static const tU16 CCA_C_U16_SRV_HEATCTRL_MINOR_VERSION = 3;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SAHeatCtrl",
         CCA_C_U16_APP_FC_HEATCTRL
   );

   //
   // Service Plugins
   //

   // HeatControl standard service
   dia_SystemAdapterServicePlugin* pSAHeatCtrlService = pFactory->createSystemAdapterServicePluginNoMonitoring (
         "DIA_SAHeatCtrlSrv",
         CCA_C_U16_SRV_HEATCTRL,
         CCA_C_U16_SRV_HEATCTRL_MAJOR_VERSION,
         CCA_C_U16_SRV_HEATCTRL_MINOR_VERSION,
         mpObj
   );

   // HeatControl Diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSAHeatCtrlServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SAHeatCtrlSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
    );

   //
   // Feature Plugins
   //

   // feature implementation for the HeatControl base services
   dia_SAFeatureHeatControl* pSAFeatureHeatCtrl = pFactory->createSystemAdapterFeature<dia_SAFeatureHeatControl> (
         "dia_SAFeatureHeatControl",
         pSAHeatCtrlService
   );

   if ( pSAFeatureHeatCtrl ) {
      (tVoid) assignInterfaceAndNotifier<dia_IHeatControl,dia_IHeatControlListener,dia_IHeatControlNotifier>(pSAFeatureHeatCtrl);
   }

   // feature implementation for the HeatControl Diaglib services
   dia_SAFeatureFanStatistics* pSAFeatureFanStatistics = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureFanStatistics> (
         "dia_SAFeatureFanStatistics",
         pSAHeatCtrlServiceDiagLib
   );

   if ( pSAFeatureFanStatistics )
   {
      (tVoid) assignInterfaceAndNotifier<dia_IFanStatistics,dia_IFanStatisticsListener,dia_IFanStatisticsNotifier>(pSAFeatureFanStatistics);
   }

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_HEATCONTROL__
    // add feature for system settings (method based without using the diaglib --> compatibility mode)
    dia_SAFeatureDefaultSettingsCompatible* pSAFeatureHeatControlSysSet = pFactory->createSystemAdapterDefSetFeature<dia_SAFeatureDefaultSettingsCompatible> (
          "SAFeatureHeatControlSysset",
          SYSSETID_HEAT_CONT,
          DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CALIBRATION, //DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION,
          pSAHeatCtrlService,
          midw_fi_tcl_e8_DefSetGroups::FI_EN_DEFSET_GROUP__MAINTENANCE,
          HEATCTRL_MAINFI_C_U16_FI_FC_HEATCTRL_DEFAULT
    );

    if ( pSAFeatureHeatControlSysSet ) {
       getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureHeatControlSysSet);
    }
#endif

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAHeatControl::tearDown ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAHeatControl::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



