#ifndef __INCLUDED_PROJECT_FACTORY__
#include "dia_project_factory.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#include <midw_fi_if.h> //lint !e537 !e451 Do not protect this file against double include, because it contains other macros include with correct protection

//#ifndef __INCLUDED_DIA_COMMON_SYSSET__
//#include <common/framework/sysset/dia_common_sysset.h>
//#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include <common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h>
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER__
#include <common/framework/sysadapters/dia_SystemAdapter.h>
#endif

#ifndef DIA_SAFEATUREERRORLOG_H_
#include <common/framework/sysadapters/dia_SAFeatureErrorLog.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_ERRORLOG_NOTIFICATION__
#include "project/framework/sysadapters/dia_SAFeatureErrorLogNotification.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_ERROR_LOG__
#include "dia_FactoryObjectSAErrorLog.h"
#endif

#ifndef __INCLUDED_DIA_SIGMA__
#include "project/framework/sigma/dia_Sigma.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAErrorLog)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAErrorLog::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAErrorLog::setup");

   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
         "DIA_SAErrLog",
         CCA_C_U16_APP_DIAGLOG
   );

   //
   // Service Plugins
   //

   dia_SystemAdapterServicePlugin* pSAErrLogService = pFactory->createSystemAdapterServicePlugin (
         "DIA_SAErrLogSrv",
         CCA_C_U16_SRV_DIAGLOG,
         MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION,
         MIDW_DIAGLOGFI_C_U16_SERVICE_MINORVERSION,
         mpObj
   );

   //
   // Feature Plugins
   //

   // add feature for base error log interface methods
   dia_SAFeatureErrorLog* pSAFeatureErrLog = pFactory->createSystemAdapterFeature<dia_SAFeatureErrorLog> (
           "SAFeatureErrLog",
           pSAErrLogService
           );

   if ( pSAFeatureErrLog )
   {
      // Change for new  dia_IErrorLog - (void) assignInterfaceAndNotifier<dia_IErrorLog,dia_IErrorLogListener,dia_ErrorLogNotifier>(pSAFeatureErrLog);
      (void) assignInterfaceAndNotifier<dia_IErrorLog,            dia_IErrorLogListener,            dia_IErrorLogNotifier>            (pSAFeatureErrLog);
      // set configuration;
      if(dia_Sigma::isConfigured())
      {
         dia_ErrorLogConfiguration cfg;
         cfg.setActiveDTCListSupported(true);
         pSAFeatureErrLog->setConfiguration(cfg);
      }
   }

   // add feature for system settings (method based without using the diaglib --> compatibility mode)
   dia_SAFeatureDefaultSettingsCompatible* pSAFeatureErrLogSysSet = pFactory->createSystemAdapterDefSetFeature<dia_SAFeatureDefaultSettingsCompatible> (
         "SAFeatureErrLogSysSet",
         SYSSETID_ERRO_LOG,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION,
         pSAErrLogService,
         midw_fi_tcl_e8_DiaglogDefsetType::FI_EN_ACTIVATE_DEACTIVATE_DTC,
         MIDW_DIAGLOGFI_C_U16_SETFACTORYSETTINGSNEW
   );

   if ( pSAFeatureErrLogSysSet ) {
	   getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureErrLogSysSet);
   }

#ifdef VARIANT_S_FTR_ENABLE_ERRORLOG_NOTIFICATION
   // add feature for notifications from VD_Diaglog
   dia_SAFeatureErrorLogNotification* pSAFeatureErrLogNotification = pFactory->createSystemAdapterFeature<dia_SAFeatureErrorLogNotification> (
         "SAFeatureErrLogNotify",
         pSAErrLogService
         );

   if (pSAFeatureErrLogNotification)
   {
      (void) assignInterfaceAndNotifier<dia_IErrorLogNotification, dia_IErrorLogNotificationListener, dia_IErrorLogNotificationNotifier>(pSAFeatureErrLogNotification);
   }
#endif //VARIANT_S_FTR_ENABLE_ERRORLOG_NOTIFICATION

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAErrorLog::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAErrorLog::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}
