/**
 * \file      dia_FactoryObjectSAAudioCompressed.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      25.03.2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

//#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE_CPRA__
//#include "project/framework/sysadapters/dia_SAFeatureCompressedAudioDefset.h"
//#endif

#ifndef DIA_SAFEATUREPRODUCTIONCOMPRESSEDAUDIO_H_
#include "project/framework/sysadapters/dia_SAFeatureProductionCompressedAudio.h"
#endif

#ifndef DIA_SAFEATUREMEDIAFILECOUNTER_H_
#include "project/framework/sysadapters/dia_SAFeatureMediaFileCounter.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_AUDIOCOMPRESSED__
#include "dia_FactoryObjectSAAudioCompressed.h"
#endif

//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CPRAFI_FUNCTIONIDS
//#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//Include public FI interface of this service.
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_ERRORCODES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO
#include "mplay_fi_if.h"


DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAAudioCompressed)

//-----------------------------------------------------------------------------

static const dia_SAFeatureMediaFileCounter::DeviceMapping aDeviceMapping[] =
{
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_BLUETOOTH, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_BLUETOOTH},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_CDDA, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_CDDA},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_CDROM, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_CDROM},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_DVD_DRIVE, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_DVD_DRIVE},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_FLASH, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_FLASH},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_IPHONE, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_IPHONE},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_IPOD, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_IPOD},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_MTP, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_MTP},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_MUSICBOX, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_MUSICBOX},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_SD, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_SD},
   {mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_USB, DIA_EN_MEDIAPLAYER_DEVICE_TYPE_USB}
};

static const dia_SAFeatureMediaFileCounter::IndexStateMapping aIndexStateMapping[] =
{
   {mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_COMPLETE, DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_COMPLETE},
   {mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_NOT_STARTED, DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_NOTSTARTED},
   {mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_NOT_SUPPORTED, DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_NOTSUPPORTED},
   {mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_PARTIAL, DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_PARTIAL}
};

static const dia_SAFeatureMediaFileCounter::ConnectionStateMapping aConnectionStateMapping[] =
{
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_CONNECTED, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_CONNECTED},
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_ATTACHED, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_ATTACHED},
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_DISCONNECTED, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_DISCONNECTED},
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_HW_MALFUNCTION, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_HW_MALFUNCTION},
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_UNSUPPORTED, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_UNSUPPORTED},
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_OVERTEMP, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_OVERTEMP},
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_ON_HOLD, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_ON_HOLD},
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_UNDEFINED, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_ON_UNDEFINED},
   {mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_UNDERVOLTAGE, DIA_EN_MEDIAPLAYER_CONNECTION_STATE_UNDERVOLTAGE} 
};

tDiaResult
dia_FactoryObjectSAAudioCompressed::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAAudioCompressed::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_COMPRESSEDAUDIO_MINOR_VERSION = MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_MINORVERSION;
   static const tU16 CCA_C_U16_SRV_COMPRESSEDAUDIO_MAJOR_VERSION = MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_MAJORVERSION;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
          "DIA_SACompressedAudio",
          CCA_C_U16_APP_MEDIAPLAYER
          );

   //
   // Service Plugins
   //

   dia_SystemAdapterServicePlugin* pSACompressedAudioService = pFactory->createSystemAdapterServicePluginNoMonitoring (
          "DIA_SACompressedAudioSrv",
          CCA_C_U16_SRV_FB_MEDIAPLAYER,
          CCA_C_U16_SRV_COMPRESSEDAUDIO_MAJOR_VERSION,
          CCA_C_U16_SRV_COMPRESSEDAUDIO_MINOR_VERSION,
          mpObj
          );

   //
   // Feature Plugins
   //

   // add feature for production test
   dia_SAFeatureProductionCompressedAudio* pSAFeatureProdCompressedAudio = pFactory->createSystemAdapterFeature<dia_SAFeatureProductionCompressedAudio> (
          "SAFeatureProductionCompressedAudio",
          pSACompressedAudioService
          );

   if (pSAFeatureProdCompressedAudio) {
      (void) assignInterfaceAndNotifier<dia_ICompressedAudio, dia_ICompressedAudioListener, dia_ICompressedAudioNotifier>(pSAFeatureProdCompressedAudio);
   }

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_AUDIO_COMPRESSED__
   // add feature for system settings (method based without using the diaglib --> compatibility mode)
   dia_SAFeatureCompressedAudioDefset* pSAFeatureCompressedAudioSysset = pFactory->createSystemAdapterDefSetFeature<dia_SAFeatureCompressedAudioDefset> (
          "SAFeatureCompressedAudioSysset",
          SYSSETID_AUDI_COMPR,
          DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
          pSACompressedAudioService,
          midw_fi_tcl_e8_DiagDefSetGroups::FI_EN_DEFSET_GROUP__INFOTAINMENT__MP3,
          MIDW_CPRAFI_C_U16_DEFAULTSMETH
          );

//   // add feature for system settings (method based without using the diaglib --> compatibility mode)
//   dia_SAFeatureDefaultSettingsCompatible* pSAFeatureCompressedAudioSysset = pFactory->createSystemAdapterDefSetFeature<dia_SAFeatureDefaultSettingsCompatible> (
//         "SAFeatureCompressedAudioSysset",
//         SYSSETID_AUDI_COMPR,
//         DIAGLIB_SYSTEM_SET_TYPE_MASK_TEF | DIAGLIB_SYSTEM_SET_TYPE_MASK_HMI,
//         pSACompressedAudioService,
//         midw_fi_tcl_e8_DiagDefSetGroups::FI_EN_DEFSET_GROUP__INFOTAINMENT__MP3,
//         MIDW_CPRAFI_C_U16_DEFAULTSMETH
//         );

   if ( pSAFeatureCompressedAudioSysset ) {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureCompressedAudioSysset);
   }

#endif

   //add feature for customer testing
     dia_SAFeatureMediaFileCounter* pSAFeatureMediaFileCounter = pFactory->createSystemAdapterFeature<dia_SAFeatureMediaFileCounter> (
            "pSAFeatureMediaFileCounter",
            pSACompressedAudioService
            );

   if ( pSAFeatureMediaFileCounter ) {
      (void) pSAFeatureMediaFileCounter->loadDeviceMappings(aDeviceMapping, sizeof(aDeviceMapping)/sizeof(dia_SAFeatureMediaFileCounter::DeviceMapping));
      (void) pSAFeatureMediaFileCounter->loadIndexStateMappings(aIndexStateMapping, sizeof(aIndexStateMapping)/sizeof(dia_SAFeatureMediaFileCounter::IndexStateMapping));
      (void) pSAFeatureMediaFileCounter->loadConnectionStateMappings(aConnectionStateMapping, sizeof(aConnectionStateMapping)/sizeof(dia_SAFeatureMediaFileCounter::ConnectionStateMapping));
      (void) assignInterfaceAndNotifier<dia_IMediaFileCounter,dia_IMediaFileCounterListener,dia_IMediaFileCounterNotifier>(pSAFeatureMediaFileCounter);
   }

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAAudioCompressed::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAAudioCompressed::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



