/**
 * \file      dia_FactoryObjectSAAudio.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    shw2abt
 * \date      07.02.2013
 *--------------------------------------------------------------------------------
 * Date				|	User ID		|	Modification
 * 27/5/2016		|	bma9kor		|	Audio balance and fader functions added for facilitating Diaglib communication  (CMG3G-10183)
 *--------------------------------------------------------------------------------
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include "common/framework/sysset/dia_SystemSettingsManager.h"
#endif

#ifndef __INCLUDED_PROJECT_FACTORY__
#include "project/framework/factory/dia_project_factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#ifndef __DIA_SAFEATUREAUDIOCONTROL_H___
#include "project/framework/sysadapters/dia_SAFeatureAudioControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_AUDIO_SINK_CONTROL_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureAudioSinkControlDiaglib.h"
#endif

#ifndef DIA_SAFEATUREAUDIO_H_
#include "project/framework/sysadapters/dia_SAFeatureAudio.h"
#endif

#ifndef DIA_SAFEATURE_AUDIO_TEST_H_
#include "project/framework/sysadapters/dia_SAFeatureAudioTest.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_EXTERNAL_AMPLIFIER__
#include "project/framework/sysadapters/dia_SAFeatureSelfDiagnosisExtAmplifier.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_OBJECT_SYSTEM_ADAPTER_AUDIO__
#include "dia_FactoryObjectSAAudio.h"
#endif

DIA_IMPL_FACTORY_OBJECT(dia_FactoryObjectSAAudio)

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAAudio::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAAudio::setup");
   dia_FactoryPluginSystemAdapters* pFactory = dia_FactoryPluginSystemAdapters::getInstance();

   static const tU16 CCA_C_U16_SRV_AUDIO_MAJOR_VERSION = 1;
   static const tU16 CCA_C_U16_SRV_AUDIO_MINOR_VERSION = 0;

   //
   // System Adapter object
   //

   mpObj = pFactory->createSystemAdapter (
           "DIA_SAAudio",
           CCA_C_U16_APP_AUDIO
           );

   //
   // Service Plugins
   //

   dia_SystemAdapterServicePlugin* pSAAudioService = pFactory->createSystemAdapterServicePluginNoMonitoring (
           "DIA_SAAudioSrv",
           CCA_C_U16_SRV_AUDIOFUNC,
           CCA_C_U16_SRV_AUDIO_MAJOR_VERSION,
           CCA_C_U16_SRV_AUDIO_MINOR_VERSION,
           mpObj
           );

   // audio diaglib service
   dia_SystemAdapterServicePluginDiaglib* pSAAudioServiceDiagLib = pFactory->createSystemAdapterServicePluginDiaglib (
         "DIA_SAAudioSrvDiagLib",
         CCA_C_U16_SRV_DIAGLIB_MAJOR_VERSION,
         CCA_C_U16_SRV_DIAGLIB_MINOR_VERSION,
         mpObj
      );

   //
   // Feature Plugins
   //

   // add feature for basic Audio functionality
   dia_SAFeatureAudio* pSAFeatureAudio = pFactory->createSystemAdapterFeature<dia_SAFeatureAudio> (
         "SAFeatureAudio",
         pSAAudioService
   );

   if ( pSAFeatureAudio ) {
 		#ifndef __ENABLE_FEATURE_DIAGLIB_INCLUDE_AUDIO__
 	   (void) assignInterfaceAndNotifier<dia_IAudioBalFader,dia_IAudioBalFaderListener,dia_IAudioBalFaderNotifier>(pSAFeatureAudio); //call CCA implementation
		#endif
       (void) assignInterfaceAndNotifier<dia_IAudio,dia_IAudioListener,dia_IAudioNotifier>(pSAFeatureAudio);
   }

   // add feature for basic Audio functionality
   dia_SAFeatureAudioTest* pSAFeatureAudioTest = pFactory->createSystemAdapterFeature<dia_SAFeatureAudioTest> (
         "SAFeatureAudioTest",
         pSAAudioService
   );

   if ( pSAFeatureAudioTest ) {
       (void) assignInterfaceAndNotifier<dia_IAudioTest,dia_IAudioTestListener,dia_IAudioTestNotifier>(pSAFeatureAudioTest);
   }

   // add audio control feature implementation for the diaglib services
   dia_SAFeatureAudioControl* pSAFeatureAudioControl = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureAudioControl>(
         "pSAFeatureAudioControl",
         pSAAudioServiceDiagLib
   );

   if (pSAFeatureAudioControl) {
   	  #ifdef __ENABLE_FEATURE_DIAGLIB_INCLUDE_AUDIO__
	  (void) assignInterfaceAndNotifier<dia_IAudioBalFader,dia_IAudioBalFaderListener,dia_IAudioBalFaderNotifier>(pSAFeatureAudioControl); //call DIAGLIB implementation
      #endif
      (void) assignInterfaceAndNotifier<dia_IAudioControl,dia_IAudioControlListener,dia_IAudioControlNotifier>(pSAFeatureAudioControl);
   }

   // add audio sink set feature implementation for the diaglib services
   dia::SAFeatureAudioSinkControlDiaglib* pSAFeatureAudioSinkControl = pFactory->createSystemAdapterFeatureDiaglib<dia::SAFeatureAudioSinkControlDiaglib>(
         "pSAFeatureAudioSinkControl",
         pSAAudioServiceDiagLib
   );

   if ( pSAFeatureAudioSinkControl )
   {
      (void) assignInterfaceAndNotifier<dia_IAudioSink,dia_IAudioSinkListener,dia_IAudioSinkNotifier>(pSAFeatureAudioSinkControl);
   }

#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_AUDIO__
   // system settings feature via the diaglib service
   dia_SAFeatureSystemSettings* pSAFeatureAudioSysSet = pFactory->createSystemAdapterSysSetFeature<dia_SAFeatureSystemSettings> (
         "SAFeatureAudioSysSet",
         SYSSETID_AUDIO_MANAGER,
         DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION | DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI,
         pSAAudioServiceDiagLib
   );

   if ( pSAFeatureAudioSysSet ) {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureAudioSysSet);
   }
#endif

#ifdef __ENABLE_FEATURE_REMOTE_CONTROL_INCLUDE_AUDIO_MANAGER__
   dia_SAFeatureRemoteControl* pSAFeatureRemoteCtrl = pFactory->createSystemAdapterRemoteControlFeature<dia_SAFeatureRemoteControl> (
         "SAFeatureAudioRemoteControl",
         DIA_EN_REMOTE_PLUGIN_AUDIO,
         pSAAudioServiceDiagLib
         );

   if ( pSAFeatureRemoteCtrl )
   {
      (void) dia_RemoteControl::getInstance()->addRemoteControlPlugin(pSAFeatureRemoteCtrl);
   }
#endif

#ifdef __ENABLE_FEATURE_CONFIG_NOTIFICATION_INCLUDE_AUDIO_MANAGER__
   dia_SAFeatureCodingUpdate* pSAFeatureAudioManagerConfigUpdate = pFactory->createSystemAdapterConfigUpdateFeature<dia_SAFeatureCodingUpdate>(
         "SAFeatureAudioManagerConfigUpdate",
         DIA_PROP_NISSAN_AUDIO_PARAM_SET,
         SYSSETID_AUDIO_MANAGER,
         pSAAudioServiceDiagLib
   );

   if (pSAAudioServiceDiagLib) {
      (void) getInstanceOfConfigManager()->addConfigNotifier(pSAFeatureAudioManagerConfigUpdate);
   }
#endif

   // Bose Amplifier Self Diagnosis with special system settings type and via the diaglib service
   dia_SAFeatureSelfDiagnosisExtAmplifier* pSAFeatureSelfDiagnosisExtAmplifier = pFactory->createSystemAdapterFeatureDiaglib<dia_SAFeatureSelfDiagnosisExtAmplifier> (
         "SAFeatureSelfDiagnosisExtAmplifier",
         pSAAudioServiceDiagLib
   );

   if ( pSAFeatureSelfDiagnosisExtAmplifier ) {
      getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureSelfDiagnosisExtAmplifier);
   }

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryObjectSAAudio::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryObjectSAAudio::tearDown");
   OSAL_DELETE mpObj;
   mpObj = 0;

   return DIA_SUCCESS;
}



