/*!
 * \file       dia_DataDownloadStrategyDefault_CMC.h
 *
 * \brief      Data Download Strategy in A-IVI project
 *
 * \details    1/ The Reprogramming DTC $FD00..$FD08 FaultTypeByte $42 shall be updated after a TransferExit of only that Logical Block (See AIVI-42451).
 *             2/ Set last result of CheckProgrammingDependency to COMPLETED_NOK (see DIA_PROP_AIVI_RESULT_CHECK_PROG_DEP) after download request for logical block -- AIVI-57691
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PRJ_SPECIFIC_DATA_DOWNLOAD_STRATEGY_DEFAULT_CMC__
#define __INCLUDED_DIA_PRJ_SPECIFIC_DATA_DOWNLOAD_STRATEGY_DEFAULT_CMC__

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_DEFAULT__
#include "common/framework/datadownload/dia_DataDownloadStrategyDefault.h"
#endif


class dia_DataDownloadStrategyDefault_CMC
   : public dia_DataDownloadStrategyDefault
{
public:
   //! class constructor
   dia_DataDownloadStrategyDefault_CMC ( void );
   //! class destructor
   virtual ~dia_DataDownloadStrategyDefault_CMC ( void );

protected:

   virtual tDiaResult requestDownload ( std::vector<tU8>& requestData ) override;

   virtual tDiaResult requestUpload (std::vector<tU8>& requestData ) override;

   virtual tDiaResult transferExit ( std::vector<tU8>& requestData ) override;

   //! called by the session control object to notify about a session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession ) override;
};

#endif /* __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_DEFAULT_AIVI__ */
