/*!
 * \file       dia_DataDownloadStrategyDefault_CMC.cpp
 *
 * \brief      Data Download Strategy in A-IVI project
 *
 * \details    1/ The Reprogramming DTC $FD00..$FD08 FaultTypeByte $42 shall be updated after a TransferExit of only that Logical Block (See AIVI-42451).
 *             2/ Set last result of CheckProgrammingDependency to COMPLETED_NOK (see DIA_PROP_AIVI_RESULT_CHECK_PROG_DEP) after download request for logical block -- AIVI-57691
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PRJ_SPECIFIC_DATA_DOWNLOAD_STRATEGY_DEFAULT_CMC__
#include "dia_PrjSpecific_DataDownloadStrategyDefault_CMC.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CHECK_PROGRAMMING_DEPENDENCIES__
#include "project/services/customer/dia_RoutineCtrlCheckProgrammingDependencies.h"
#endif

enum dia_ITC_value
{
   DIA_ITC_PASSED = 0,     /* =0 */
   DIA_ITC_FAILED          /* =1 */
};

static tCString DIR_NAME1 = "/tmp/partAuth" ;
static tCString DIR_NAME2 = "/tmp/partAuth/crt" ;
static std::string downloadStrtgName("dia_DataDownloadStrategyDefault_CMC");
//-----------------------------------------------------------------------------

dia_DataDownloadStrategyDefault_CMC::dia_DataDownloadStrategyDefault_CMC ( void )
   : dia_DataDownloadStrategyDefault(downloadStrtgName)
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyDefault_CMC::dia_DataDownloadStrategyDefault_CMC");
}

//-----------------------------------------------------------------------------

dia_DataDownloadStrategyDefault_CMC::~dia_DataDownloadStrategyDefault_CMC ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadStrategyDefault_CMC::transferExit ( std::vector<tU8>& requestData )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyDefault_CMC::transferExit");
   tDiaResult retVal=DIA_FAILED;

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      pEngine->getSessionController()->removeListener(this);
   }
   else
   {
      DIA_TR_ERR("!!! dia_DataDownloadStrategyDefault_CMC::transferExit => ERROR: Unable to deregister for Session changes");
   }

   dia_FileDir diagDir1(DIR_NAME1);
   dia_FileDir diagDir2(DIR_NAME2);

   // create directories in temporary folder for Certificate
   if ( diagDir1.doesExist() )
   {
      if(diagDir2.doesExist())
      {
         retVal = dia_DataDownloadStrategyDefault::transferExit( requestData );
      }
      else
      {
         if ( diagDir2.create() != DIA_SUCCESS )
         {
            DIA_TR_ERR("##### CREATION OF DIRECTORY \"%s\" FAILED !! #####",DIR_NAME2);
            retVal = DIA_FAILED;
         }
         else
         {
            DIA_TR_INF("Creation of Directory \"%s\" Successful",DIR_NAME2);
            retVal = dia_DataDownloadStrategyDefault::transferExit( requestData );
         }
      }
   }
   else
   {
      DIA_TR_INF("Creating Directory \"%s\"",DIR_NAME1);
      if ( diagDir1.create() != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### CREATION OF DIRECTORY \"%s\" FAILED !! #####",DIR_NAME1);
         retVal = DIA_FAILED;
      }
      else
      {
         if(!diagDir2.doesExist())
         {
            DIA_TR_INF("Creating Directory \"%s\"",DIR_NAME2);
            if ( diagDir2.create() != DIA_SUCCESS )
            {
               DIA_TR_ERR("##### CREATION OF DIRECTORY \"%s\" FAILED !! #####",DIR_NAME2);
               retVal = DIA_FAILED;
            }
            else
            {
               DIA_TR_INF("Creation of Directory \"%s\" Successful",DIR_NAME2);
               retVal = dia_DataDownloadStrategyDefault::transferExit( requestData );
            }
         }
      }
   }

   //tDiaResult retVal = dia_DataDownloadStrategyDefault::transferExit( requestData );

   DIA_TR_INF("dia_DataDownloadStrategyDefault_CMC::transferExit returned 0x%08X.", retVal);

   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadStrategyDefault_CMC::requestDownload ( std::vector<tU8>& requestData )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyDefault_CMC::requestDownload()");

   //call base method
   tDiaResult retVal = dia_DataDownloadStrategyDefault::requestDownload( requestData );

   if (retVal == DIA_SUCCESS)
   {
      dia_EngineServer* pEngine = 0;
      if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
      {
         pEngine->getSessionController()->addListener(this);
      }
      else
      {
         DIA_TR_ERR("!!! dia_DataDownloadStrategyDefault_CMC::requestDownload => ERROR: Unable to register for Session changes");
      }
   }
   else
   {
      DIA_TR_ERR("dia_DataDownloadStrategyDefault_CMC::requestDownload => ERROR from base class: 0x%x", retVal);

      if (mpFSM)
      {
         mpFSM->acceptEvent(dia_DataDownloadFSM::evIdle,0);
      }
      else
      {
         DIA_TR_ERR("dia_DataDownloadStrategyDefault_CMC::requestDownload => ERROR: FSM IS NULL!!!");
      }
   }

   return retVal;
}

tDiaResult
dia_DataDownloadStrategyDefault_CMC::requestUpload ( std::vector<tU8>& requestData )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyDefault_CMC::requestUpload()");

   //call base method
   tDiaResult retVal = dia_DataDownloadStrategyDefault::requestUpload( requestData );

   if (retVal == DIA_SUCCESS)
   {
      dia_EngineServer* pEngine = 0;
      if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
      {
         pEngine->getSessionController()->addListener(this);
      }
      else
      {
         DIA_TR_ERR("!!! dia_DataDownloadStrategyDefault_CMC::requestUpload => ERROR: Unable to register for Session changes");
      }
   }
   else
   {
      DIA_TR_ERR("dia_DataDownloadStrategyDefault_CMC::requestUpload => ERROR from base class: 0x%x", retVal);

      if (mpFSM)
      {
         mpFSM->acceptEvent(dia_DataDownloadFSM::evIdle,0);
      }
      else
      {
         DIA_TR_ERR("dia_DataDownloadStrategyDefault_CMC::requestUpload => ERROR: FSM IS NULL!!!");
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_DataDownloadStrategyDefault_CMC::vOnSessionChanged ( tU8 newSession, tU8 oldSession )
{
   dia_tclFnctTrace oTrace("dia_DataDownloadStrategyDefault_CMC::vOnSessionChanged()");

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      pEngine->getSessionController()->removeListener(this);
   }
   else
   {
      DIA_TR_ERR("!!! dia_DataDownloadStrategyDefault_CMC::vOnSessionChanged => ERROR: Unable to deregister for Session changes");
   }

   postprocessDownload(0);

   if (mpFSM)
   {
      DIA_TR_INF("dia_DataDownloadStrategyDefault_CMC session change from %d to %d in state '%s'", oldSession, newSession, mpFSM->getStateName());

      mpFSM->acceptEvent(dia_DataDownloadFSM::evIdle,0);
   }
   else
   {
      DIA_TR_ERR("dia_DataDownloadStrategyDefault_CMC::vOnSessionChanged => ERROR: FSM IS NULL!!!");
   }
}

