/*!
 * \file       dia_DataDownloadManagerPlugin_CMC.h
 *
 * \brief      Plugin for Data Download in A-IVI project
 *
 * \details    1/ If Xtra Data update (Activation Phase) is started, do nothing project specific.
 *             2/ If Xtra Data update (Activation Phase) is not started, check if address could be matched to one logical block.
 *             3/ If given address belongs one of logical blocks (LB00 to LB0E), check status of DTC concerning Programming Failure for given logical Block.
 *                If status of this DTC is not equal to 0x00, send NRC 0x33 back if the device is locked for Customer Security Access.
 *             4/ If given address belongs one of logical blocks (LB00 to LB0E), clear three DTCs for given logical block
 *                (fault type 0x06 (algorithm based failure), 0x51 (programming failure), 0x42 (internal failure)).

 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_PRJ_SPECIFIC_DATA_DOWNLOAD_MANAGER_PLUGIN_CMC__
#define __INCLUDED_PRJ_SPECIFIC_DATA_DOWNLOAD_MANAGER_PLUGIN_CMC__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DATA_DOWNLOAD_MANAGER_PLUGIN__
#include "common/framework/datadownload/dia_DataDownloadManagerPlugin.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif


class dia_DataDownloadManagerPlugin_CMC
   : public dia_DataDownloadManagerPlugin
{

   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_DataDownloadManagerPlugin_CMC);

private:
   // return true if Customer Security Access has been deactivated.
   tBool IsDeviceUnlocked () const;

public:
   //! class constructor
   dia_DataDownloadManagerPlugin_CMC(std::map<tU32, tU16>& logicAddrToDtcGroupRepo, 
         std::map<tU32,tU32>& dtcProgrammingToPropertyIDRepo,
         const std::map<tU32, std::pair <tU32,tU32> >& startAddrToItcAndPropIDRepo);

   //! class destructor
   virtual ~dia_DataDownloadManagerPlugin_CMC ( void ) {}

   virtual tDiaResult prepareDownload ( dia_Dataset& ) const override;
   virtual tDiaResult postprocessDownload ( dia_Dataset& ) const override;

   class DiaglogAgent : public dia_IErrorLogListenerImpl
   {
   public:
      using DtcClearList = std::list<tU32>;
      using ItcReportList = std::list< std::pair<tU16, dia_enTestResult> >;

      DiaglogAgent(const dia_DataDownloadManagerPlugin_CMC* pPlugin, tU32 address);
      virtual ~DiaglogAgent ( void ) {}

      tDiaResult start( const DtcClearList& dtcList );
      tDiaResult stop( const ItcReportList& itcList );

   protected:
      //! IErrorLogListener callbacks
      virtual void vOnControlResult ( void ) override;
      virtual void vOnClearResult ( void ) override;
      virtual void vOnClearError( tU32 ) override;
      virtual void vOnDiaglogWriteTestResult( void ) override;
      virtual void vOnDiaglogWriteTestError ( const tU32 ) override;

      const dia_DataDownloadManagerPlugin_CMC* mpPlugin;
      dia_Dataset* mpDataset;
      dia_IErrorLog* mpErrorLog;

      //! DTCs to be deleted
      //DtcClearList mDTCList;
      //tU32 mDtcCount;

      //! ITCs to be reported
      //ItcReportList mITCList;
      //tU32 mItcCount; 
   };

protected:
   const std::map<tU32, tU16> mLogicAddrToDtcGroupRepo;

   //! mapping of DTC FTB Programming to Property ID.
   const std::map<tU32, tU32> mDtcProgrammingToPropertyIDRepo;
   //! mapping of Address to ITC and Property
   const std::map<tU32, std::pair <tU32,tU32> > mStartAddrToItcAndPropIDRepo;

   static std::unique_ptr<DiaglogAgent> mpDiaglogAgent;
};

#endif /* __INCLUDED_DATA_DOWNLOAD_MANAGER_PLUGIN_AIVI__ */
