/**
 * \file    dia_DataDownloadStrategyInstallationContainer.h
 *
 * \brief   Implements the data downlad strategy for CIS Installation Container.
 *
 * \author  ama8kor
 * \date    20.05.2019
 *
 * \copyright Robert Bosch Car Multimedia 2019
 */
 
#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_INSTALLATION_CONTAINER__
#define __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_INSTALLATION_CONTAINER__

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_DEFAULT__
#include "common/framework/datadownload/dia_DataDownloadStrategyDefault.h"
#endif

class dia_DataDownloadStrategyInstallationContainer
   : public dia_DataDownloadStrategyDefault
{
private:
   //! class constructor
   dia_DataDownloadStrategyInstallationContainer ( void );

public:
   //! class constructor
   dia_DataDownloadStrategyInstallationContainer ( tU8 fmtID, tU8 addrFmt);
   //! class destructor
   virtual ~dia_DataDownloadStrategyInstallationContainer ( void );

   virtual tDiaResult requestDownload ( std::vector<tU8>& requestData );

   virtual tDiaResult requestUpload (std::vector<tU8>& requestData );

   virtual tDiaResult transferExit ( std::vector<tU8>& requestData );

   //! called by the session control object to notify about a session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );

};

#endif /* __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_INSTALLATION_CONTAINER__ */