/*
 * dia_DataDownloadConfigProject.h
 *
 *  Created on: 19.05.2015
 *      Author: wgl2hi
 */

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_CONFIG_PROJECT__
#define __INCLUDED_DIA_DATA_DOWNLOAD_CONFIG_PROJECT__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_DATASET__
#include "common/framework/datadownload/dia_Dataset.h"
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

//CD-DEF
extern const tChar* strDpNameDefAcousticParamElemData;
extern const tChar* strDpNameDefPhoneECNRWbsElemData;
extern const tChar* strDpNameDefPhoneECNRNbsElemData;
extern const tChar* strDpNameDefCarPlayPhoneECNRNbsElemData;
extern const tChar* strDpNameDefCarPlayPhoneECNRWbsElemData;
extern const tChar* strDpNameDefCarPlayFacetimeECNRSwbElemData;

//PD
extern const tChar* strDatasetNameAudioSrcOffset;
extern const tChar* strDpNameVRParamElemData;
extern const tChar* strDpNameBrightnessElemData;

/* CD - Programming Session */
extern const tChar* strDpNameESEElemData;
extern const tChar* strDpNameEcnrBtVoiceNBElemData;
extern const tChar* strDpNameEcnrBtVoiceWBElemData;
extern const tChar* strDpNameEcnrBtSiriWBElemData;
extern const tChar* strDpNameEcnrCpVoiceWBElemData;
extern const tChar* strDpNameEcnrAaVoiceWBElemData;
extern const tChar* strDpNameEcnrVpaVoiceWBElemData;

#define UPDOWNLOADABLE_LITTLE_ENDIAN         (DIA_C_U16_DATASET_CFG_UPDOWNLOADABLE | DIA_C_U16_DATASET_CFG_CRC_FMT_LITTLE_ENDIAN)
#define UPDOWNLOADABLE_NO_CRC_CHECK          (DIA_C_U16_DATASET_CFG_UPDOWNLOADABLE | DIA_C_U16_DATASET_CFG_NO_CRC_CHECK)

/********************************* CD-CMC ***************************************/
#define CMC_INSTALLATION_CONTAINER_START             ((tU32)0x00000004)
#define CMC_INSTALLATION_CONTAINER_LEN               ((tU32)3*1024*1024)
#define CMC_INSTALLATION_CONTAINER_END               (CMC_INSTALLATION_CONTAINER_START + CMC_INSTALLATION_CONTAINER_LEN - 1)

#define CMC_INSTALLATION_LOG_FILE_START             ((tU32)0x00000005)
#define CMC_INSTALLATION_LOG_FILE_LEN               ((tU32)1024*1024)
#define CMC_INSTALLATION_LOG_FILE_END               (CMC_INSTALLATION_LOG_FILE_START + CMC_INSTALLATION_LOG_FILE_LEN - 1)

#define CMC_AVDECC_CONFIGURATION_DATABASE_START     ((tU32)0x00000003)
#define CMC_AVDECC_CONFIGURATION_DATABASE_LEN       ((tU32)1024*1024)
#define CMC_AVDECC_CONFIGURATION_DATABASE_END       (CMC_AVDECC_CONFIGURATION_DATABASE_START + CMC_AVDECC_CONFIGURATION_DATABASE_LEN - 1)

#define CMC_STARTUPSCREEN_START                     ((tU32)0x00000006)
#define CMC_STARTUPSCREEN_LEN                       ((tU32)2*1024*1024)
#define CMC_STARTUPSCREEN_END                       (CMC_STARTUPSCREEN_START + CMC_STARTUPSCREEN_LEN - 1)

/********************************* CD-DEF ***************************************/
#define DEF_PHONE_ECNR_WBS_START             ((tU32)0x008200)
#define DEF_PHONE_ECNR_WBS_LEN               ((tU32)4*1024 - 4)
#define DEF_PHONE_ECNR_WBS_END               (DEF_PHONE_ECNR_WBS_START + DEF_PHONE_ECNR_WBS_LEN - 1)

#define DEF_PHONE_ECNR_NBS_START             ((tU32)0x00D5FF)
#define DEF_PHONE_ECNR_NBS_LEN               ((tU32)4*1024 - 4)
#define DEF_PHONE_ECNR_NBS_END               (DEF_PHONE_ECNR_NBS_START + DEF_PHONE_ECNR_NBS_LEN - 1)

#define DEF_CARPLAY_PHONE_ECNR_NBS_START     ((tU32)0x0129FE)
#define DEF_CARPLAY_PHONE_ECNR_NBS_LEN       ((tU32)4*1024 - 4)
#define DEF_CARPLAY_PHONE_ECNR_NBS_END       (DEF_CARPLAY_PHONE_ECNR_NBS_START + DEF_CARPLAY_PHONE_ECNR_NBS_LEN - 1)

#define DEF_CARPLAY_PHONE_ECNR_WBS_START     ((tU32)0x017DFD)
#define DEF_CARPLAY_PHONE_ECNR_WBS_LEN       ((tU32)4*1024 - 4)
#define DEF_CARPLAY_PHONE_ECNR_WBS_END       (DEF_CARPLAY_PHONE_ECNR_WBS_START + DEF_CARPLAY_PHONE_ECNR_WBS_LEN - 1)

#define DEF_CARPLAY_FACETIME_ECNR_SWB_START  ((tU32)0x01D1FC)
#define DEF_CARPLAY_FACETIME_ECNR_SWB_LEN    ((tU32)4*1024 - 4)
#define DEF_CARPLAY_FACETIME_ECNR_SWB_END    (DEF_CARPLAY_FACETIME_ECNR_SWB_START + DEF_CARPLAY_FACETIME_ECNR_SWB_LEN - 1)

#define DEF_ACOUSTIC_PARAM_START             ((tU32)0x0279FA)
#define DEF_ACOUSTIC_PARAM_LEN               ((tU32)4*1024 - 4)
#define DEF_ACOUSTIC_PARAM_END               (DEF_ACOUSTIC_PARAM_START + DEF_ACOUSTIC_PARAM_LEN - 1)

/*********************************** PD *****************************************/
#define VR_PARAM_START                       ((tU32)0x0225FB)
#define VR_PARAM_LEN                         ((tU32)4*1024 - 4)
#define VR_PARAM_END                         (VR_PARAM_START + VR_PARAM_LEN - 1)

#define AUDIO_SOURCE_OFFSET_START            ((tU32)0x0299F6)
#define AUDIO_SOURCE_OFFSET_LEN              ((tU32)301)
#define AUDIO_SOURCE_OFFSET_END              (AUDIO_SOURCE_OFFSET_START + AUDIO_SOURCE_OFFSET_LEN - 1)

#define BRIGHTNESS_START                     ((tU32)0x480000)
#define BRIGHTNESS_LEN                       ((tU32)1764)
#define BRIGHTNESS_END                       (BRIGHTNESS_START + BRIGHTNESS_LEN - 1)

#define CERTIFICATE_START                    ((tU32)0x481000)
#define CERTIFICATE_LEN                      ((tU32)10*1024)
#define CERTIFICATE_END                      (CERTIFICATE_START + CERTIFICATE_LEN - 1)

/*********************************** CD - Programming Session *****************************************/
#define BLOCK_INTERVAL                             ((tU32)64*1024)     //64kB
#define PROGRAMMING_BASE_ADDR                      ((tU32)0x500000)

#define BLOCK_FD00_REFERENCE_CHECKSUM_START        ((tU32)(PROGRAMMING_BASE_ADDR + 0*BLOCK_INTERVAL))
#define BLOCK_FD00_REFERENCE_CHECKSUM_LEN          ((tU32)1*1024)
#define BLOCK_FD00_REFERENCE_CHECKSUM_END          (BLOCK_FD00_REFERENCE_CHECKSUM_START + BLOCK_FD00_REFERENCE_CHECKSUM_LEN)

#define BLOCK_FD01_PHONE_ECNR_NBS_START            ((tU32)(PROGRAMMING_BASE_ADDR + 1*BLOCK_INTERVAL))
#define BLOCK_FD01_PHONE_ECNR_NBS_LEN              ((tU32)20*1024)
#define BLOCK_FD01_PHONE_ECNR_NBS_END              (BLOCK_FD01_PHONE_ECNR_NBS_START + BLOCK_FD01_PHONE_ECNR_NBS_LEN - 1)

#define BLOCK_FD02_PHONE_ECNR_WBS_START            ((tU32)(PROGRAMMING_BASE_ADDR + 2*BLOCK_INTERVAL))
#define BLOCK_FD02_PHONE_ECNR_WBS_LEN              ((tU32)20*1024)
#define BLOCK_FD02_PHONE_ECNR_WBS_END              (BLOCK_FD02_PHONE_ECNR_WBS_START + BLOCK_FD02_PHONE_ECNR_WBS_LEN - 1)

#define BLOCK_FD03_VR_PARAM_START                  ((tU32)(PROGRAMMING_BASE_ADDR + 3*BLOCK_INTERVAL))
#define BLOCK_FD03_VR_PARAM_LEN                    ((tU32)20*1024)
#define BLOCK_FD03_VR_PARAM_END                    (BLOCK_FD03_VR_PARAM_START + BLOCK_FD03_VR_PARAM_LEN - 1)

#define BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_START    ((tU32)(PROGRAMMING_BASE_ADDR + 4*BLOCK_INTERVAL))
#define BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_LEN      ((tU32)20*1024)
#define BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_END      (BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_START + BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_LEN - 1)

#define BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_START    ((tU32)(PROGRAMMING_BASE_ADDR + 5*BLOCK_INTERVAL))
#define BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_LEN      ((tU32)20*1024)
#define BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_END      (BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_START + BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_LEN - 1)

#define BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_START ((tU32)(PROGRAMMING_BASE_ADDR + 6*BLOCK_INTERVAL))
#define BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_LEN   ((tU32)20*1024)
#define BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_END   (BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_START + BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_LEN - 1)

#define BLOCK_FD07_ACOUSTIC_PARAM_START            ((tU32)(PROGRAMMING_BASE_ADDR + 7*BLOCK_INTERVAL))
#define BLOCK_FD07_ACOUSTIC_PARAM_LEN              ((tU32)20*1024)
#define BLOCK_FD07_ACOUSTIC_PARAM_END              (BLOCK_FD07_ACOUSTIC_PARAM_START + BLOCK_FD07_ACOUSTIC_PARAM_LEN - 1)

#define BLOCK_FD08_ESE_START                       ((tU32)(PROGRAMMING_BASE_ADDR + 8*BLOCK_INTERVAL))
#define BLOCK_FD08_ESE_LEN                         ((tU32)64*1024-1)
#define BLOCK_FD08_ESE_END                         (BLOCK_FD08_ESE_START + BLOCK_FD08_ESE_LEN - 1)

#define BLOCK_FD09_BT_VOICE_ECNR_NBS_START         ((tU32)(PROGRAMMING_BASE_ADDR + 9*BLOCK_INTERVAL)) //0x2F0000 -> 0x590000
#define BLOCK_FD09_BT_VOICE_ECNR_NBS_LEN           ((tU32)20*1024)
#define BLOCK_FD09_BT_VOICE_ECNR_NBS_END           (BLOCK_FD09_BT_VOICE_ECNR_NBS_START + BLOCK_FD09_BT_VOICE_ECNR_NBS_LEN - 1)

#define BLOCK_FD0A_BT_VOICE_ECNR_WBS_START         ((tU32)(PROGRAMMING_BASE_ADDR + 10*BLOCK_INTERVAL)) //0x340000 -> 0x5A0000
#define BLOCK_FD0A_BT_VOICE_ECNR_WBS_LEN           ((tU32)20*1024)
#define BLOCK_FD0A_BT_VOICE_ECNR_WBS_END           (BLOCK_FD0A_BT_VOICE_ECNR_WBS_START + BLOCK_FD0A_BT_VOICE_ECNR_WBS_LEN - 1)

#define BLOCK_FD0B_BT_SIRI_ECNR_WBS_START          ((tU32)(PROGRAMMING_BASE_ADDR + 11*BLOCK_INTERVAL)) //0x390000 -> 0x5B0000
#define BLOCK_FD0B_BT_SIRI_ECNR_WBS_LEN            ((tU32)20*1024)
#define BLOCK_FD0B_BT_SIRI_ECNR_WBS_END            (BLOCK_FD0B_BT_SIRI_ECNR_WBS_START + BLOCK_FD0B_BT_SIRI_ECNR_WBS_LEN - 1)

#define BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_START     ((tU32)(PROGRAMMING_BASE_ADDR + 12*BLOCK_INTERVAL)) //0x3E0000 -> 0x5C0000
#define BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_LEN       ((tU32)20*1024)
#define BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_END       (BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_START + BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_LEN - 1)

#define BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_START  ((tU32)(PROGRAMMING_BASE_ADDR + 13*BLOCK_INTERVAL)) //0x430000 -> 0x5D0000
#define BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_LEN    ((tU32)20*1024)
#define BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_END    (BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_START + BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_LEN - 1)

#define BLOCK_FD0E_ECNR_VPA_VOICE_WB_START         ((tU32)(PROGRAMMING_BASE_ADDR + 14*BLOCK_INTERVAL))
#define BLOCK_FD0E_ECNR_VPA_VOICE_WB_LEN           ((tU32)20*1024)
#define BLOCK_FD0E_ECNR_VPA_VOICE_WB_END           (BLOCK_FD0E_ECNR_VPA_VOICE_WB_START + BLOCK_FD0E_ECNR_VPA_VOICE_WB_LEN - 1)

const dia_DatasetConfig
aDiaDatasetConfigProject[] = {

 /********************************* CD-DEF ***************************************/
 dia_DatasetConfig( strDpNameDefPhoneECNRWbsElemData,           DEF_PHONE_ECNR_WBS_START,           DEF_PHONE_ECNR_WBS_END,             DEF_PHONE_ECNR_WBS_LEN,                UPDOWNLOADABLE_LITTLE_ENDIAN, DIA_PROP_AIVI_DEF_PHONE_ECNR_WBS,            0x00000000 ),
 dia_DatasetConfig( strDpNameDefPhoneECNRNbsElemData,           DEF_PHONE_ECNR_NBS_START,           DEF_PHONE_ECNR_NBS_END,             DEF_PHONE_ECNR_NBS_LEN,                UPDOWNLOADABLE_LITTLE_ENDIAN, DIA_PROP_AIVI_DEF_PHONE_ECNR_NBS,            0x00000000 ),
 dia_DatasetConfig( strDpNameDefCarPlayPhoneECNRNbsElemData,    DEF_CARPLAY_PHONE_ECNR_NBS_START,   DEF_CARPLAY_PHONE_ECNR_NBS_END,     DEF_CARPLAY_PHONE_ECNR_NBS_LEN,        UPDOWNLOADABLE_LITTLE_ENDIAN, DIA_PROP_AIVI_DEF_CARPLAY_PHONE_ECNR_NBS,    0x00000000 ),
 dia_DatasetConfig( strDpNameDefCarPlayPhoneECNRWbsElemData,    DEF_CARPLAY_PHONE_ECNR_WBS_START,   DEF_CARPLAY_PHONE_ECNR_WBS_END,     DEF_CARPLAY_PHONE_ECNR_WBS_LEN,        UPDOWNLOADABLE_LITTLE_ENDIAN, DIA_PROP_AIVI_DEF_CARPLAY_PHONE_ECNR_WBS,    0x00000000 ),
 dia_DatasetConfig( strDpNameDefCarPlayFacetimeECNRSwbElemData, DEF_CARPLAY_FACETIME_ECNR_SWB_START,DEF_CARPLAY_FACETIME_ECNR_SWB_END,  DEF_CARPLAY_FACETIME_ECNR_SWB_LEN,     UPDOWNLOADABLE_LITTLE_ENDIAN, DIA_PROP_AIVI_DEF_CARPLAY_FACETIME_ECNR_SWB, 0x00000000 ),
 dia_DatasetConfig( strDpNameDefAcousticParamElemData,          DEF_ACOUSTIC_PARAM_START,           DEF_ACOUSTIC_PARAM_END,             DEF_ACOUSTIC_PARAM_LEN,                UPDOWNLOADABLE_NO_CRC_CHECK,  DIA_PROP_AIVI_DEF_ACOUSTIC_PARAM,            0x00000000 ),

 /*********************************** PD *****************************************/
 dia_DatasetConfig( strDpNameVRParamElemData,                   VR_PARAM_START,                     VR_PARAM_END,                       VR_PARAM_LEN,                          UPDOWNLOADABLE_LITTLE_ENDIAN, DIA_PROP_AIVI_VR_PARAM,                      0x00000000 ),
 dia_DatasetConfig( strDatasetNameAudioSrcOffset,               AUDIO_SOURCE_OFFSET_START,          AUDIO_SOURCE_OFFSET_END,            DIA_PROP_AIVI_AUDIO_SOURCE_OFFSET_LEN, UPDOWNLOADABLE_LITTLE_ENDIAN, DIA_PROP_AID_AUDIO_SOURCE_OFFSET,            0x00000000 ),
 dia_DatasetConfig( strDpNameBrightnessElemData,                BRIGHTNESS_START,                   BRIGHTNESS_END,                     BRIGHTNESS_LEN,                        UPDOWNLOADABLE_NO_CRC_CHECK,  DIA_PROP_AIVI_BRIGHTNESS,                    0x00000000 ),
 //File
 dia_DatasetConfig( strFileNameCertificate,                     CERTIFICATE_START,                  CERTIFICATE_END,                    CERTIFICATE_LEN,                       UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH,  DIA_PROP_AIVI_CERTIFICATE, 0x00000000 ),
 
 /********************************* CD-CMC ***************************************/
 dia_DatasetConfig( strFileNameInstallationContainer,           CMC_INSTALLATION_CONTAINER_START,           CMC_INSTALLATION_CONTAINER_END,           CMC_INSTALLATION_CONTAINER_LEN,           UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH,  DIA_PROP_CMC_INSTALLATION_CONTAINER, 0x00000000 ),
 dia_DatasetConfig( strFileNameInstallationLogFile,             CMC_INSTALLATION_LOG_FILE_START,            CMC_INSTALLATION_LOG_FILE_END,            CMC_INSTALLATION_LOG_FILE_LEN,            UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH,  DIA_PROP_CMC_INSTALLATION_LOG_FILE,  0x00000000 ),
 dia_DatasetConfig( strFileNameAvdeccCfgDbFile,                 CMC_AVDECC_CONFIGURATION_DATABASE_START,    CMC_AVDECC_CONFIGURATION_DATABASE_END,    CMC_AVDECC_CONFIGURATION_DATABASE_LEN,    UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH,  DIA_PROP_CMC_AVDECC_CFG_DB_FILE,     0x00000000 ),
 dia_DatasetConfig( strFileNameStartupScreenFile,               CMC_STARTUPSCREEN_START,                    CMC_STARTUPSCREEN_END,                    CMC_STARTUPSCREEN_LEN,                    UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH,  DIA_PROP_CMC_STARTUPSCREEN_FILE,     0x00000000 ),

 /*********************************** CD - Programming Session *****************************************/
 dia_DatasetConfig( strDpNameLB00ReferenceChksElemData,         BLOCK_FD00_REFERENCE_CHECKSUM_START,        BLOCK_FD00_REFERENCE_CHECKSUM_END,        BLOCK_FD00_REFERENCE_CHECKSUM_LEN,        UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AIVI_BLOCK_FD00_REFERENCE_CHECKSUM, 0x00000000 ),
 dia_DatasetConfig( strDpNamePhoneECNRNbsElemData,              BLOCK_FD01_PHONE_ECNR_NBS_START,            BLOCK_FD01_PHONE_ECNR_NBS_END,            BLOCK_FD01_PHONE_ECNR_NBS_LEN,            UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB,       0x00000000 ),
 dia_DatasetConfig( strDpNamePhoneECNRWbsElemData,              BLOCK_FD02_PHONE_ECNR_WBS_START,            BLOCK_FD02_PHONE_ECNR_WBS_END,            BLOCK_FD02_PHONE_ECNR_WBS_LEN,            UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB,       0x00000000 ),
 dia_DatasetConfig( strDpNameVRParamElemData,                   BLOCK_FD03_VR_PARAM_START,                  BLOCK_FD03_VR_PARAM_END,                  BLOCK_FD03_VR_PARAM_LEN,                  UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AIVI_VR_PARAM,                      0x00000000 ),
 dia_DatasetConfig( strDpNameCarPlayPhoneECNRNbsElemData,       BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_START,    BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_END,    BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_LEN,    UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB,       0x00000000 ),
 dia_DatasetConfig( strDpNameCarPlayPhoneECNRWbsElemData,       BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_START,    BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_END,    BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_LEN,    UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB,       0x00000000 ),
 dia_DatasetConfig( strDpNameCarPlayFacetimeECNRSwbElemData,    BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_START, BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_END, BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_LEN, UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB,   0x00000000 ),
 dia_DatasetConfig( strDpNameAcousticParamElemData,             BLOCK_FD07_ACOUSTIC_PARAM_START,            BLOCK_FD07_ACOUSTIC_PARAM_END,            BLOCK_FD07_ACOUSTIC_PARAM_LEN,            UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AIVI_ACOUSTIC_PARAM,                0x00000000 ),
 dia_DatasetConfig( strDpNameESEElemData,                       BLOCK_FD08_ESE_START,                       BLOCK_FD08_ESE_END,                       BLOCK_FD08_ESE_LEN,                       UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AIVI_BLOCK_FD08_ESE,                0x00000000 ),
 dia_DatasetConfig( strDpNameEcnrBtVoiceNBElemData,             BLOCK_FD09_BT_VOICE_ECNR_NBS_START,         BLOCK_FD09_BT_VOICE_ECNR_NBS_END,         BLOCK_FD09_BT_VOICE_ECNR_NBS_LEN,         UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_BT_VOICE_NB,       0x00000000 ),
 dia_DatasetConfig( strDpNameEcnrBtVoiceWBElemData,             BLOCK_FD0A_BT_VOICE_ECNR_WBS_START,         BLOCK_FD0A_BT_VOICE_ECNR_WBS_END,         BLOCK_FD0A_BT_VOICE_ECNR_WBS_LEN,         UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_BT_VOICE_WB,       0x00000000 ),
 dia_DatasetConfig( strDpNameEcnrBtSiriWBElemData,              BLOCK_FD0B_BT_SIRI_ECNR_WBS_START,          BLOCK_FD0B_BT_SIRI_ECNR_WBS_END,          BLOCK_FD0B_BT_SIRI_ECNR_WBS_LEN,          UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_BT_SIRI_WB,        0x00000000 ),
 dia_DatasetConfig( strDpNameEcnrCpVoiceWBElemData,             BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_START,     BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_END,     BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_LEN,     UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_CP_VOICE_WB,       0x00000000 ),
 dia_DatasetConfig( strDpNameEcnrAaVoiceWBElemData,             BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_START,  BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_END,  BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_LEN,  UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_AA_VOICE_WB,       0x00000000 ),
 dia_DatasetConfig( strDpNameEcnrVpaVoiceWBElemData,            BLOCK_FD0E_ECNR_VPA_VOICE_WB_START,         BLOCK_FD0E_ECNR_VPA_VOICE_WB_END,         BLOCK_FD0E_ECNR_VPA_VOICE_WB_LEN,         UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH, DIA_PROP_AID_DATASET_ECNR_VPA_VOICE_WB,      0x00000000 ),


   dia_DatasetConfig("DATA_SET_TEST_200", 
   0xFF0000, 
   0, 
   200, 
   DIA_C_U16_DATASET_CFG_UPDOWNLOADABLE | DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH |  DIA_C_U16_DATASET_CFG_NO_CRC_CHECK, 
   DIA_PROP_TEST_PROPERTY_RAM_250, 
   0),
   dia_DatasetConfig("DATA_SET_TEST_195", 
   0xFF0001, 
   0, 
   195, 
   DIA_C_U16_DATASET_CFG_UPDOWNLOADABLE | DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH |  DIA_C_U16_DATASET_CFG_NO_CRC_CHECK,
   DIA_PROP_TEST_PROPERTY_RAM_250, 
   0),
   dia_DatasetConfig("DATA_SET_TEST_4200",
   0xFF0002,
   0,
   4200,
   DIA_C_U16_DATASET_CFG_UPDOWNLOADABLE | DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH |  DIA_C_U16_DATASET_CFG_NO_CRC_CHECK,
   DIA_PROP_TEST_PROPERTY_RAM_4500, 
   0)
};

#endif /* __INCLUDED_DIA_DATA_DOWNLOAD_CONFIG_PROJECT__ */
