/*
 * dia_EngineClientConfigInternalTester.h
 *
 *  Created on: 21.09.2015
 *      Author: nbs3kor
 */

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIG_INTERNAL_TESTER__
#define __INCLUDED_DIA_ENGINE_CLIENT_CONFIG_INTERNAL_TESTER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__
#include <common/framework/engine/dia_EngineClientConfiguration.h>
#endif

#define DIA_C_U16_MAX_SESSION_CLIENT_ENGINE             25
#define DIA_C_U16_MAX_SECURITY_LEVELS_PER_CLIENT_ENGINE 5

//-----------------------------------------------------------------------------

   struct InternalClientServiceDataItem
   {
      //! service identifier
      tU8  mSID;
      //! diagnostic data identifier
      tU16 mDID;
      //! length of the DID
      tU16 mDIDLen;
      //! run level information
      tU8  mRunLevel;
      //! supported sessions
      tU8  mSupportedSessions[DIA_C_U16_MAX_SESSION_CLIENT_ENGINE];
      //! supported security levels
      dia_UID  mSupportedSecurityLevels[DIA_C_U16_MAX_SECURITY_LEVELS_PER_CLIENT_ENGINE];
   };

//-----------------------------------------------------------------------------

   struct InternalClientServiceInfo
   {
      //! service identifier
      tU8  mSID;
      //! diagnostic data identifier
      tU8  mAccessInfo;
      //! length of the DID
      tU16 mDIDLen;
      //! supported sessions
      tU8  mSupportedSessions[DIA_C_U16_MAX_SESSION_CLIENT_ENGINE];
      //! supported security levels
      dia_UID  mSupportedSecurityLevels[DIA_C_U16_MAX_SECURITY_LEVELS_PER_CLIENT_ENGINE];
   };
//-----------------------------------------------------------------------------

class dia_EngineClientConfigInternalTester
   : public dia_EngineClientConfiguration
{

   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_EngineClientConfigInternalTester);

public:

   virtual tDiaResult loadIntClientEngineConfigServiceData ( /*const InternalClientServiceDataItem InternalEngineServiceData[], tU16 numOfItems*/void );

   virtual tDiaResult getIntClientEngineConfigServiceData ( tU16 receivedDID,  InternalClientServiceDataItem& servicedata);

   virtual tDiaResult loadIntClientEngineConfigServiceInfo ( /*const InternalClientServiceInfo InternalEngineServiceData[], tU16 numOfItems*/void );

   virtual tDiaResult getIntClientEngineConfigServiceInfo ( tU8 receivedSID,  InternalClientServiceInfo& serviceInfo);

   virtual tDiaResult validateProtocol (void) const;

protected:
   //! deprecated class constructor (no implementation)
   dia_EngineClientConfigInternalTester ( void );
   //! class destructor
   virtual ~dia_EngineClientConfigInternalTester ( void );

protected:

   // map that provides access information on subfunction level
   std::map<tU16,InternalClientServiceDataItem> mIntClientEngineServDataRep;

   // map that provides access information on service level
   std::map<tU8,InternalClientServiceInfo> mIntClientEngineServInfoRep;

};

dia_EngineClientConfigInternalTester* getInstanceOfdiaEngineInternalTesterConfiguration ( void );
void releaseInstanceOfdiaEngineInternalTesterConfiguration ( void );

#endif /* __INCLUDED_DIA_ENGINE_CLIENT_CONFIG_INTERNAL_TESTER__ */
