/*
 * dia_EngineClientConfigInternalTester.cpp
 *
 *  Created on: 21.09.2015
 *      Author: nbs3kor
 *
 *-------------------------------------------------------------------------------------------
 * Date        Author      Modification
 *
 * 08.01.2016  bma9kor      Added DID for Input Lines. (NCG3D-6659)
 *
 * -------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE__
#include "common/framework/engine/dia_Engine.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIG_INTERNAL_TESTER__
#include "project/framework/config/dia_EngineClientConfigInternalTester.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include "common/framework/security/dia_security.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif
// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_EngineClientConfigInternalTester)

#ifndef __DIA_UNIT_TESTING__

dia_EngineClientConfigInternalTester*
getInstanceOfdiaEngineInternalTesterConfiguration ( void )
{
   return dia_EngineClientConfigInternalTester::getInstance();
}

void
releaseInstanceOfdiaEngineInternalTesterConfiguration( void )
{
	dia_EngineClientConfigInternalTester::deleteInstance();
}
#endif

/* Project specific Internal client engine services */

//lint -e785 sbr5kor: the array of supported sessions only provides initializers for the supported session. other fields are automatically initialized with 0

const InternalClientServiceInfo
aInternalClientserviceInfoRep[] =
{
      { DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,  DIA_C_U8_UDS_SERVICE_SUPPORTED_SELECTIVELY, 0x02, {0x01, 0x03, 0x60, 0x61} },             // Read Data by ID
      { DIA_C_U8_UDS_SID_ROUTINE_CONTROL,          DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {            0x60, 0x61} },             // Routine Control
      { DIA_C_U8_UDS_SID_IOCONTROL_BY_IDENTIFIER,  DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x02, {      0x03, 0x60, 0x61} },             // IO Control
      { DIA_C_U8_UDS_SID_READ_DTC_INFO,            DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {      0x03, 0x60, 0x61} },             // Read DTC info
      { DIA_C_U8_UDS_SID_CLEAR_DIAG_INFO,          DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {0x01, 0x03, 0x60, 0x61} },             // Clear info
      { DIA_C_U8_UDS_SID_ECU_RESET,                DIA_C_U8_UDS_SERVICE_SUPPORTED,             0x01, {      0x03            } }              // ECUReset
};

//lint +e785

//lint -e785 sbr5kor: the array of supported sessions only provides initializers for the supported session. other fields are automatically initialized with 0

const InternalClientServiceDataItem
aInternalClientServiceDataItem[] =
{
    { 0x22, DIA_C_U16_DID_RBCM_DISPLAY_TEMPERATURE,      0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_SrvHandler_Disp_PanelTempInfo_Get
    { 0x22, DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE,     0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, //LCM_PowerSupplyVoltage
    { 0x22, DIA_C_U16_DID_RBCM_SYSTEM_RESET_INFORMATION, 0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },   // dia_SrvHandler_GetSystemResetInformation
    { 0x22, DIA_C_U16_DID_RBCM_USB_DEVICES_INFO,         0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
    { 0x22, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_PWM,     0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
    { 0x22, DIA_C_U16_DID_RBCM_MIC_PS_INFO_1,            0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - MicrophoneCurrent1
//    { 0x22, DIA_C_U16_DID_RBCM_MIC_PS_INFO_2,            0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - MicrophoneCurrent2
    { 0x22, DIA_C_U16_DID_RBCM_KEY_PRESSED,              0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - PressedKey
    { 0x22, DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_1_STATUS,0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - PressedKey
    { 0x22, DIA_C_U16_DID_RBCM_ECU_SPARE_PART_NUMBER,    0x02, DIA_C_U8_RUNLEVEL_1, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - ECUSparePartNumber
    { 0x22, DIA_C_U16_DID_RBCM_GYRO_TEMPERATURE,         0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Gyro Temperature
    { 0x22, DIA_C_U16_DID_RBCM_EMMC_TEMPERATURE,         0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - EMMC Temperature
    { 0x22, DIA_C_U16_DID_RBCM_IMX_TEMPERATURE,          0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - i.MX Temperature
    { 0x22, DIA_C_U16_DID_RBCM_PANEL_TEMPERATURE,        0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Display Temperature
    { 0x22, DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_TEMPERATURE,0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - CD Drive Temperature
    { 0x22, DIA_C_U16_DID_RBCM_AMPLIFIER_TEMPERATURE,    0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Amplifier Temperature
    { 0x22, DIA_C_U16_DID_RBCM_HEATSINK_TEMPERATURE,     0x02, DIA_C_U8_RUNLEVEL_2, {   0x60     }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - HeatSink Temperature

    { 0x22, DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER,      0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x60  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Configuration Part Number
    { 0x22, DIA_C_U16_DID_AIVI_BATTERY_LEVEL,            0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Read Battery Voltage
    { 0x22, DIA_C_U16_DID_AIVI_ECU_SERIAL_NUMBER_IDENTIFIER, 0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03}, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - ECUSerialNumberDataIdentifier
    { 0x22, DIA_C_U16_DID_AIVI_SPEED_INFO,               0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_SpeedInformation
    { 0x22, DIA_C_U16_DID_AIVI_MULTIPLEX_NETWORK_DIAG,   0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Multiplex network diagnostic
    { 0x22, DIA_C_U16_DID_AIVI_MULTIMEDIA_NETWORK_DIAG,  0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - Multimedia network diagnostic
    { 0x22, DIA_C_U16_DID_AIVI_HWSW_VERSION,             0x02, DIA_C_U8_RUNLEVEL_1, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - HWSWVersion
    { 0x22, DIA_C_U16_DID_AIVI_INPUT_LINES,              0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_InputLines
    { 0x22, DIA_C_U16_DID_AIVI_KEY_PRESS_SWS,            0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - dia_SrvHandler_KeyPressSws

    { 0x22, DIA_C_U16_DID_AIVI_CM_ECU_SOFTWARE_NUMBER,   0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadECUsoftwareNumber
    { 0x22, DIA_C_U16_DID_AIVI_CM_ECU_SOFTWARE_VERSION_NUMBER, 0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadECUsoftwareVersionNumber
    { 0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_ECU_HW_NR, 0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadVehiManECUHardwareNumber
    { 0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_R_NR, 0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadVehiManECUHardwareNumberRenault
    { 0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_N_NR, 0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadVehiManECUHardwareNumberNissan
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
    { 0x22, DIA_C_U16_DID_AIVI_CONFIG_FILE_REFERENCE_LINK_RUC, 0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadRUC
    { 0x22, DIA_C_U16_DID_AIVI_ALLIANCE_SW_REF,          0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadAllianceSWReference
#endif
    { 0x22, DIA_C_U16_DID_AIVI_CONFIG_SYSTEM_SUPPLIER_NR,0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadConfigSystemSupplierNumber
    //{ 0x22, DIA_C_U16_DID_AIVI_VIN,                      0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadVehicleIdentNumber
    { 0x22, DIA_C_U16_DID_AIVI_HW_REF_A,                 0x02, DIA_C_U8_RUNLEVEL_2, {    0x60    }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // ReadDataByIdentifier - SrvHandler_ReadHWRefA

    { 0x2F, DIA_C_U16_DID_AIVI_LOUDSPEAKER_TEST_TONE,    0x02, DIA_C_U8_RUNLEVEL_2, {      0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlLoudspeakerTestTone
    { 0x2F, DIA_C_U16_DID_AIVI_SPEAKER_TEST,             0x02, DIA_C_U8_RUNLEVEL_2, {      0x03  }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, // dia_IOCtrlSpeakerTest

    { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_AIVI_CLEAR_MCAN_CONNECTION_HISTORY,          0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // dia_RtCtrlClearMCANConnectionHistory
    { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RBCM_RTCTRL_RESET_SYSTEM_RESET_INFORMATION,  0x02, DIA_C_U8_RUNLEVEL_2, {            0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // reset system reset information
    { DIA_C_U8_UDS_SID_ROUTINE_CONTROL, DIA_C_U16_DID_RTCTRL_SELF_DIAGNOSIS,                       0x02, DIA_C_U8_RUNLEVEL_2, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} }, // dia_RtCtrlSelfDiagnosis

    { DIA_C_U8_UDS_SID_CLEAR_DIAG_INFO, 0xFFFF, 0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03,             0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },
    { DIA_C_U8_UDS_SID_CLEAR_DIAG_INFO, 0xD000, 0x02, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03,             0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} },

    { DIA_C_U8_UDS_SID_READ_DTC_INFO, UDS_REPORT_DTC_BY_STATUS_MASK, 0x01, DIA_C_U8_RUNLEVEL_2, {0x01, 0x03, 0x60      }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE, DIA_EN_SECURITY_LEVEL_BOSCH} }, //Read DTC by status mask

    { DIA_C_U8_UDS_SID_ECU_RESET, DIA_C_U8_SUBFUNC_AIVI_RESET_CONFIG_TO_DELIVERY_STATE, 0x01, DIA_C_U8_RUNLEVEL_1, {      0x03            }, {DIA_EN_SECURITY_LEVEL_NOT_ACTIVE} } //Reset Configuration to Delivery State

};

//lint +e785

/*loadIntClientEngineConfigServiceInfo(aInternalClientserviceInfoRep, sizeof(aInternalClientserviceInfoRep)/sizeof(InternalClientServiceInfo));
loadIntClientEngineConfigServiceData(aInternalClientServiceDataItem, sizeof(aInternalClientServiceDataItem)/sizeof(InternalClientServiceDataItem));*/

//-----------------------------------------------------------------------------

dia_EngineClientConfigInternalTester::dia_EngineClientConfigInternalTester ( void )
   : dia_EngineClientConfiguration("UNKNOWN_INETRNAL_ENGINE_CONFIGURATION",DIA_EN_PROTOCOL_UDS)
{
	(void) dia_EngineClientConfigInternalTester::loadIntClientEngineConfigServiceInfo();
	(void) dia_EngineClientConfigInternalTester::loadIntClientEngineConfigServiceData();
}

//-----------------------------------------------------------------------------

dia_EngineClientConfigInternalTester::~dia_EngineClientConfigInternalTester ( void )
{
}

//-----------------------------------------------------------------------------

//dia_EngineClientConfigInternalTester::dia_EngineClientConfigInternalTester ( tCString name, dia_enProtocol protocol )
//   : dia_EngineClientConfiguration(name, protocol)
//{}

//-----------------------------------------------------------------------------
tDiaResult
dia_EngineClientConfigInternalTester::loadIntClientEngineConfigServiceData ( /*const InternalClientServiceDataItem IntEngineServiceData[], tU16 numOfItems*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineClientConfigInternalTester::loadIntClientEngineConfigServiceData");

   tDiaResult retCode = DIA_SUCCESS;

   tU16 repSize = sizeof(aInternalClientServiceDataItem) / sizeof(aInternalClientServiceDataItem[0]);

/*   if ( IntEngineServiceData )
   {*/
	  for ( tU16 i=0; i<repSize; ++i )
	  {
	     mIntClientEngineServDataRep[aInternalClientServiceDataItem[i].mDID] = aInternalClientServiceDataItem[i];
	  }
	  //retCode = DIA_SUCCESS;
/*    }*/

   return retCode;
}
//-----------------------------------------------------------------------------
tDiaResult
dia_EngineClientConfigInternalTester::loadIntClientEngineConfigServiceInfo ( /*const InternalClientServiceInfo IntEngineService[], tU16 numOfItems*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineClientConfigInternalTester::loadIntClientEngineConfigServiceInfo");

   tDiaResult retCode = DIA_SUCCESS;

   tU16 repSize = sizeof(aInternalClientserviceInfoRep) / sizeof(aInternalClientserviceInfoRep[0]);

/*   if ( IntEngineService )
   {*/
	  for ( tU16 i=0; i<repSize; ++i )
	  {
		  mIntClientEngineServInfoRep[aInternalClientserviceInfoRep[i].mSID] = aInternalClientserviceInfoRep[i];
	  }
	  //retCode = DIA_SUCCESS;
/*    }*/

   return retCode;
}

/*//----------------------------------------------------------------------------------------

tDiaResult
dia_EngineClientConfigInternalTester::loadInternalEngineService ( const InternalClientServiceDataItem& servicedata )
{
   dia_tclFnctTrace oTrace("dia_EngineClientConfigInternalTester::loadInternalEngineService");

   mInternalClientEngineServDataRep[servicedata.mDID] = servicedata;
   return DIA_SUCCESS;
}*/

//----------------------------------------------------------------------------------------

tDiaResult
dia_EngineClientConfigInternalTester::getIntClientEngineConfigServiceData ( tU16 receivedDID, InternalClientServiceDataItem& servicedata)
{
	dia_tclFnctTrace oTrace("dia_EngineClientConfigInternalTester::getIntClientEngineConfigServiceData");

	tDiaResult retCode = DIA_FAILED;

    std::map<tU16,InternalClientServiceDataItem>::iterator iter = mIntClientEngineServDataRep.find(receivedDID);

    if ( iter != mIntClientEngineServDataRep.end() )
    {
        DIA_TR_INF("getIntClientEngineConfigServiceData,  DID found -- ");

        InternalClientServiceDataItem configuredServiceData = iter->second;

    	servicedata = configuredServiceData;

        DIA_TR_INF("### getIntClientEngineConfigServiceData : Quering DID from configuration: 0x%04x", (iter->second).mDID);

    	retCode = DIA_SUCCESS;
    }

    DIA_TR_INF("getIntClientEngineConfigServiceData,  Returning -- 0x%x", retCode);

    return retCode;

}
//----------------------------------------------------------------------------------------

tDiaResult
dia_EngineClientConfigInternalTester::getIntClientEngineConfigServiceInfo ( tU8 receivedSID, InternalClientServiceInfo& serviceInfo)
{
	dia_tclFnctTrace oTrace("dia_EngineClientConfigInternalTester::getIntClientEngineConfigServiceInfo");

	tDiaResult retCode = DIA_FAILED;

    std::map<tU8,InternalClientServiceInfo>::iterator iter = mIntClientEngineServInfoRep.find(receivedSID);

    if ( iter != mIntClientEngineServInfoRep.end() )
    {
        DIA_TR_INF("getIntClientEngineConfigServiceInfo,  SID found -- ");

        InternalClientServiceInfo configuredServiceInfo = iter->second;

        DIA_TR_INF("### getIntClientEngineConfigServiceInfo : Quering SID from configuration: 0x%02x", (iter->second).mSID);

        serviceInfo = configuredServiceInfo;
    	retCode = DIA_SUCCESS;
    }

    DIA_TR_INF("getIntClientEngineConfigServiceInfo,  Returning -- %u", retCode);

    return retCode;

}
//-----------------------------------------------------------------------------

tDiaResult
dia_EngineClientConfigInternalTester::validateProtocol ( void ) const
{
   dia_tclFnctTrace trc("dia_EngineClientConfigInternalTester::validateProtocol()");

   if ( getProtocol() != DIA_EN_PROTOCOL_UDS ) return DIA_FAILED;

   return DIA_SUCCESS;
}

