/*
 * dia_DefaultConfiguration.cpp
 *
 *  Created on: Oct 30, 2015
 *      Author: shw2abt
 *
 *  This is a small helper class to decide which default configuration table is in the currently active scope to be used.
 *  In this class is the only point where to define the tables and where the switch is done. So it's transparent for all other classes.
 */
#ifndef __INCLUDED_DIA_DEFAULT_CONFIGURATION__
#define __INCLUDED_DIA_DEFAULT_CONFIGURATION__

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

/*--------------------------------------*/
/* table definition of different scopes */
/*--------------------------------------*/
const dia_ConfigToDeliveryInfo aConfigToDeliveryRep_Set[] =
{
   //        				current property                              default property

   //KDS
   /*  1. */ { DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG,             DIA_PROP_CENTER_CMC_19_NVM_PNM_GROUP_10_CONFIG },
   /*  2. */ { DIA_PROP_CMC_CIS_CONFIG_CD,                            DIA_PROP_CMC_CIS_CONFIG_DEFAULT},

};



class dia_DefaultConfiguration
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_DefaultConfiguration);

   //-----------------------------------------------------------------------------

   static const tU8 getConfigToDeliveryRepSize()
   {
      dia_tclFnctTrace trc("dia_DefaultConfiguration::getConfigToDeliveryRepSize");
      int configurationSize = 0;


            DIA_TR_INF("dia_DefaultConfiguration::getConfigToTeliveryRep return table of Set .");
            configurationSize = (sizeof (aConfigToDeliveryRep_Set) / sizeof(aConfigToDeliveryRep_Set[0]));
   

      return configurationSize;
   }

   //-----------------------------------------------------------------------------

   // static function to read current active table
   static const dia_ConfigToDeliveryInfo *getConfigToDeliveryRep()
   {
      dia_tclFnctTrace trc("dia_DefaultConfiguration::getConfigToDeliveryRep");
      const dia_ConfigToDeliveryInfo* currTable;


            currTable = aConfigToDeliveryRep_Set;

      return currTable;
   }

   //-----------------------------------------------------------------------------

};
#endif /* __INCLUDED_DIA_DEFAULT_CONFIGURATION__ */
