/*!
 * \file       dia_defsSubsystemDiagnosis.h
 *
 * \brief      subsystem diagnosis defines
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       23.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#define __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__

//! Subsystem Diagnosis Strategy ID's
#define DIA_C_SUBSYSTEM_DIAGNOSIS_STRATEGY_DEFAULT							((tU32) 0xed50fd79)
#define DIA_C_SUBSYSTEM_DIAGNOSIS_STRATEGY_PRJ								((tU32) 0x2c390060)

//! Subsystem Diagnosis specific error codes
#define DIA_E_SUBSYSTEM_LIST_EMPTY											((tU32) 0x0513626e)
#define DIA_E_SUBSYSTEM_LIST_NOT_READY										((tU32) 0x89d88664)
#define DIA_E_SUBSYSTEM_PRE_COND_CHK_NOK									((tU32) 0xe003cb6a)
#define DIA_E_SUBSYSTEM_PWR_MOD_REQ_NOK										((tU32) 0x1d82e48a)
#define DIA_E_SUBSYSTEM_TCP_SOCKET_NOK										((tU32) 0xef69dd5a)
#define DIA_E_SUBSYSTEM_RTNG_ACT_NOK										((tU32) 0x2eb0d9dd)
#define DIA_E_SUBSYSTEM_RTNG_FAILED											((tU32) 0xafd22f43)
#define DIA_E_SUBSYSTEM_SESSION_ACT_FAILED									((tU32) 0x1f53e3c3)

//! Subsystem Diagnosis specific positive response codes
#define DIA_E_SUBSYSTEM_IDENTIFY_ENTITIES_RUNNING							((tU32) 0x99426144)
//#define DIA_E_SUBSYSTEM_IDENTIFY_ENTITIES_OK								((tU32) 0xdaea04dd)
#define DIA_E_SUBSYSTEM_IDENTIFY_ENTITIES_NOK								((tU32) 0x382a9d0b)
#define DIA_E_SUBSYSTEM_IDENTIFY_RESULT_RUNNING								((tU32) 0xaffc585e)
#define DIA_E_SUBSYSTEM_IDENTIFY_RESULT_OK								    ((tU32) 0x68cca3b7)

//! Subsystem Diagnosis specific timer definitions
#define DIA_C_SUBSYSTEM_IDENTIFY_ENTITIES_DELAY								  5000 /* Approx. 4 Seconds */
#define DIA_C_SUBSYSTEM_POWER_MODE_REQUEST_DELAY							   500 /* Approx. 0.5 Seconds */
#define DIA_C_SUBSYSTEM_ROUTING_ACTIVATION_DELAY							   500 /* Approx. 0.5 Seconds */
#define DIA_C_SUBSYSTEM_REQUEST_ROUTING_DELAY								  4500 /* Approx. 4.5 Seconds */
#define DIA_C_SUBSYSTEM_TESTER_PRESENT_TIMER_VAL_FIRST						   100 /* Approx. 100 Milli Seconds */
#define DIA_C_SUBSYSTEM_TESTER_PRESENT_TIMER_VAL							  4500 /* Approx. 4.5 Seconds */
#define DIA_C_SUBSYSTEM_SLAVE_PROCESS_TIMER_VAL  							  2500 /* Approx. 2.5 Seconds */

//! Other definitions
#define DIA_C_INVALID_TIMER_ID                 								((tU32) 0xFFFFFFFF)

//! error codes for handling wait response (NRC 0x78) from subsystem
#define DIA_C_SUBSYSTEM_RESPONSE_TYPE_WAIT_LENGTH							((tU8) 0x03)
#define DIA_C_SUBSYSTEM_RESPONSE_TYPE_WAIT_ID								((tU8) 0x7F)
#define DIA_C_SUBSYSTEM_RESPONSE_TYPE_WAIT_ID_IDX							((tU8) 0x00)
#define DIA_C_SUBSYSTEM_RESPONSE_TYPE_WAIT_NRC								((tU8) 0x78)
#define DIA_C_SUBSYSTEM_RESPONSE_TYPE_WAIT_NRC_IDX							((tU8) 0x02)

#define DIA_C_SUBSYSTEM_NEGATIVE_RESPONSE_LEN								((tU8) 0x03)
#define DIA_C_SUBSYSTEM_NEGATIVE_RESPONSE_ID								((tU8) 0x7F)
#define DIA_C_SUBSYSTEM_NEGATIVE_RESPONSE_CODE_CNC							((tU8) 0x22)

#define DIA_C_SUBSYSTEM_EXTENDED_SESSION_REQUEST_SRV_ID						((tU8) 0x10)
#define DIA_C_SUBSYSTEM_EXTENDED_SESSION_REQUEST_SES_ID						((tU8) 0x03)
#define DIA_C_SUBSYSTEM_EXTENDED_SESSION_POS_RESP_SRV_ID					((tU8) 0x50)
#define DIA_C_SUBSYSTEM_EXTENDED_SESSION_POS_RESP_SRV_ID_IDX				((tU8) 0x00)
#define DIA_C_SUBSYSTEM_EXTENDED_SESSION_POS_RESP_SES_ID					((tU8) 0x03)
#define DIA_C_SUBSYSTEM_EXTENDED_SESSION_POS_RESP_SES_ID_IDX				((tU8) 0x01)

#define DIA_C_SUBSYSTEM_TESTER_PRESENT_REQ_LEN								((tU8) 0x02)
#define DIA_C_SUBSYSTEM_TESTER_PRESENT_REQ_SRV_ID							((tU8) 0x3E)
#define DIA_C_SUBSYSTEM_TESTER_PRESENT_REQ_SUB_FUNC_ID						((tU8) 0x00)
#define DIA_C_SUBSYSTEM_TESTER_PRESENT_POS_RESP_SRV_ID						((tU8) 0x7E)
#define DIA_C_SUBSYSTEM_TESTER_PRESENT_POS_RESP_SRV_ID_IDX					((tU8) 0x00)
#define DIA_C_SUBSYSTEM_TESTER_PRESENT_POS_RESP_SUB_FUNC_ID					((tU8) 0x00)
#define DIA_C_SUBSYSTEM_TESTER_PRESENT_POS_RESP_SUB_FUNC_ID_IDX				((tU8) 0x01)

#define DIA_C_SUBSYSTEM_IDENTIFY_ENTITIES_INTERNAL_RESPONSE_DELAY			500

#define DIA_C_SUBSYSTEM_NODE_LIST_DATA_RESP_SIZE_PER_SUBSYTEM		        ((tU8) 0x06)
#define DIA_C_SUBSYSTEM_IDENTIFY_ENTITIES_RESP_SIZE_PER_SUBSYTEM		    ((tU8) 0x10)
#define DIA_C_SUBSYSTEM_IDENTIFY_ENTITIES_RESP_MAX_NUM_SUBSYSTEMS			((tU8) 0x2F)
#define DIA_C_SUBSYSTEM_IDENTIFY_ENTITIES_RESP_DEFAULT_DATA					((tU8) 0xFF)

//! Subsystem Entity Data Spec
#define DIA_C_SUBSYSTEM_ENTITY_NAME_LEN										((tU8) 0x02)
#define DIA_C_SUBSYSTEM_ENTITY_SW_VAR_LEN									((tU8) 0x02)
#define DIA_C_SUBSYSTEM_ENTITY_IP_ADDR_LEN									((tU8) 0x04)
#define DIA_C_SUBSYSTEM_ENTITY_ID_LEN										((tU8) 0x06)

#define DIA_C_SUBSYSTEM_ROUTING_ACTIVATION_TYPE								((tU8) 0x02)
#define DIA_C_SUBSYSTEM_POWER_MODE_READY									((tU8) 0x01)

//! DoIP Client Definitions
#define DIA_S_SUBSYSTEM_DOIP_CLIENT_ETH_NAME 								"ethernet"
#define DIA_C_SUBSYSTEM_DOIP_CLIENT_PORT_NUMBER								((tU16) 13400)
#define DIA_C_SUBSYSTEM_DOIP_CLIENT_TESTER_ADDR								((tU16) 0xFF1)
#define DIA_S_SUBSYSTEM_DOIP_BROADCAST_ADDR									"255.255.255.255" // "192.168.0.255"  // "255.255.255.255" 

//! DID's of subsystem services
//! Identification Data
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_AVBOS_VERSION					((tU16) 0xB001)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_GEN_AVB_VERSION				((tU16) 0xB002)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CONFIG_WRITE                    ((tU16) 0xB030)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CONFIG_READ                     ((tU16) 0xB1E0)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_SPARE_PART_NUMBER				((tU16) 0xC000)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_SERIAL_NUMBER					((tU16) 0xC001)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_SW_VERSION						((tU16) 0xC004)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_HW_VERSION						((tU16) 0xC005)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_NAME							((tU16) 0xC013)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SYSTEM_IDENTIFICATION				((tU16) 0xC200)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SW_FINGERPRINT						((tU16) 0xC210)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CFG_FINGERPRINT					((tU16) 0xC211)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AVB_ENTITY_ID						((tU16) 0xC212)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWITCH_ATU							((tU16) 0xC213)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DOIP_UDS_STACK_VERSIONS			((tU16) 0xC214)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AVB_GRANDMASTER_ID					((tU16) 0xC215)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CFG								((tU16) 0xC216)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_SW_VERSION					((tU16) 0xC217)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_UUID					    ((tU16) 0xC218)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_VIN_ORIGINAL						((tU16) 0xC220)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_VIN_CURRENT						((tU16) 0xC221)
//! Dynamic Data
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEVICE_TEMPERATURE					((tU16) 0xB011)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_TEMPERATURE_STATISTICS				((tU16) 0xB012)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SYSTEM_OPERATION_TIME				((tU16) 0xB101)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SYSTEM_UPDATE						((tU16) 0xB102)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_1		((tU16) 0xB120)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_2		((tU16) 0xB121)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_3		((tU16) 0xB122)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_4		((tU16) 0xB123)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_OABR_CONNECTION_STATUS_PORT_5		((tU16) 0xB124)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_SRK_FUSES               ((tU16) 0xB402)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_ENV_ENCRYPTED           ((tU16) 0xB403)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECURITYROOT_FS_VERIFIED           ((tU16) 0xB404)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECURITYDATA_IS_ENCRYPTED          ((tU16) 0xB405)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_UBOOT_SRK_HASH          ((tU16) 0xB409)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_DEVICETREE_SRK_HASH     ((tU16) 0xB40A)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECUREBOOT_IMXKERNEL_SRK_HASH      ((tU16) 0xB40B)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_POWER_SUPPLY_VOLTAGE				((tU16) 0xC230)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AVG_CPU_LOAD						((tU16) 0xC231)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MAX_RAM_CONSUMPTION				((tU16) 0xC232)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_STARTUP_TIME_STATISTIC				((tU16) 0xC233)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_LOUD_SPEAKER_STATUS				((tU16) 0xC240)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_STATUS					((tU16) 0xC241)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MICROPHONES_STATUS					((tU16) 0xC242)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_WAKEUP_LINES_STATUS				((tU16) 0xC243)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DIGITAL_OUTPUTS_STATUS				((tU16) 0xC244)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_CONNECTION_STATUS			((tU16) 0xC245)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_CON_STATUS_HANDHELDS		((tU16) 0xC246)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_CONVERSATION_COUNTER		((tU16) 0xC247)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ACTIVE_DIAGNOSTIC_SESSION			((tU16) 0xF186)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_USB_DEVICEINFO				((tU16) 0xC301)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_INPUTLINES_STATUS			((tU16) 0xC302)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_GNSS_RECEIVER_STATUS		((tU16) 0xC303)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_GNSS_ANTENNA_STATUS			((tU16) 0xC304)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MOBILE_NW_ANTENNA_STATUS	((tU16) 0xC306)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MOBILE_NW_FIELDSTRENGTH		((tU16) 0xC307)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MAC_ADDRESS_IMX6            ((tU16) 0xC312)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_CPU_ID                      ((tU16) 0xC313)

//! Stored Data
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEVICE_PLACE_OF_PRODUCTION			((tU16) 0xC260)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEVICE_PRODUCTION_TIME				((tU16) 0xC261)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CAM_RELAY_ACTIVATION				((tU16) 0xC262)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_AMP_SHUTDOWN_TIMEOUT				((tU16) 0xC263)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_THRESHOLDS				((tU16) 0xC264)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_RELEASETIME				((tU16) 0xC265)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_WAKEUP_ALIVE_CONFIGURATION			((tU16) 0xC266)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SWIVEL_CONFIGURATION			    ((tU16) 0xC267)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DISPLAY_SETTINGS			        ((tU16) 0xC268)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_OFFSET_GAIN			    ((tU16) 0xC269)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_IN_OFFSET_GAIN			    ((tU16) 0xC270)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MIC_OFFSET_GAIN			    	((tU16) 0xC271)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_OFFSET_GAIN_MIC			((tU16) 0xC272)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_OFFSET_GAIN_DIGITAL		((tU16) 0xC273)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_AVAILABLE		    		((tU16) 0xC274)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CABIN_OUT_MIXOFFSET_GAIN			((tU16) 0xC275)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_INTERCOM_PHONEBOX_VOLUME			((tU16) 0xC276)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CAMERA_USERNAME			    	((tU16) 0xC277)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_CAMERA_PASSWORD			    	((tU16) 0xC278)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_IP_MIC_OFFSET_GAIN_TO_ICOM_DIGITAL   ((tU16) 0xC279)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DISPLAY_TEST_SCREEN            ((tU16) 0xC280)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_PSK_ADMIN			    ((tU16) 0xC309)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WEB_PASSWORD_ADMIN			((tU16) 0xC30A)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_NODE_ID			    		((tU16) 0xC30B)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ROUTER_MODE			    		((tU16) 0xC30C)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_PSK_USER		    	((tU16) 0xC30D)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_BOOT_CONFIG                        ((tU16) 0xC30E)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_REVOKE_SRK_REG                     ((tU16) 0xC30F)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_MQTT_PASSWORD                      ((tU16) 0xC311)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SECURE_JTAG                        ((tU16) 0xC314)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_SSID_ADMIN            ((tU16) 0xC315)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_SSID_PASSENGER        ((tU16) 0xC316)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_MAC_2G                ((tU16) 0xC317)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DEFAULT_WIFI_MAC_5G                ((tU16) 0xC318)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_WRITE_KEY_FOR_SECURITY_ACCESS      ((tU16) 0xC645)

//! Routine Control
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_START_SW_UPDATE					((tU16) 0x3300)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_PREPARE_SW_UPDATE					((tU16) 0x3301)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_RELOAD_SUPPLIER_DELIVERYSTATE		((tU16) 0x3302)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_START_REMOTE_CONSOLE               ((tU16) 0xC691)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ENABLE_UART_CONSOLE                ((tU16) 0xC690)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DID_TC_ID_413_SECUREBOOT_ACTIVATOR ((tU16) 0xC633)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_DID_TC_ID_406_AVB_TEST             ((tU16) 0xC626)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_RCID_TC_ID_403_GPS                 ((tU16) 0xC622)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_USB_TEST                           ((tU16) 0xC624)

//! Security Access
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SAC_LVL_PGMNG_3_SEED				((tU16) 0x0003)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SAC_LVL_PGMNG_3_KEY				((tU16) 0x0004)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SAC_LVL_CFG_5_SEED					((tU16) 0x0005)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_SAC_LVL_CFG_5_KEY					((tU16) 0x0006)
//! Communication Control
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_COM_CTRL_ENABLE_TX					((tU16) 0x0000)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_COM_CTRL_DISABLE_TX				((tU16) 0x0001)
//! ECU Reset
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_ECU_HARD_RST						((tU16) 0x0001)
//! Control DTC Setting
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CTRL_DTC_SETTING_ACTIVATE			((tU16) 0x0001)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_CTRL_DTC_SETTING_SUPPRESS			((tU16) 0x0002)
//! Fault Memory
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_FM_CLEAR_DTC						((tU16) 0x0000)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_FM_READ_DTC_RPRT_NUM_BY_SM			((tU16) 0x0001)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_FM_READ_DTC_RPRT_DTC_BY_SM			((tU16) 0x0002)
#define DIA_C_U16_DID_SUBSYSTEM_DIAG_REQ_FM_READ_DTC_RPRT_DTC_SPRTD			((tU16) 0x000A)

enum dia_eIdentifyEntitiesRoutineStatus
{
   DIA_EN_IDENTIFY_ENTITIES_UNKNOWN = 0,
   DIA_EN_IDENTIFY_ENTITIES_RUNNING,
   DIA_EN_IDENTIFY_ENTITIES_NOK,
   DIA_EN_IDENTIFY_ENTITIES_OK,
   DIA_EN_IDENTIFY_ENTITIES_ABORTED,
   DIA_EN_IDENTIFY_ENTITIES_TIMED_OUT,
   DIA_EN_IDENTIFY_ENTITIES_COUNT
};

#endif /* __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__ */
