/*!
 * \file       dia_SubsystemDiagnosisStrategyCore.h
 *
 * \brief      Abstarct subsystem strategy used for subsystem diagnosis
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2), Kirty Mayank (RBEI/ECA2)
 *
 * \date       23.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY_CORE__
#define __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY_CORE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY__
#include <project/framework/cis/subsystem/dia_SubsystemDiagnosisStrategy.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEMDIAGNOSISFSM__
#include <project/framework/fsm/generated/dia_SubsystemDiagnosisFSM.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_DOIP_CLIENT__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisDoIPClient.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#include <project/framework/cis/subsystem/dia_defsSubsystemDiagnosis.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif


class SubsystemDiagnosisStrategyCore
	: public SubsystemDiagnosisStrategy,
	  protected dia_SubsystemDiagnosisFSM::FsmBehaviour,
	  protected dia_SubsystemDiagnosisDoIPClient::ICallback,
	  public dia_ITimerListener
{
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(SubsystemDiagnosisStrategyCore);

public:
	//! Class Constructor
	SubsystemDiagnosisStrategyCore ( std::string& name, tU32 Id);
	//! Class Constructor
	SubsystemDiagnosisStrategyCore ( char* name, tU32 Id);
	//! Class Destructor
	virtual ~SubsystemDiagnosisStrategyCore ( void );
	
	//! return the active strategy id
	virtual tU32 getID ( void ) { return mStrategyID; }
	
	//! process a subsystem session activation request
	virtual tDiaResult activateSubsystemSession ( void ) = 0;
	//! process a subsystem session deactivation request
	virtual tDiaResult deactivateSubsystemSession ( void ) = 0;
	//! process a request to discover entities
	virtual tDiaResult identyfyAllSubsystems ( void ) = 0;
	//! process a request to connect to subsystem
	virtual tDiaResult connectToSubsystem ( std::vector<tU8>& requestData ) = 0;
	//! process a route request
	virtual tDiaResult routeRequestToSubsystem ( std::vector<tU8>& requestData ) = 0;
	
	//! overloaded method from class dia_ITimerListener
    virtual void vOnTimerElapsed ( dia_TimerID id );
	
protected:
	//! depricated constructor
	SubsystemDiagnosisStrategyCore ( void );
	
	tDiaResult triggerDiscover ( void );
	tDiaResult triggerDiscoverRequestResult ( void );
	tDiaResult triggerSubNodeListReadRequest ( void );
	tDiaResult triggerConnect ( void );
	tDiaResult triggerRoute ( void );
	void triggerReset ( void );
	
	// FSM actions
	virtual void postprocessConnect ( void* /* pArg */ );
	virtual void postprocessIdentify ( void* /* pArg */ );
	virtual void postprocessRoute ( void* /* pArg */ );
	virtual void prepareDeactivate ( void* /* pArg */ );
	virtual void preprocessConnect ( void* /* pArg */ );
	virtual void preprocessIdentify ( void* /* pArg */ );
	virtual void preprocessRoute ( void* /* pArg */ );
	virtual void sendIdentifyResultNokResponse ( void* /* pArg */ );
	virtual void sendIdentifyResultOkResponse ( void* /* pArg */ );
	virtual void sendSubNodeListResponse ( void* /* pArg */ );
	virtual void sendIdentifyResultRunningResponse ( void* /* pArg */ );
	virtual void sendIdentifyStartNokResponse ( void* /* pArg */ );
	virtual void sendIdentifyStartRunningResponse ( void* /* pArg */ );
	virtual void sendSubsystemConnectNegResponse ( void* /* pArg */ );
	virtual void sendSubsystemConnectPosResponse ( void* /* pArg */ );
	virtual void sendSubsystemRoutingNegResponse ( void* /* pArg */ );
	virtual void sendSubsytemSessionNegResponse ( void* /* pArg */ );
	virtual void sendSubsytemSessionPosResponse ( void* /* pArg */ );
	virtual void validateConnectRequest ( void* /* pArg */ );
	virtual void validateIdentifyRequest ( void* /* pArg */ );
	virtual void validateRouteRequest ( void* /* pArg */ );
	virtual void validateRouteResponse ( void* /* pArg */ );
	virtual void vFsmActivateSubsystemSession ( void* /* pArg */ );
	virtual void vFsmCheckConnectPreconditions ( void* /* pArg */ );
	virtual void vfsmCloseCurrentConnectiontoNode ( void* /* pArg */ );
	virtual void vFsmCreateTCPSocketandConnect ( void* /* pArg */ );
	virtual void vFsmDeactivateSubsystemSession ( void* /* pArg */ );
	virtual void vFsmDeactivationFailed ( void* /* pArg */ );
	virtual void vFsmDisconnect ( void* /* pArg */ );
	virtual void vFsmDiscoverEntities ( void* /* pArg */ );
	virtual void vFsmOnPMRTimeout ( void* /* pArg */ );
    virtual void vFsmOnRATimeout ( void* /* pArg */ );
	virtual void vFsmOnRequestRoutingDone ( void* /* pArg */ );
	virtual void vFsmOnSessionDeactivated ( void* /* pArg */ );
	virtual void vFsmOnSubsystemWaitResponse ( void* /* pArg */ );
	virtual void vFsmReset ( void* /* pArg */ );
	virtual void vFsmRouteRcvdRequest ( void* /* pArg */ );
	virtual void vFsmRouteRcvdResponse ( void* /* pArg */ );
	virtual void vFsmSendReqSessionSwitch2Extended ( void* /* pArg */ );
	virtual void vFsmStartDEDelayTimer ( void* /* pArg */ );
	virtual void vFsmStartPMRDelayTimer ( void* /* pArg */ );
	virtual void vFsmStartRADelayTimer ( void* /* pArg */ );
	virtual void vFsmStartSubsystemRoutingDelayTimer ( void* /* pArg */ );
	virtual void vFsmStopDEDelayTimer ( void* /* pArg */ );
	virtual void vFsmStopPMRDelayTimer ( void* /* pArg */ );
	virtual void vFsmStopRADelayTimer ( void* /* pArg */ );
	virtual void vFsmStopSubsystemRoutingDelayTimer ( void* /* pArg */ );
	virtual void vFsmTriggerESR ( void* /* pArg */ );
	virtual void vFsmTriggerPMR ( void* /* pArg */ );
    virtual void vFsmTriggerRAR ( void* /* pArg */ );

   // FSM guards
   virtual bool areConnectConditionsOk ( void* /* pArg */ );
   virtual bool areIdentifyConditionsOk ( void* /* pArg */ );
   virtual bool areRouteConditionsOk ( void* /* pArg */ );
   virtual bool bIsActivationComplete ( void* /* pArg */ );
   virtual bool bIsDeactivationComplete ( void* /* pArg */ );
   virtual bool bIsEntityAlreadyConnected ( void* /* pArg */ );
   virtual bool bIsEntityListEmpty ( void* /* pArg */ );
   virtual bool bIsPowerModeOk ( void* /* pArg */ );
   virtual bool bIsPreCondChkOk ( void* /* pArg */ );
   virtual bool bIsRequestRouted ( void* /* pArg */ );
   virtual bool bIsRoutingActivationOk ( void* /* pArg */ );
   virtual bool bIsTCPSocketOk ( void* /* pArg */ );
   
   //! Callbacks of the DOIP Client
   virtual void onDiagnosticResponse (tU8 const * data, tU32 U32len) override;
   virtual void onTimeout (tU32 timerID) override;
   virtual void onRAResponse(tU8 respCode) override;
   virtual void onPMRResponse(tU8 pwrMode) override;
   
	
protected:
	//! pointer to the FSM Object used for Subsystem Diagnosis
    dia_SubsystemDiagnosisFSM::Fsm* mpFSM;
	
	//! pointer to the DoIP Client Object used for Subsystem Diagnosis
	dia_SubsystemDiagnosisDoIPClient* mpDoIPClient;
	
	//! 4 byte IP address of the Node requested by tester for connection
	tU32 mRequestedNodeAddr;
	
	//! error code
    tDiaResult mErrorCode;
	
    //! flag to indicate if the preconditions check for Connect was Ok.
	bool mAreConnectConditionsOk;  
	//! flag to indicate if the preconditions check for Identify was Ok.
	bool mAreIdentifyConditionsOk;
	//! flag to indicate if the preconditions check for Route was Ok.
	bool mAreRouteConditionsOk;
	//! flag to indicate if the subsystem session activation was complete.
	bool mIsActivationComplete;
	//! flag to indicate if the subsystem session deactivation was complete.
	bool mIsDeactivationComplete;
	//! Flag to indicate if the entity is already connected
	bool mIsEntityAlreadyConnected;
	//! Flag to indicate if the entity list is empty
	bool mIsEntityListEmpty;
	//! Flag to indicate if the PowerMode of the entity was Ok
	bool mIsPowerModeOk;
	//! Flag to indicate if the precondition check was ok before connecting to a subsystem.
	bool mIsPrecondChkOk;
	//! Flag to indicate if the request routed for the subsystem was ok.
	bool mIsRequestRouted;
	//! Flag to indicate if the Routing Activation for the subsystem was ok.
	bool mIsRoutingActivationOk;
	//! Flag to indicate if the TCP Socket creation was ok.
	bool mIsTCPSocketOk;

private:
	//! 
	dia_eIdentifyEntitiesRoutineStatus mIdentifyRoutineStatus;
	//! Timer Object for setting identify entities request results response
	dia_Timer oResponseTimer;
	//! Timer Id for Identify entities request results response
	tU32 mResponseTimerID;
	//! 
	void vStartResponseTimer( void );
	//!
	void vStopResponseTimer( void );

};


#endif /* __INCLUDED_SUBSYSTEM_DIAGNOSIS_STRATEGY_CORE__ */
