/*!
 * \file       dia_SubsystemDiagnosisRequestRouter.h
 *
 * \brief      router class (service handler) that routes the diagnostic commands from
 *             tester to the connected subsystem and routes the response from 
 *             connected subsystem back to the tester
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       17.10.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_REQUEST_ROUTER__
#define __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_REQUEST_ROUTER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif

class dia_SubsystemDiagnosisRequestRouter
	: public dia_ServiceHandlerUDS,
	  public dia_ISubsystemDiagnosisListenerImpl
{
	DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_SubsystemDiagnosisRequestRouter);
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SubsystemDiagnosisRequestRouter);
	
public:

	//! handle an incoming subsystem UDS request
	virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
	//! provide lookup keys
	virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );
	
protected:
	//! update from listener on response from subsystem
	virtual void vOnRouteRequestUpdate  ( std::vector<tU8>& responseData );
	
};	

#endif /* __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_REQUEST_ROUTER__ */
