/*!
 * \file       dia_SubsystemDiagnosisManagerPlugin.h
 *
 * \brief      Manager Plugin class that provides capabality to do pre & post process activities
 *			   for the subsystem identify, connect & routing functions
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2), Kirty Mayank (RBEI/ECA2)
 *
 * \date       19.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER_PLUGIN__
#define __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#include <project/framework/cis/subsystem/dia_defsSubsystemDiagnosis.h>
#endif

class dia_SubsystemDiagnosisManagerPlugin
{
public:
	virtual ~dia_SubsystemDiagnosisManagerPlugin ( void ) {}
	
	//! Methods to capture pre and post processing of various Diagnosis routines
	virtual tDiaResult preprocessIdentify ( void ) const;
	virtual tDiaResult preprocessConnect ( void ) const;
	virtual tDiaResult preprocessRoute ( void ) const;
	virtual tDiaResult postprocessIdentify ( void ) const;
	virtual tDiaResult postprocessConnect ( void ) const;
	virtual tDiaResult postprocessRoute ( void ) const;
	
	//! Methods to return different error codes for respective error scenarios
	virtual tDiaResult getErrCodeIEReqResListEmpty ( void ) const { return DIA_E_SUBSYSTEM_LIST_EMPTY; }
	virtual tDiaResult getErrCodeIEReqResListNotReady ( void ) const { return DIA_E_SUBSYSTEM_LIST_NOT_READY; }
	virtual tDiaResult getErrCodeConnectPrecondNok ( void ) const { return DIA_E_SUBSYSTEM_PRE_COND_CHK_NOK; }
	virtual tDiaResult getErrCodeConnectPMRNok ( void ) const { return DIA_E_SUBSYSTEM_PWR_MOD_REQ_NOK; }
	virtual tDiaResult getErrCodeConnectTCPNok ( void ) const { return DIA_E_SUBSYSTEM_TCP_SOCKET_NOK; }
	virtual tDiaResult getErrCodeConnectRANok ( void ) const { return DIA_E_SUBSYSTEM_RTNG_ACT_NOK; }
	virtual tDiaResult getErrCodeRoutingFailed ( void ) const { return DIA_E_SUBSYSTEM_RTNG_FAILED; }
	virtual tDiaResult getErrCodeSessionActivationFailed ( void ) const { return DIA_E_SUBSYSTEM_SESSION_ACT_FAILED; }
	
	virtual tDiaResult getResCodeIdentifyStartRunning ( void ) const { return DIA_E_SUBSYSTEM_IDENTIFY_ENTITIES_RUNNING; }
	virtual tDiaResult getResCodeIdentifyStartNok ( void ) const { return DIA_E_SUBSYSTEM_IDENTIFY_ENTITIES_NOK; }
	virtual tDiaResult getResCodeIdentifyResultRunning ( void ) const { return DIA_E_SUBSYSTEM_IDENTIFY_RESULT_RUNNING; }
	virtual tDiaResult getResCodeIdentifyResultOk ( void ) const { return DIA_E_SUBSYSTEM_IDENTIFY_RESULT_OK; }
};


#endif /* __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER_PLUGIN__ */
