/*!
 * \file       dia_SubsystemDiagnosisManager.h
 *
 * \brief      Manager class that controls subsystem diagnosis application 
 *			   (identifying, connectiong, routing requests/responses to/from subsystems)
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       19.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__
#define __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
#include "project/framework/factory/dia_factoryMethodsProject.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_STRATEGY__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisStrategy.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER_PLUGIN__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManagerPlugin.h"
#endif

class dia_SubsystemDiagnosisManager
	: public dia_ISubsystemDiagnosis
{
	DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_SubsystemDiagnosisManager);
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SubsystemDiagnosisManager);

public:
	//! add a new subsystem diagnosis strategy
	virtual tDiaResult addSubsystemDiagnosisStrategy ( SubsystemDiagnosisStrategy* strategy );
	//! remove the associated subsystem diagnosis strategy from the strategy repository
	virtual tDiaResult removeSubsystemDiagnosisStrategy ( tU32 id ); 
	//! return the number of managed subsystem diagnosis strategy
	virtual tU16 getNumberOfSubsystemDiagnosisStrategies ( void ) const;
	//! query for the designated strategy
	virtual tDiaResult querySubsystemDiagnosisStrategy ( tU32 id, SubsystemDiagnosisStrategy** ppStrategy );
	//! process a subsystem session activation request
	virtual tDiaResult activateSubsystemSession ( void );
	//! process a subsystem session deactivation request
	virtual tDiaResult deactivateSubsystemSession ( void );
	//! process a routine request to discover entities
	virtual tDiaResult identyfyAllSubsystems ( void );
    //! process a routine request to discover entities request result
	virtual tDiaResult identyfyAllSubsystemsRequestResult( void );
	//! process a read request to read subssytemnode list
	virtual tDiaResult readSubsystemNodeList( void );
	//! process a routine request to connect to subsystem
	virtual tDiaResult connectToSubsystem ( std::vector<tU8>& IP );
	//! process a route request
	virtual tDiaResult routeRequestToSubsystem ( std::vector<tU8>& diagRequest );
	
	virtual void setPlugin ( const dia_SubsystemDiagnosisManagerPlugin& plugin );

protected:
	//! protected class constructor
	dia_SubsystemDiagnosisManager ( void );
	//! protected class destructor
	virtual ~dia_SubsystemDiagnosisManager ( void );
	
	//! setup method for the application
	virtual tDiaResult setup ( void );
	//! shutdown method for the application
	virtual tDiaResult tearDown ( void ) const;

protected:
	//! repository of available subsystem strategies
	std::map<tU32,SubsystemDiagnosisStrategy*> mStrategyRep;
	//! Configuration object
	const dia_SubsystemDiagnosisManagerPlugin* mpPlugin;
	//! current active strategy
	SubsystemDiagnosisStrategy* mpActiveStrategy;
};

#endif /* __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__ */
