/*!
 * \file	   dia_SessionSubsystem.h
 *
 *
 * \brief      ...
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Kirty Mayank (RBEI/ECA2), Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       20.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SESSION_SUBSYSTEM__
#define __INCLUDED_DIA_SESSION_SUBSYSTEM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__
#include "project/interfaces/dia_ISubsystemDiagnosisListener.h"
#endif

class dia_EngineServer;

class dia_SessionSubsystem
   : public dia_Session,
     public dia_ISubsystemDiagnosisListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SessionSubsystem);

public:

   //! class constructor
   dia_SessionSubsystem ( tU8 sessionID, dia_EngineServer& engine );
   //! class destructor
   virtual ~dia_SessionSubsystem ( void );

   //! method that can be overloaded by subclasses to perform specific task when the session is entered
   virtual tDiaResult onEnterSession ( void );
   //! method that can be overloaded by subclasses to perform specific task when the session is left
   virtual tDiaResult onLeaveSession ( void );
   //! method that can be overloaded by subclasses to perform specific task when the session is deactivated/reset
   virtual tDiaResult onResetSession ( void );
   //! there was an update about the session request
   virtual void vOnSessionRequestUpdate (const tBool& state );


protected:
   //! deprecated class constructor
   dia_SessionSubsystem ( void );

protected:
   //! error information for an action is reported in the following variable
   tDiaResult mErrorCode;
};


#endif /* __INCLUDED_DIA_SESSION_SUBSYSTEM__ */
