/*!
 * \file       dia_SessionSubsystem.cpp
 *
 *
 * \brief      ...
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    subsystem diagnosis
 *
 * \author     Kirty Mayank (RBEI/ECA2), Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       20.09.2019
 *
 * \copyright  (c) 2019 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef __INCLUDED_DIA_SESSION_SUBSYSTEM__
#include "project/framework/cis/subsystem/dia_SessionSubsystem.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include "common/framework/engine/dia_LookupKey.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManager.h"
#endif

//-----------------------------------------------------------------------------

dia_SessionSubsystem::dia_SessionSubsystem ( tU8 sessionID, dia_EngineServer& engine )
   : dia_Session(sessionID,engine),
     mErrorCode(DIA_E_NOERROR)
{
   dia_tclFnctTrace oTrace("dia_SessionSubsystem::dia_SessionSubsystem ( tU8 sessionID, dia_EngineServer& engine )");
}

//-----------------------------------------------------------------------------

dia_SessionSubsystem::~dia_SessionSubsystem ( tVoid )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SessionSubsystem::onEnterSession ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_SessionSubsystem::onEnterSession()");

   mErrorCode = DIA_E_NOERROR;

    //! get the instance of subsystem manager 
	dia_SubsystemDiagnosisManager* pManager = getInstanceOfSubsystemDiagnosisManager();
	if( !pManager )
	{
		//! No manager available, impossible to process the request; send a -ve response.
		DIA_TR_ERR("dia_SessionSubsystem: FAILED (NO ACCESS TO SUBSYSTEM MANAGER) !!");
		return DIA_FAILED; 
	}
	else
	{
		//! Set the listener to get informed about the activation status later
		dia_ISubsystemDiagnosis* pSubsystem = nullptr;
		if ( querySysAdapterInterface<dia_ISubsystemDiagnosis>(&pSubsystem) == DIA_SUCCESS )
		{
			(void) setSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
		}
	}
	
	mErrorCode = pManager->activateSubsystemSession();
	if ( mErrorCode != DIA_SUCCESS )
	{
		//! Session activation failed.
		DIA_TR_ERR("dia_SessionSubsystem: Subsystem Session Activation FAILED !!");
		//! reset the listener
		unsetSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
		
		return DIA_FAILED;
	}

   return mErrorCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SessionSubsystem::onLeaveSession ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_SessionSubsystem::onLeaveSession()");

   mErrorCode = DIA_E_NOERROR;
   
    //! get the instance of subsystem manager 
	dia_SubsystemDiagnosisManager* pManager = getInstanceOfSubsystemDiagnosisManager();
	if( !pManager )
	{
		//! No manager available, impossible to process the request; send a -ve response.
		DIA_TR_ERR("dia_SessionSubsystem: FAILED (NO ACCESS TO SUBSYSTEM MANAGER) !!");
		return DIA_FAILED; 
	}
	else
	{
		//! Set the listener to get informed about the deactivation status later
		dia_ISubsystemDiagnosis* pSubsystem = nullptr;
		if ( querySysAdapterInterface<dia_ISubsystemDiagnosis>(&pSubsystem) == DIA_SUCCESS )
		{
			(void) setSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
		}
	}
	
	mErrorCode = pManager->deactivateSubsystemSession();
	if ( mErrorCode != DIA_SUCCESS )
	{
		//! Session deactivation failed.
		DIA_TR_ERR("dia_SessionSubsystem: Subsystem Session Activation FAILED !!");
		//! reset the listener
		unsetSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);
		
		return DIA_FAILED;
	}

	return mErrorCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SessionSubsystem::onResetSession ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_SessionSubsystem::onResetSession()");

   return DIA_E_NOERROR;
}

//-----------------------------------------------------------------------------

void
dia_SessionSubsystem:: vOnSessionRequestUpdate (const tBool& state)
{
	dia_tclFnctTrace oTrace("dia_SessionSubsystem::vOnSessionRequestUpdate()");
	
	mIsActive = state;
	
	(void) unsetSysAdapterListener<dia_ISubsystemDiagnosisListener>(this);

	dia_SessionController* pSessionMgr =  dia_Session::mpEngine->getSessionController();
	if ( pSessionMgr )
	{
	  pSessionMgr->vOnSessionUpdate(*this);
	}
}


