/*!
 * \file       dia_cfgSubsystemLogoInstallationDataDownload.h
 *
 * \brief      Configuration of Logo's used for subsystem logo installation
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       20.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD_CFG__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD_CFG__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_DATASET__
#include "common/framework/datadownload/dia_Dataset.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

dia_DatasetConfigLogo aDiaCISHMILogoInstallationCfg[] = 
{
	dia_DatasetConfigLogo
	(
		0,
		"CISHMILogo1",
		CIS_HMI_LOGO_START,
		CIS_HMI_LOGO_END,
		CIS_HMI_LOGO_LEN,
		UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH,
		DIA_PROP_CMC_CIS_HMI_LOGO_1
	),
	
	dia_DatasetConfigLogo
	(
		1,
		"CISHMILogo2",
		CIS_HMI_LOGO_START,
		CIS_HMI_LOGO_END,
		CIS_HMI_LOGO_LEN,
		UPDOWNLOADABLE_NO_CRC_CHECK|DIA_C_U16_DATASET_CFG_VARIABLE_LENGTH,
		DIA_PROP_CMC_CIS_HMI_LOGO_2
	)	
};

#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD_CFG__ */
