/*!
 * \file       dia_SubsystemLogoInstallationStrategyDefault.h
 *
 * \brief      default strategy used for subsystem logo installation
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       17.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY_DEFAULT__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY_DEFAULT__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY_CORE__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationStrategyCore.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif

class dia_SubsystemLogoInstallationStrategyDefault
	: public dia_SubsystemLogoInstallationStrategyCore,
	  public dia_ISessionListenerImpl
{
public:
	//! Class Constructor
	dia_SubsystemLogoInstallationStrategyDefault ( std::string& name );
	//! Class Destructor
	virtual ~dia_SubsystemLogoInstallationStrategyDefault ( void );
	
	//! 2nd level construction/destruction
	virtual tDiaResult setup ( void );
	virtual tDiaResult teardown ( void );
	
	//! process a subsystem logo installation request
	virtual tDiaResult startLogoInstallation ( void );
	//! process a subsystem logo installation status request
	virtual tDiaResult requestLogoInstallationResults ( void );
	
	//! called by the session control object to notify about a session change
	virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );
	
protected:
   //! depricated class constructor 
   dia_SubsystemLogoInstallationStrategyDefault ( void );

   //! register for session changes
   virtual tDiaResult registerSessionChange( void );
   //! unregister for session changes
   virtual tDiaResult unregisterSessionChange( void );
   //! validate the logo installation request
   virtual tDiaResult validateLogoInstallationRequest ( void );
   //! validate the logo installation request result
   virtual tDiaResult validateLogoInstallationRequestResult ( void );  

   virtual tDiaResult acceptEvent ( dia_CISStartupLogoInstallationFSM::FsmEvent event, void* pArg );
	
};

#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY_DEFAULT__ */
