/*!
 * \file       SubsystemLogoInstallationSecurityAccessDefault.h
 *
 * \brief      Defaault Security Access Algorithm used for subsystem logo installation
 *
 * \details    This class implements the AES-128 Security Algorithm
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       19.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS_DEFAULT__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS_DEFAULT__

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationSecurityAccess.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

class dia_SubsystemLogoInstallationSecurityAccessDefault
   : public SubsystemLogoInstallationSecurityAccess
{
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SubsystemLogoInstallationSecurityAccessDefault);
	
public:
    //! class constructor
    dia_SubsystemLogoInstallationSecurityAccessDefault( tU8 securitylevel, tU8 seedLength, tU8 keyLength );
	
	//! depricated class destructor
    virtual ~dia_SubsystemLogoInstallationSecurityAccessDefault( void );
	
	//! calculate key
	virtual tDiaResult calculateKey ( std::vector<tU8>& /* seed */, tU8* /* eid */, tU8* /* gid */);
	
	
	//! initialise 
	virtual void initialize( void );
	//! finalise
	virtual void finalize( void );
	
protected:
	
	virtual tDiaResult getStaticKeySecLvlDoIP( tU8* /* eid */, tU8* /* gid */);
	
	virtual tDiaResult vOnStaticKey( const std::vector<tU8>& /* _staticKey */, tU8* /*EID*/, tU8*/* GID*/);
	
private:

	std::vector<tU8> mSecuredSrvData;
	std::vector<tU8> mSessionKey;
	
	
};

#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS_DEFAULT__ */
