/*!
 * \file       dia_SubsystemLogoInstallationSecurityAccessDefault.h
 *
 * \brief      Default Security Access Algorithm used for subsystem logo installation
 *
 * \details    This class implements the AES-128 Security Algorithm
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       19.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS_DEFAULT__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationSecurityAccessDefault.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include "common/framework/security/dia_security.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __DIA_UNIT_TESTING__
#include "bpcl.h"
#endif
#include <openssl/conf.h>
#include <openssl/evp.h>
#include <openssl/err.h>
#include <openssl/rsa.h>

//-----------------------------------------------------------------------------

//! class constructor
dia_SubsystemLogoInstallationSecurityAccessDefault::dia_SubsystemLogoInstallationSecurityAccessDefault( tU8 securitylevel, tU8 seedLength, tU8 keyLength)
	: SubsystemLogoInstallationSecurityAccess( securitylevel, seedLength, keyLength )
{ 
	dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationSecurityAccessDefault::dia_SubsystemLogoInstallationSecurityAccessDefault()");
};

//-----------------------------------------------------------------------------
	
//! class destructor
dia_SubsystemLogoInstallationSecurityAccessDefault::~dia_SubsystemLogoInstallationSecurityAccessDefault( void ) 
{};
	
//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationSecurityAccessDefault::calculateKey(std::vector<tU8>&  seedIn, tU8* EID, tU8* GID )
{
	dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationSecurityAccessDefault::calculateKey(...)");
	
	tDiaResult retVal = DIA_FAILED;
	
	// Copying vector by copy function 
    //copy(seedIn.begin(), seedIn.end(), back_inserter(_seed));
	for (int i=0; i<seedIn.size(); i++)
	{		
        _seed.push_back(seedIn[i]);
	}
	
	/*
	if( DIA_SUCCESS == getStaticKeySecLvlDoIP())
	{
		keyOut.clear();
		keyOut.reserve(_key.size());
		
		for (int i = 0; i < _key.size(); i++) 
		{
			keyOut.push_back(_key[i]);
		}
		
		retVal = DIA_SUCCESS;
	}
	
	return retVal;
	*/
	return getStaticKeySecLvlDoIP(EID,GID);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationSecurityAccessDefault::getStaticKeySecLvlDoIP ( tU8* EID, tU8* GID)
{
	dia_tclFnctTrace oTrace("SubsystemLogoInstallationSecurityAccess::getStaticKeySecLvlDoIP( void )");
	
	static std::vector<tU8> _staticKey;
	
	_staticKey.clear();
	_staticKey.reserve(DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_DOIP_STATIC_KEY_LEN);
	
    _staticKey.push_back(0x58);
    _staticKey.push_back(0xD9);
    _staticKey.push_back(0xEB);
    _staticKey.push_back(0xAB);
    _staticKey.push_back(0xFD);
    _staticKey.push_back(0x1C);
    _staticKey.push_back(0xF1);
    _staticKey.push_back(0x14);
    _staticKey.push_back(0xA9);
    _staticKey.push_back(0x7C);
    _staticKey.push_back(0x38);
    _staticKey.push_back(0x04);
    _staticKey.push_back(0xB5);
    _staticKey.push_back(0x43);
    _staticKey.push_back(0x36);
    _staticKey.push_back(0xFB);
	
	return vOnStaticKey( _staticKey, EID, GID);
		
}

//-----------------------------------------------------------------------------
//tDiaResult
//dia_SubsystemLogoInstallationSecurityAccessDefault::vOnStaticKey ( const std::vector<tU8>& _staticKey )
//{
//	dia_tclFnctTrace oTrace("SubsystemLogoInstallationSecurityAccess::vOnStaticKey(...)");
//	
//	tDiaResult retVal = DIA_FAILED;
//	
//	//Clearing the vectors
//    mSecuredSrvData.clear();
//    mSessionKey.clear();
//	
//	if(DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_DOIP_SEED_LEN == _seed.size())
//	{
//		tU8 aSecuritySeed[DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_DOIP_SEED_LEN];
//		tU8* iv = 0;
//	
//		if (BPCL_OK == BPCL_AES_Encrypt(BPCL_AES_MODE_CBC, BPCL_AES_OP_ARGKEY, BPCL_AES_KEYSIZE_128,
//						(tU8*) _staticKey.data(), 0, iv, _seed.data(), aSecuritySeed, _seed.size()))
//
//		{
//			for (int i = 0; i < DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_DOIP_SEED_LEN; i++)
//			{
//				mSessionKey.push_back(aSecuritySeed[i]);
//				mSecuredSrvData.push_back(aSecuritySeed[i]);
//			}
//				
//			//Clearing the array
//			memset(aSecuritySeed,0,sizeof(aSecuritySeed));
//			
//			if (BPCL_OK == BPCL_AES_Encrypt(BPCL_AES_MODE_CBC, BPCL_AES_OP_ARGKEY, BPCL_AES_KEYSIZE_128,
//                            (tU8*) _staticKey.data(), 0, iv, mSecuredSrvData.data(), aSecuritySeed, mSecuredSrvData.size()))
//			{
//				for (int i = 0; i < DIA_C_SUBSYSTEM_SECURITY_ACCESS_LEVEL_DOIP_SEED_LEN; i++) 
//				{
//					mSessionKey.push_back(aSecuritySeed[i]);
//				}
//				
//				for (int i = 0; i < mSessionKey.size(); i++) 
//				{
//					_key.push_back(mSessionKey[i]);
//				}
//				
//				retVal = DIA_SUCCESS;
//				DIA_TR_INF("::calculateKey --> Done");
//			}
//			else
//			{
//				DIA_TR_ERR("::calculateKey --> BPCL_AES_Encrypt FAILED for Secured Data");
//			}		
//		}
//		else
//		{
//			DIA_TR_ERR("::calculateKey --> BPCL_AES_Encrypt FAILED for Seed");
//		}
//	}
//	else
//	{
//		DIA_TR_ERR("::calculateKey --> incorrect seed length=%d", _seed.size());
//	}
//	
//	return retVal;
//}

//-----------------------------------------------------------------------------

tDiaResult
dia_SubsystemLogoInstallationSecurityAccessDefault::vOnStaticKey ( const std::vector<tU8>& _staticKey , tU8* EID, tU8* GID)
{
	dia_tclFnctTrace oTrace("SubsystemLogoInstallationSecurityAccess::vOnStaticKey(...)");

	tDiaResult retVal = DIA_FAILED;


	tU8 cipher[128];
	tU8 au8InitialValue[16];
	tU8* iv = 0;
	int cipherlen = 0;

	   /* the 128 bit InitialValue consists of the EID and GID of this ECU and padded with 0x00 */
	   memset(au8InitialValue, 0, sizeof(au8InitialValue));
	  //poEthBus->poGetDoIPProtocoll()->vGetEIDGID(au8InitialValue+0, au8InitialValue+6);
    memcpy(au8InitialValue+0, EID, 6);
    memcpy(au8InitialValue+6, GID, 6);

	//DIA_TR_INF("vOnStaticKey :: au8InitialValue Data: %s", dia::utils::bin2str(au8InitialValue,' ').c_str());
	
	  EVP_CIPHER_CTX *ctx = EVP_CIPHER_CTX_new();

      EVP_EncryptInit_ex(ctx, EVP_aes_128_cbc(), NULL, (tU8*) _staticKey.data(), au8InitialValue);
	  /* Encrypt the Seed */
	  /*EVP_EncryptUpdate(ctx, ciphertext, &len, plaintext, plaintext_len)*/
	  EVP_EncryptUpdate(ctx, cipher+0, &cipherlen, _seed.data(),  _seed.size());

	  /* and once again as specified to come to 32 byte size */
	  EVP_EncryptUpdate(ctx, cipher+16, &cipherlen, cipher+0, 16);

	  EVP_EncryptFinal_ex(ctx, cipher+32, &cipherlen);

	  EVP_CIPHER_CTX_free(ctx);

	  for (int i = 0; i < 32; i++)
	  		{
		       _key.push_back(cipher[i]);
		       //DIA_TR_INF("dia_SubsystemLogoInstallationSecurityAccessDefault::vOnStaticKey[%d] 0x%02x", cipher[i]);
	  		}

     retVal = DIA_SUCCESS;

	return retVal;
}

//-----------------------------------------------------------------------------

void
dia_SubsystemLogoInstallationSecurityAccessDefault::initialize ( void )
{
	dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationSecurityAccessDefault::initialize(...)");
	
	SubsystemLogoInstallationSecurityAccess::initialize();
	
	mSecuredSrvData.clear();
    mSessionKey.clear();
	
}

//-----------------------------------------------------------------------------

void
dia_SubsystemLogoInstallationSecurityAccessDefault::finalize ( void )
{
	dia_tclFnctTrace oTrace("dia_SubsystemLogoInstallationSecurityAccessDefault::finalize(...)");
	
	SubsystemLogoInstallationSecurityAccess::finalize();
	
	mSecuredSrvData.clear();
    mSessionKey.clear();
}
