/*!
 * \file       dia_SubsystemLogoInstallationManagerPlugin.h
 *
 * \brief      Manager Plugin class that provides capabality to do pre & post
 *			   logo installation activities 
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       16.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER_PLUGIN__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

class dia_SubsystemLogoInstallationManagerPlugin
{
public:
	virtual ~dia_SubsystemLogoInstallationManagerPlugin ( void ) {}
	
	virtual tDiaResult getResCodeLogoInstallationInProgress ( void ) const { return DIA_E_SUBSYSTEM_LOGO_INSTALLATION_RUNNING; }
	
	virtual tDiaResult getErrCodeConditionsNotCorrect ( void ) const { return DIA_E_SUBSYSTEM_LOGO_INSTALLATION_INCORRECT_CONDITIONS; }
	
	virtual tDiaResult getErrCodeInstallationAborted ( void ) const { return DIA_E_SUBSYSTEM_LOGO_INSTALLATION_ABORTED; }
	
	virtual tDiaResult getErrCodeAlreadyRequested ( void ) const { return DIA_E_SUBSYSTEM_LOGO_ALREADY_REQUESTED; }
	
	virtual tDiaResult getErrCodeDoIPClientNotAvailable ( void ) const { return DIA_E_SUBSYSTEM_LOGO_INSTALLATION_DOIP_CLIENT_NOT_AVAILABLE; }
	
	virtual tDiaResult getErrCodeLogoInstallationCompletedNok ( void ) const { return DIA_E_SUBSYSTEM_LOGO_INSTALLATION_COMPLETED_NOK; }
	
	virtual tDiaResult getResCodeLogoInstallationCompletedOk ( void ) const { return DIA_E_SUBSYSTEM_LOGO_INSTALLATION_COMPLETED_OK; }
	
};


#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER_PLUGIN__ */
