/*!
 * \file       dia_SubsystemLogoInstallationManager.h
 *
 * \brief      Manager class that controls installation of the HMI Logo
 *             to all the connected subsystems ( Glasses only )
 *
 * \details    ...
 *
 * \component  Diagnostics
 *
 * \ingroup    cis subsystem hmi logo installation
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       13.03.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__
#define __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
#include "project/framework/factory/dia_factoryMethodsProject.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_DATASET__
#include <common/framework/datadownload/dia_Dataset.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_LOGO_INSTALLATION__
#include <project/framework/cis/logoinstallation/dia_defsSubsystemLogoInstallation.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER_PLUGIN__
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationManagerPlugin.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationSecurityAccess.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_SECURITY_ACCESS_DEFAULT__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationSecurityAccessDefault.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_STRATEGY__ 
#include "project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationStrategy.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_DATA_DOWNLOAD__
#include <project/framework/cis/logoinstallation/dia_SubsystemLogoInstallationDataDownload.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_LOGO_INSTALLATION_LISTENER__
#include "project/interfaces/dia_ISubsystemLogoInstallationListener.h"
#endif

class SubsystemLogoInstallationStrategy;

class dia_SubsystemLogoInstallationManager
	: public dia_ISubsystemLogoInstallation
{
	DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_SubsystemLogoInstallationManager);
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SubsystemLogoInstallationManager);

public:
    //! process a routine request to start logo installation
	virtual tDiaResult startLogoInstallation ( tU8 /* logoId */ );
    //! process a routine request to return the status of logo installation
	virtual tDiaResult requestLogoInstallationResults( void );
	//! replace existing plugin with a new one
	virtual void setPlugin ( const dia_SubsystemLogoInstallationManagerPlugin& plugin );
	//! replace existing strategy with a new one
	virtual void setStrategy (  SubsystemLogoInstallationStrategy& strategy );
	//! replace existing security algorithm with a new one
	virtual void setSecurityAlgorithm (  SubsystemLogoInstallationSecurityAccess& algorithm );
	//! retrieve the current security algorithm.
	virtual SubsystemLogoInstallationSecurityAccess* getSecurityAlgorithm() { return mpActiveSecurityAlgorithm; }
	//! Data Download Strategy 
	virtual dia_SubsystemLogoInstallationDataDownload* getDataDownloader() { return mpActiveDownloader; }
	//! Data Download Config Object
	virtual tDiaResult setDataDownloadItem(const dia_DatasetConfigLogo /* cfg */ );
	
	//! add a new data set
    virtual tDiaResult addDatasetCfg ( dia_DatasetConfigLogo* datasetcfg );
    //! remove a data set item from the data set repository
    virtual tDiaResult removeDatasetCfg ( tU8 startIdx );
    //! query for a data set via its start address
    virtual tDiaResult queryDatasetCfg ( tU8 startIndex, dia_DatasetConfigLogo** ppDatasetcfg );
    //! return the number of managed datasets
    virtual tU16 numberOfDataSetCfgs ( void ) const;
    
    //! load a set of properties
    virtual tDiaResult loadDatasetCfgs ( dia_DatasetConfigLogo data[], tU16 numOfItems );

protected:
	//! protected class constructor
	dia_SubsystemLogoInstallationManager ( void );
	//! protected class destructor
	virtual ~dia_SubsystemLogoInstallationManager ( void );
	
	//! setup method for the application
	virtual tDiaResult setup ( void );
	//! shutdown method for the application
	virtual tDiaResult tearDown ( void ) const;
	//! clear the content of all repositories
    virtual void destroy ( void );
	
private:
	//! repository of available dataset cfg
    std::map<tU8, dia_DatasetConfigLogo* > mDatasetcfgRep;
	//! Configuration object
	const dia_SubsystemLogoInstallationManagerPlugin* mpPlugin;
    //! current active strategy
	SubsystemLogoInstallationStrategy* mpActiveStrategy;
	//! current security algorithm 
	SubsystemLogoInstallationSecurityAccess* mpActiveSecurityAlgorithm;
	//! current data downloader
	dia_SubsystemLogoInstallationDataDownload* mpActiveDownloader;
	//! Current Selected Logo
	tU8 mCurrentLogoId;

};

#endif /* __INCLUDED_DIA_SUBSYSTEM_LOGO_INSTALLATION_MANAGER__ */
