/*
 * dia_FactoryProjectPlugin.h
 *
 *  Created on: 26.03.2011
 *      Author: gib2hi
 */

#ifndef DIA_FACTORYPROJECTPLUGIN_H_
#define DIA_FACTORYPROJECTPLUGIN_H_

#ifndef __INCLUDED_DIA_COMMON_ENGINE__
#include "common/framework/engine/dia_common_engine.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include "common/framework/factory/dia_FactoryPlugin.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DRIVER__
#include "common/framework/platform/dia_IDriver.h"
#endif

class dia_EngineServer;
class dia_FactoryPlugin;
class dia_IDriver;

class dia_FactoryProjectPlugin
   : public dia_Factory
{
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_FactoryProjectPlugin);

public:
    //! default class constructor
    dia_FactoryProjectPlugin ( void );
    //! class destructor
    virtual ~dia_FactoryProjectPlugin ( void );

    //! setup (create objects,...)
    virtual tDiaResult setup ( dia_enInitLevel level );
    //! tear down (destroy objects,...)
    virtual tDiaResult shutdown ( dia_enInitLevel level );

#ifdef __STARTUP_REFACTORING_ENABLE__
    virtual dia::Bundle* makeBundle ( const std::string& bundleName );
#endif
    //! create threads used for processing messages
    virtual tDiaResult makeActiveObjects ( dia_Application& app );
    //! create the client handler instances
    virtual tDiaResult makeSystemAdapters ( void );

    //! create a project specific session object for the given session ID
    virtual dia_Session* makeSession ( tU8 sessionID, dia_EngineServer& rEngine );

    // create lookup table for customer and production diagnosis services and their access information
    virtual tDiaResult makeServiceHandlers ( enDiaType type );

    virtual dia_IDriver* makeDriver ( dia_enDriverType driverID );
    //!
    virtual dia_ITimer*  makeTimer ( void );

protected:
    //! list of engine configuration objects
    std::list<dia_IDriver*> mDriverRep;
};

#endif /*dia_tclFactoryPlugin_H_*/
