/*
 * dia_FactoryProjectPlugin.cpp
 *
 *  Created on: 26.03.2011
 *      Author: gib2hi
 * --------------------------------------------------------
 * Date 	       | Author	          | Modification
 * 9.12.15         | nce5kor          | Added objects for BT_device List SH with handling for duplicate DID configurations
 * 08.01.2016	   | bsu9kor		  | Added object for Device production Time Read and Write Service. (AIVI-17184)
 * 12.01.2016	   | bma9kor		  | Enabled read External input status for ACC (AIVI 17190)
 * 12.01.2016	   | bma9kor		  | Enabled read External input status for Reverse Gear (AIVI 17190)
 * 15.01.2016	   | nce5kor          | Added objects for BT and WIFI Address with handling for duplicate DID configurations (NCG3D-6407)
 * 25.01.2016	   | gpu2kor          | Added objects for SCC_ApplicationSoftwareVersionLabel, SCC_BootloaderSoftwareVersionLabel, SCC_BootManagerSoftwareVersionLabel
 * 28.1.16         | bma9kor          | Enabled Illumination and Ignition feature for External Input status read
 * 15.02.2016	   | bsu9kor		  | Added Array to support Initial Programming Log Feature in 0x01 and 0x03 sessions(NCG3D-9842).
 * 09.13.2016	   | bma9kor          | Added SH for ADR Amplification Configuration read (NCG3D-10968)
 * 21.13.2016	   | bma9kor          | Enabled read for SDCard1SlotState(AIVI-20999)
 * 10.03.2016		 bsu9kor		  | Temperature ID for Display changed (NCG3D-5303).
 * 16.06.2016	   | dvd5kor		  | AIVI-23605 - Enabled Read and Write for RadioTypeApprovalMode
 * 01.07.2016	   | bma9kor		  | Added SH for Alliance Calibration/ Xtra Data read (AIVI-24904)
 * 05.07.2016  		 bsu9kor	  		Enabled read for External Input status for Parking Brake ( AIVI-24903).
 * 07.09.2016      | dvd5kor          | Added read for ECU Temperature 26189
 * 07.09.2016  		 bsu9kor	  		Enabled read for radio state ( AIVI-26190).
 * 09.08.2016 	   | bma9kor		  | Enabled read for GPS Reception Level ( AIVI-26188)
 * 10.26.2016      | ogm5kor          | Added SH for Degraded Mode Counter read (AIVI-26132)
 * 10.26.2016      | ogm5kor          | Added SH for Degraded Mode Cumulated Duration read (AIVI-26132)
 * 11.02.2016	   | ogm5kor          | Added SH for Time From Engine Stopped read (AIVI-26134)
 * 11.25.2016	   | ogm5kor          | Added SH for Vehicle Identifier First Value read (AIVI-37555)
 * 12.14.2016      | mky6kor          |Enabled read for Vehicle Manufacturer Hardware Number(AIVI-24508)
 * 01.30.2017      | mky6kor          |Enabled read for Number of CD Inserted(AIVI-38637)
 * 04.12.2017	   | bma9kor		  | Enabled read and write to KDS for configRecords for SmartPhone Integration (AIVI-49829)
 * 08.05.2017      |mky6kor           | Enabled read and write to KDS for configRecords for TouchDriver2 (AIVI-53850)
 * 08.22.2018      |hme4kor           | Added SH for Read- SoftwareSupplierInfo & HardwareSupplierInfo  (CenterCMC19 RTC-302486)
 * 08.27.2018      |ama8kor           | Added SH for Read- Boot Software Version & Customer Software Version Read Service for CENTER_CMC_19. (RTC-302484)
 * 08.28.2018      |ama8kor           | Changed class name in SH instantiation for Read- Boot Software Version & Customer Software Version Read Service. (RTC-302484)
 * 08.28.2018      |nik6kor           | Enabled and mapped PD to CD read System supplier HW and SW part and version number (CenterCMC19 RTC- 302487)
 * 10.24.2018      |hme4kor           | Rework - Device configuration (CenterCMC19 RTC- 350444)
 * 10.22.2018	   |ama8kor           |Added SH for Read-- Hardware Version Information, customerECUHWVersion for CENTER_CMC_19. (RTC-359909)
 * 10.22.2018      |ama8kor           |Added SH for Write- customerECUHWVersion for CENTER_CMC_19. (RTC-359909)
 * 10.23.2018      |mky6kor    		  |Enabled read for Basic Identification ECU Serial Number  (CenterCMC19 RTC-359900)
 * 11.15.2018  	   |mky6kor    		  |Enabled read for Basic Identification Hardware Part Number  (CenterCMC19 RTC-407869)
 * 11.15.2018  	   |mky6kor    		  |Enabled read and write Customer Spare Part Number  (CenterCMC19 RTC-407869)
 * 11.23.2018  	   |urm7kor    		  |Added SH for Read/Write--VINOdometer for CENTER_CMC_19. (RTC-308949)
 * 11.23.2018  	   |urm7kor    		  |Added SH for Read/Write--VINOdometer Limit for CENTER_CMC_19. (RTC-308949)
 * 11.23.2018  	   |urm7kor    		  |Added SH for Read/Write--VINCurrent for CENTER_CMC_19. (RTC-308949)
 * 11.23.2018  	   |urm7kor    		  |Added SH for Read--VINOriginal for CENTER_CMC_19. (RTC-308949)
 * 11.30.2018  	   |mky6kor    		  |Added SH for Reading Active Diagnostic Information  (CenterCMC19 RTC-425829)
 * 01.31.2019      |hgr6kor			  |Added SH for read Compatibility List (CenterCMC19 RTC-433641)
 * 01.24.2019  	   |urm7kor    		  |Added SH for Read/Write Configuration Fingerprint  (CenterCMC19 RTC-451284)
 * 02.27.2019      |urm7kor           |Added SH for Read Fieldstrength of AM/FM Tuner (CenterCMC19 RTC-433650)
 * 02.27.2019      |urm7kor           |Added SH for Read Fieldstrength of FM Tuner2 (CenterCMC19 RTC-433652)
 * 02.27.2019      |urm7kor           |Added SH for Read Fieldstrength of DAB Tuner (CenterCMC19 RTC-433653)
 * 02.27.2019      |urm7kor           |Added SH for Read Fieldstrength of SXM Tuner (CenterCMC19 RTC-433659)
 * 02.27.2019      |urm7kor           |Added SH for Read Fieldstrength of Weatherband Tuner (CenterCMC19 RTC-433657)
 * 03.14.2019      |ama8kor           |Added SH for VIN Current Write, VIN Odometer Write & VIN Odometer Limit Write (CenterCMC19 RTC-464271)
 * 03.27.2019      |hgr6kor			  |Added SH for Read operation time  (CenterCMC19 RTC-470424)
 * 04.01.2019      |mky6kor			  |Added SH for Read Temperature Statistics  (CenterCMC19 RTC-466144)
 * 04.09.2019      |ama8kor			  |Added SH for read Mercedes Truck Software Part Number [F126]  (CenterCMC19 RTC-483418)
 * 04.09.2019      |hgr6kor           |Configured service read and write PNM Group 10 Configuration (CenterCMC19 RTC-481484)
 * 04.24.2019      |hgr6kor           |Configured service read Historical Interrogation Record (CenterCMC19 RTC-413744)
 * 06.19.2019      |mky6kor           |Enabled Read Service for Tester Identification (CenterCMC19 RTC-526465)
 * 01.07.2019      |urm7kor           |Added Routine Control service handler for execution of CM-C installation container (CenterCMC19 RTC-460577)
 * 01.07.2019      |urm7kor           |Added Routine Control service handler for copying Installation Log File to USB (CenterCMC19 RTC-483402)
 * 08.07.2019      |urm7kor           |Added SH for Read connection status of the Amplifier CM-A 19   (CenterCMC19 RTC-503601)
 * 03.31.2020      |urm7kor           |Added SH for Read Fieldstrength of HD Tuner(CenterCMC19 RTC-728676)
 * 09.08.2021      |aoo2kor           |Added SH for Read AudioFilesCounter(CenterCMC19 [SYSFL-5057][RTC1-559523])
 * 09.08.2021      |aoo2kor           |Added SH for Read VideoFilesCounter(CenterCMC19 [SYSFL-5056][RTC1-503558])
 * --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
 */

#if 0 //STC2HI: TODO
#include "project/patches/dia_patches.h"
#endif //STC2HI: TODO

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_FACTORY__
#include <common/framework/factory/dia_common_factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_CORE__
#include <common/framework/factory/dia_FactoryPluginCore.h>
#endif

#ifndef __DIA_UNIT_TESTING__
#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include <common/framework/sysset/dia_common_sysset.h>
#endif
#endif

#include <project/framework/application/dia_FactoryProjectPlugin.h>

#ifndef __INCLUDED_FACTORY_PLUGIN_PRODUCTION_SERVICES__
#include "project/framework/factory/dia_FactoryPluginProductionServices.h"
#endif

#ifndef __DIA_UNIT_TESTING__
#ifndef __INCLUDED_DIA_SERVICE__
#include "common/depricated/dia_tclService.h"
#endif
#endif

#ifndef DIA_PROJECT_SERVICES_PRODUCTION_H_
#include "project/services/production/dia_project_services_production.h"
#endif

#ifndef __INCLUDED_DIA_SESSION_SUBSYSTEM__
#include "project/framework/cis/subsystem/dia_SessionSubsystem.h"
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_REQUEST_ROUTER__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisRequestRouter.h"
#endif

#if 0 //STC2HI: TODO

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif
#include "project/framework/config/dia_defsProjectConfig.h"

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_HANDLER__
#include "common/framework/sysset/dia_tclSysSetHandler.h"
#endif

#include "common/interfaces/dia_IHMIAudioSourceListener.h"

#ifndef __INCLUDED_DIA_INTERFACE_HMILANGUAGE_LISTENER__
#include "common/interfaces/dia_IHMILanguageListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_CCA__
#include "common/depricated/SystemAdapter/dia_ISystemCCA.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#include "common/framework/sysadapters/dia_SAFeatureCodingUpdate.h"
#endif

#endif //STC2HI: TODO

#ifndef __INCLUDED_DIA_COMMCHANNEL_INC__
#include <common/framework/udd/dia_CommChannelINC.h>
#endif

#if 0 //STC2HI: TODO
#include "common/interfaces/dia_INavigationListener.h"
#endif //STC2HI: TODO

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_CCA__
#include <project/framework/sysadapters/dia_SAFeatureCCA.h>
#endif

#if 0 //STC2HI: TODO

#include "common/depricated/SystemAdapter/dia_ISystemAdapterPlugin.h"
#include "common/depricated/SystemAdapter/dia_PluginSysSet.h"

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "common/framework/sysadapters/dia_SAFeatureDefaultSettingsCompatible.h"
#endif

#endif //STC2HI: TODO

#ifndef __DIA_UNIT_TESTING__
#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "common/framework/sysadapters/dia_SAFeatureRemoteControl.h"
#endif
#endif

// UUD driver framework
#ifndef __INCLUDED_DIA_COMMON_UDD__
#include <common/framework/udd/dia_common_udd.h>
#endif

#include <common/services/uds/generic/dia_common_uds_generic_services.h>

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_GENERIC_PRINT2DIAGNOSIS_TRACE_H_
#include <common/services/uds/generic/dia_SrvHandlerGenericPrint2DiagnosisTrace.h>
#endif

#ifndef __DIA_UNIT_TESTING__
#ifndef __INCLUDED_DIA_COMMON_SERVICES_UDS_PRODUCTION__
#include <common/services/uds/production/dia_common_services_uds_production.h>
#endif
#endif

#include "project/services/customer/dia_services_customer.h"

#ifndef __INCLUDED_PROJECT_FACTORY__
#include <project/framework/factory/dia_project_factory.h>
#endif

#ifndef __INCLUDED_DIA_OSAL_DRIVER_TRACE__
#include <common/framework/platform/osal/dia_OSALDriverTrace.h>
#endif

#ifndef __INCLUDED_DIA_OSAL_DRIVER__
#include <common/framework/platform/osal/dia_OSALDriver.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_SECURITY__
#include "common/framework/security/dia_common_security.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_ECURESETS_BY_RESET_TYPE__
#include "common/services/uds/generic/dia_SrvHandlerGenericECUResetsByResetType.h"
#endif

#ifndef __INCLUDED_FACTORY_PLUGIN_ECURESET__
#include "project/framework/factory/dia_FactoryPluginEcuResets.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_MULTIPLE_READ_DATA_BY_ID_HANDLER__
#include <common/framework/protocols/uds/dia_MultipleReadDataByIDHandler.h>
#endif

#ifndef __DIA_GENERICCONFIGLONGITEMDIDREAD_H__
#include "project/services/customer/dia_GenericConfigLongItemDidRead.h"
#endif

#ifndef __DIA_GENERICCONFIGLONGITEMDIDWRITE_H__
#include "project/services/customer/dia_GenericConfigLongItemDidWrite.h"
#endif

#ifndef DIA_SRV_HANDLER_CONFIGURATION_PART_NUMBER_H_
#include "project/services/customer/dia_SrvHandler_ConfigurationPartNumber.h"
#endif

#ifndef DIA_SRVHANDLER_ECUSERIALNUMBERDATAIDENTIFIER_H_
#include "project/services/customer/dia_SrvHandler_ECUSerialNumberDataIdentifier.h"
#endif

#ifndef __DIA_SRVHANDLER_READHWSWVERSION_H__
#include "project/services/customer/dia_SrvHandler_ReadHWSWVersion.h"
#endif

#ifndef __DIA_SRVHANDLER_READOVERALLCISSWVERSION_H__
#include "project/services/customer/dia_SrvHandler_ReadOverallCISSWVersion.h"
#endif
#ifndef __INCLUDED_DIA_GENERIC_CONFIGITEM_VAR_LENGTH_READ__
#include "project/services/customer/dia_GenericConfigItemVarLengthRead.h"
#endif

#ifndef DIA_SRVHANDLER_GENERIC_SESSIONCONTROL_AIVI_H_
#include "project/services/customer/dia_SrvHandlerGenericSessionControlAIVI.h"
#endif

#ifndef DIA_SRV_HANDLER_GENERIC_READ_FAULT_MEMORY_CMC_H_
#include "project/services/customer/dia_SrvHandlerGenericReadFaultMemoryCMC.h"
#endif

#ifndef DIA_SRV_HANDLER_VDIAG_H_
#include "project/services/customer/dia_SrvHandler_VDiag.h"
#endif

#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_AUDIO_FILE_COUNTER__
#include "project/services/customer/dia_SrvHandlerAudioFileCounter.h"
#endif

#ifndef __INCLUDED_DIA_SRV_HANDLER_RDID_VIDEO_FILE_COUNTER__
#include "project/services/customer/dia_SrvHandlerVideoFileCounter.h"
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include <vd_diaglog_if.h>

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
#ifndef __INCLUDED_FACTORY_PLUGIN_VEHICLE_SETTINGS__
#include "project/framework/factory/dia_FactoryPluginVehicleSettings.h"
#endif
#endif

#ifdef __STARTUP_REFACTORING_ENABLE__
#ifndef __INCLUDED_DIA_BUNDLE_CONTAINER_APPLICATION__
#include <common/framework/application/dia_BundleApplication.h>
#endif
#ifndef __INCLUDED_DIA_BUNDLE_CONFIGURATION_APPLICATION__
#include <common/framework/application/dia_BundleConfigurationApplication.h>
#endif
#endif
using namespace dia;

using namespace std;

//------------------------------------------------------------------------------

dia_Factory*
dia_Factory::getInstance( void )
{
    if ( !mpInstance )
    {
        mpInstance = OSAL_NEW dia_FactoryProjectPlugin();
    }
    return mpInstance;
}

//------------------------------------------------------------------------------

dia_FactoryProjectPlugin::dia_FactoryProjectPlugin ( void )
{
   dia_tclFnctTrace oTrace(DIA_TRC_SM,"dia_FactoryProjectPlugin::dia_FactoryProjectPlugin");
}

//------------------------------------------------------------------------------

dia_FactoryProjectPlugin::~dia_FactoryProjectPlugin ( void )
{
}

//------------------------------------------------------------------------------

tDiaResult
dia_FactoryProjectPlugin::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace trc(DIA_TRC_SM,"dia_FactoryProjectPlugin::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_0 || level == DIA_EN_INITLEVEL_ALL )
   {
      if ( mSubFactoryRep.empty() )
      {
         // initially create the subfactory objects
         addFactoryPlugin(dia_FactoryPluginCore::getInstance());
         addFactoryPlugin(dia_FactoryPluginCoreProject::getInstance());
         addFactoryPlugin(dia_FactoryPluginDataDownload::getInstance());
         addFactoryPlugin(dia_FactoryPluginEcuResets::getInstance());
         addFactoryPlugin(dia_FactoryPluginIOControls::getInstance());
         addFactoryPlugin(dia_FactoryPluginRoutineControls::getInstance());
         addFactoryPlugin(dia_FactoryPluginExtensions::getInstance());
         addFactoryPlugin(dia_FactoryPluginSystemAdapters::getInstance());
         addFactoryPlugin(dia_FactoryPluginSystemSettings::getInstance());
         addFactoryPlugin(dia_FactoryPluginSecurity::getInstance());
         addFactoryPlugin(dia_FactoryPluginTests::getInstance());
         addFactoryPlugin(dia_FactoryPluginUdd::getInstance());
         addFactoryPlugin(dia_FactoryPluginTrace::getInstance());
	     addFactoryPlugin(FactoryPluginFieldLoadData::getInstance());
	     addFactoryPlugin(dia_FactoryPluginSubsystemDiagnosis::getInstance());
	     addFactoryPlugin(dia_FactoryPluginSubsystemLogoInstallation::getInstance());


#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
         addFactoryPlugin(dia_FactoryPluginProductionServices::getInstance());
#endif

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
         addFactoryPlugin(dia_FactoryPluginVehicleSettings::getInstance());
#endif
      }
   }

   tDiaResult retCode = setupFactoryPlugins(level);

   if ( retCode == DIA_SUCCESS )
   {
      setInitializationLevel(level);
      DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_FactoryProjectPlugin::shutdown ( dia_enInitLevel level )
{
   dia_tclFnctTrace trc("dia_FactoryProjectPlugin::shutdown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level != getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED TO SHUT DOWN WRONG LEVEL (ACTLEV=%d, REQLEV=%d) #####",getInitializationLevel(),level);
      return DIA_SUCCESS;
   }

   if(mpInstance)
   {
      mpInstance->clearNRCmappings();
   }

   tDiaResult retCode = teardownFactoryPlugins(level);

   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_IDriver,mDriverRep)
   #ifdef __STARTUP_REFACTORING_ENABLE__
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(Bundle,mBundleRepo)
   #endif


   if ( retCode == DIA_SUCCESS )
   {
      if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
      {
         setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
         DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
      }
   }
   return retCode;
}

#ifdef __STARTUP_REFACTORING_ENABLE__
Bundle*
dia_FactoryProjectPlugin::makeBundle(const std::string& bundleName)
{
   DIA_TR_INF( "dia_FactoryProjectPlugin::makeBundle" );
   LockScope mScopeLock(mSyncObj);
   Bundle* pBundle = 0;
   if (bundleName == "DIA_MAIN_APPLICATION")
   {
      BundleConfiguration* pBundleConfig = new BundleConfigurationApplication;
      if (pBundleConfig)
      {
         pBundle = new dia::BundleApplication(*pBundleConfig);
         if(pBundle!=0)
         {
            mBundleRepo.push_back(pBundle);
         }
      }
   }
   else
   {
      DIA_TR_ERR("NO BUNDLE CONFIGURATION FOUND WITH NAME \"%s\"", bundleName.c_str());
   }
   return pBundle;
}
#endif
//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryProjectPlugin::makeActiveObjects ( dia_Application& /*app*/ )
{
//   dia_MessageProcessor* pMsgProc = OSAL_NEW dia_MessageProcessor("DIA_WORKER");
//   if ( !pMsgProc )
//   {
//      return DIA_FAILED;
//   }
//
//   app.addMessageProcessor(enMsgProcID_WorkerCCA,*pMsgProc);
//   app.addMessageProcessor(enMsgProcID_WorkerUDS,*pMsgProc);

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------
// Custodial pointers will be deleted on shutdown of system. -> bDeleteClientHandlers
//lint -e429

tDiaResult
dia_FactoryProjectPlugin::makeSystemAdapters ( void )
{
   dia_tclFnctTrace oTrace("dia_tclFactoryPlugin::makeSystemAdapters");

   // create and assign interface for CCA plugin (must be first interface mapped to an implementation)
   dia_ISystemCCA* pCCA = dia_SAFeatureCCA::getInstance();
   assignInterfaceImplementation<dia_ISystemCCA>(pCCA);

   // *******************************************************************************
   // Create plugins and configure supported SysSet Types
   // *******************************************************************************


#if 0 //STC2HI: TODO
   (void) assignInterfaceAndNotifier<dia_IDisplayTest,dia_IDisplayTestListener,dia_IDisplayTestNotifier>(diagnostics_tclApp::getInstance()->poCcaService);
   (void) assignInterfaceAndNotifier<dia_INavigation,dia_INavigationListener,dia_INavigationNotifier>(diagnostics_tclApp::getInstance()->poCcaService);
   (void) assignInterfaceAndNotifier<dia_IHMIAudioSource,dia_IHMIAudioSourceListener,dia_IHMIAudioSourceNotifier>(diagnostics_tclApp::getInstance()->poCcaService);
   (void) assignInterfaceAndNotifier<dia_IHMILanguage,dia_IHMILanguageListener,dia_IHMILanguageNotifier>(diagnostics_tclApp::getInstance()->poCcaService);
   (void) assignInterfaceAndNotifier<dia_ITouchPanel,dia_ITouchPanelListener,dia_ITouchPanelNotifier>(diagnostics_tclApp::getInstance()->poCcaService);
   // + Entry in File framework/dia_tclService.h

#endif //STC2HI: TODO

   return DIA_SUCCESS;
}
//lint +e429

//------------------------------------------------------------------------------

/*lint -save -e750 */
/* gib2hi: macro 'macro_name' not referenced, but we are defining utility macros in this file to be used now or in future */
#define ADD_NEW_SRVHDL(className) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className());

#define ADD_NEW_SRVHDL_NAME_SID_SUBID(className,name,sid,subid) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU8) subid));

#define ADD_NEW_SRVHDL_DID(className,did) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className((tU8) did));

#define ADD_NEW_SRVHDL_01_PARAM(className,para) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(para));

#define ADD_NEW_SRVHDL_NAME_SID_ARGLIST(className,name,sid,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(className,name,sid,did,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU16) did), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(className,name,sid,did,propID) \
      {                                                     \
         static const intptr_t args[] = {(intptr_t) propID};              \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU16) did, (tU32) propID), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(className,name,sid,did,para,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU16) did, para), (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
      }

#define ADD_SRVHDL_FOR_SPECIFIC_SESSION(obj,sessionVec) \
      (void) pEngineCustomer->bAddServiceHandler(obj, (tU16) (sizeof(sessionVec)/sizeof(tU8)), (tU8*) sessionVec); \

#define ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(className,name,sid,did,propID,supportMask) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU8) did, propID, supportMask));

#define ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_THREE_PARAM_ARGLIST(className,name,sid,did,propID,supportMask,testCondition,...) \
      {                                                     \
         static const tArgsType args[] = __VA_ARGS__ ;           \
         (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU8) did, propID, supportMask, testCondition), (tU16) (sizeof(args)/sizeof(tArgsType)), (tArgsType*) args); \
      }

#define ADD_SRVHDL_NISSAN_02(className,name,sid,did,supportMask) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(name, sid, (tU8) did, supportMask));

#define ADD_SRVHDL_NISSAN_03(className,sid,did,propID,supportMask) \
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW className(sid, (tU8) did, propID, supportMask));

#define ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(obj,sessionVec,...) \
      {                                                     \
         static const intptr_t args[] = __VA_ARGS__ ;           \
		 (void) pEngineCustomer->bAddServiceHandler(obj, (tU16) (sizeof(sessionVec)/sizeof(tU8)), (tU8*) sessionVec, (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args); \
	  }

/*lint -save -e429 Lifetime of service handler is controlled by framework */
tDiaResult
dia_FactoryProjectPlugin::makeServiceHandlers ( enDiaType /*type*/ )
{
   dia_tclFnctTrace oTrace("dia_FactoryProjectPlugin::makeServiceHandlers()");

   static tU8 arSessionsProdADR[]  = { 0x61 };
   static tU8 arSessionsProd[]     = { 0x60 };
   static tU8 arSessionsCust[]     = { 0x03 };
   static tU8 arSessionsDef[]      = { 0x01 };
   static tU8 arSessionSubsystem[] = { DIA_C_U8_UDS_SESSION_SUBSYSTEM } ;
   static tU8 arSessionsCust_Prog_ProdADR[]     = { 0x02, 0x03, 0x60, 0x61 };
   static tU8 arVariantCoding[32] = {
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
   };
   static tU8 arSessionsCust_Def[]     = { 0x01, 0x03 };

   dia_EngineServer* pEngineCustomer = 0;
   if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngineCustomer) != DIA_SUCCESS )
   {
      DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO CUSTOMER DIAGNOSIS ENGINE #####");
      return DIA_FAILED;
   }

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x10 (session control)
   //
   ////////////////////////////////////////////////////////////////////////////

   ADD_NEW_SRVHDL(dia_SrvHandlerGenericSessionControlAIVI)


   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x11 (ECU reset)
   //
   ////////////////////////////////////////////////////////////////////////////

   // service 0x11 (ECU reset by reset type); concrete ECUReset are created in method dia_FactoryPluginECUResets()
   ADD_NEW_SRVHDL(dia_SrvHandlerGenericECUResetsByResetType)


   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x14 (clear fault memory)
   //
   ////////////////////////////////////////////////////////////////////////////

#if 1
   ADD_NEW_SRVHDL(dia_SrvHandlerGenericClearFaultMemory)
#else
   {
      static const intptr_t args[] = { (intptr_t) DIAGLOG_MEMORY_CUSTOMER, (intptr_t) DIAGLOG_MEMORY_BOSCH };
      (void) pEngineCustomer->bAddServiceHandler(OSAL_NEW dia_SrvHandlerGenericClearFaultMemory(),
            (tU16) (sizeof(args)/sizeof(intptr_t)), (tArgsType*) args);
   }
#endif

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x19 (read fault memory)
   //
   ////////////////////////////////////////////////////////////////////////////

   ADD_NEW_SRVHDL_DID(dia_SrvHandlerGenericReadFaultMemoryCMC, UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER)
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_DID(dia_SrvHandlerGenericReadFaultMemoryCMC, UDS_REPORT_DTC_SNAPSHOT_RECORD_BY_DTC_NUMBER)
   ADD_NEW_SRVHDL_DID(dia_SrvHandlerGenericReadFaultMemoryCMC, UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK)
   ADD_NEW_SRVHDL_DID(dia_SrvHandlerGenericReadFaultMemoryCMC, UDS_REPORT_DTC_BY_STATUS_MASK)
   ADD_NEW_SRVHDL_DID(dia_SrvHandlerGenericReadFaultMemoryCMC, UDS_REPORT_READ_SUPPORTED_DTCS)
   { //Restrict ReadDTCByStatusMask to the main Diaglog Memory when NOT in programming session
      tU8 sessions[]  = {0x01, 0x03, 0x60, 0x61};
      ADD_NEW_SRVHDL_NAME_SID_DID_SESSION_ARGLIST(OSAL_NEW dia_SrvHandlerGenericReadFaultMemoryCMC(UDS_REPORT_DTC_BY_STATUS_MASK), sessions, { (intptr_t) DIAGLOG_MEMORY_CUSTOMER })
   }

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x22 (read data by identifier)
   //
   //   --> DIA_REQ UDS 04 22 <left byte of DID> <right byte of DID>
   //
   ////////////////////////////////////////////////////////////////////////////

   bool Scope21Defined =
#if !defined(VARIANT_S_FTR_ENABLE_RIVIE)     //Only Scope1 and Scope2.0
   false;
#else
   true;
#endif

   dia_SrvHandler_ConfigurationPartNumber* pSrvHandler_ConfigurationPartNumber = OSAL_NEW dia_SrvHandler_ConfigurationPartNumber(Scope21Defined);    //lint !e429: custodial pointer is freed by after engine has processed the message
   (void) pEngineCustomer->bAddServiceHandler(pSrvHandler_ConfigurationPartNumber);
   (void) dia_ConfigManager::getInstance()->addConfigNotifier(pSrvHandler_ConfigurationPartNumber);

   ADD_NEW_SRVHDL(dia_MultiplexNetworkDiagRead)
   ADD_NEW_SRVHDL(dia_MMNetworkDiagRead)
   ADD_NEW_SRVHDL(dia_SrvHandler_SpeedInformationAIVI)
   ADD_NEW_SRVHDL(dia_SrvHandler_VDiag)

#if 0 //STC2HI: TODO
   ADD_NEW_SRVHDL(dia_SrvHandler_FasciaID_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_Encoder1SelectCounterValue_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_Encoder2VolumeCounterValue_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_TunerDAB_Antenna1Status)
   ADD_NEW_SRVHDL(dia_SrvHandler_TunerDAB_Antenna1Current)
   ADD_NEW_SRVHDL(dia_SrvHandler_PressedKey_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_GNSSAntennaStatus_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_GNSSAntennaCurrent_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_GNSSBestSattelites_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_GNSSPositioningSystem_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_GNSSReceiverStatus_Get)

#endif //STC2HI: TODO

   ADD_NEW_SRVHDL(dia_SrvHandler_ECUSerialNumberDataIdentifier)
   ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_GetSystemResetInformation(), arSessionsProd)
   ADD_NEW_SRVHDL(dia_SrvHandler_InputLines)
   ADD_NEW_SRVHDL(dia_SrvHandler_FirstUSBProgramming)
   //ADD_NEW_SRVHDL(dia_SrvHandler_InitialProgrammingLog)
   ADD_NEW_SRVHDL(dia_SrvHandler_ProgrammingLogCurrent)
 //  ADD_NEW_SRVHDL(dia_SrvHandler_ProgrammingLogHistoric)
   ADD_NEW_SRVHDL(dia_SrvHandler_TotalNumberOfReprogramming)
   ADD_NEW_SRVHDL(dia_SrvHandler_KeyPressButtons)
   ADD_NEW_SRVHDL(dia_SrvHandler_KeyPressRotary)
   ADD_NEW_SRVHDL(dia_SrvHandler_KeyPressSWS)
   ADD_NEW_SRVHDL(dia_SrvHandler_KeyPressCDDrive)
   ADD_NEW_SRVHDL(dia_SrvHandler_TouchPress)
   
   ADD_NEW_SRVHDL(dia_SrvHandler_PowerSupply)
   ADD_NEW_SRVHDL(dia_SrvHandler_ReadBatteryLevel)
   ADD_NEW_SRVHDL(dia_SrvHandler_ReadHWSWVersion)
   ADD_NEW_SRVHDL(dia_SrvHandler_ReadMileageValue)
   ADD_NEW_SRVHDL(dia_SrvHandler_USBDeviceInfo)

   ADD_NEW_SRVHDL_NAME_SID_ARGLIST(dia_SrvHandler_SupportedIdentifiers, "dia_SrvHandler_SupportedIdentifiers_Read",    0x22, { (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_ARGLIST(dia_SrvHandler_SupportedIdentifiers, "dia_SrvHandler_SupportedIdentifiers_Write",   0x2E, { (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_ARGLIST(dia_SrvHandler_SupportedIdentifiers, "dia_SrvHandler_SupportedIdentifiers_IOCtrl",  0x2F, { (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_ARGLIST(dia_SrvHandler_SupportedIdentifiers, "dia_SrvHandler_SupportedIdentifiers_RTCtrl",  0x31, { (intptr_t) NULL })

#if 0 //STC2HI: TODO
   ADD_NEW_SRVHDL(dia_ReadBluetoothLinkQuality)
   ADD_NEW_SRVHDL(dia_ReadBluetoothConnectedDevice)
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_tclUDS_BD_GetBDAddress,"UDS_BD_GetBDAddress", 0x22, 0x100A, { (intptr_t) NULL })
#endif //STC2HI: TODO

   //Configuration handling for services with duplicate DIDs

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   //Scope2: separate ServiceHandlers because of different response length
   dia_SrvHandler_ReadBTSubModuleSWVersion* pCustBTSubModuleSWVersion  = OSAL_NEW dia_SrvHandler_ReadBTSubModuleSWVersion(); //DID 0x7001 - Customer Session
   if(pCustBTSubModuleSWVersion)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(pCustBTSubModuleSWVersion,arSessionsCust_Def)
   }

   dia_SrvHandler_ReadBTSubModuleHWVersion* pCustBTSubModuleHWVersion  = OSAL_NEW dia_SrvHandler_ReadBTSubModuleHWVersion(); //DID 0x7002 - Customer Session
   if(pCustBTSubModuleHWVersion)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(pCustBTSubModuleHWVersion,arSessionsCust_Def)
   }
#endif

#if 0
   dia_tclUDS_BD_CustBTLinkQuality* p_BD_GetLinkQuality  = OSAL_NEW dia_tclUDS_BD_CustBTLinkQuality("UDS_BD_CustBTLinkQuality", 0x22, DIA_C_U16_DID_AIVI_BT_SIGNAL_QUALITY); //DID 0x3001 - Customer Session
   if(p_BD_GetLinkQuality)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_BD_GetLinkQuality,arSessionsCust_Def)
   }
#else
   dia_SrvHandler_Antenna1Parameter* pAntenna1 = OSAL_NEW dia_SrvHandler_Antenna1Parameter(); //DID 0x3001 - Customer Session
   if (pAntenna1)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(pAntenna1, arSessionsCust_Def)
   }
#endif

   dia_SrvHandler_Antenna2Parameter* pAntenna2 = OSAL_NEW dia_SrvHandler_Antenna2Parameter(); //DID 0x3002 - Customer Session
   if (pAntenna2)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(pAntenna2, arSessionsCust_Def)
   }

   dia_SrvHandler_Antenna3Parameter* pAntenna3 = OSAL_NEW dia_SrvHandler_Antenna3Parameter(); //DID 0x3003 - Customer Session
   if (pAntenna3)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(pAntenna3, arSessionsCust_Def)
   }

   dia_SrvHandler_ReadBTDevice* p_readBTDevice  = OSAL_NEW dia_SrvHandler_ReadBTDevice(); //DID 0x3000 - Customer Session
   if(p_readBTDevice)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_readBTDevice,arSessionsCust_Def)
   }

   // Configuration handling for services with duplicate DIDs
   dia_SrvHandler_InitialProgrammingLog* p_Initial_Prog_Log  = OSAL_NEW dia_SrvHandler_InitialProgrammingLog(); //DID 0x1102 - Customer Session and Default Session
   if(p_Initial_Prog_Log)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_Initial_Prog_Log,arSessionsCust_Def)
   }

   dia_tclUDS_BD_CustBTMacAddress* p_custBTMacAddr = OSAL_NEW dia_tclUDS_BD_CustBTMacAddress("UDS_BD_CustBTMacAddress",  0x22, DIA_C_U16_DID_RBCM_BT_MAC_ADDRESS); //DID 0x7008 - Customer Session
   if(p_custBTMacAddr)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_custBTMacAddr,arSessionsCust_Def)
   }

   dia_tclUDS_WIFI_CustMacAddress* p_custWIFIMacAddr = OSAL_NEW dia_tclUDS_WIFI_CustMacAddress("UDS_WIFI_CustMacAddress",  0x22, DIA_C_U16_DID_RBCM_WIFI_MAC_ADDRESS);  //DID 0x7009 - Customer Session
   if(p_custBTMacAddr)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_custWIFIMacAddr,arSessionsCust_Def)
   }

#if 0 //STC2HI: TODO
   ADD_NEW_SRVHDL(dia_SrvHandler_DimmingLedClassInfo_Get)
   ADD_NEW_SRVHDL(dia_SrvHandler_BTMACAddress_Get)
#endif

#if 0 //STC2HI: TODO
   ADD_NEW_SRVHDL(dia_SrvHandler_TunerAMFM_FMRDSProgramInformation);
#endif //STC2HI: TODO

#if 0 //STC2HI: DEPRECATED, might be removed from SW without further notice
   ADD_NEW_SRVHDL(dia_SrvHandler_GNSSBestSattelites_Get)
#endif

#if 0 //STC2HI: TODO
   ADD_NEW_SRVHDL(dia_SrvHandler_GetPlayedTrack);
   ADD_NEW_SRVHDL(dia_SrvHandler_SystemCurrentDiagnosticSession);

   //--------------------------------- class name ---------------------- instance name --------------------------- SID - DID --- ARG_LIST ------------------------------------
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_01",                      0x22, 0x1100, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GYRO_R })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_02",                      0x22, 0x1101, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GYRO_S })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_03",                      0x22, 0x1102, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GYRO_T })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_04",                      0x22, 0x1103, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GPS_UANT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_05",                      0x22, 0x1104, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GPS_UTMP })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_06",                      0x22, 0x1105, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GPS_VOLTAGE_SENSE })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_07",                      0x22, 0x1106, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_UBAT_DROP_DET })

   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_09",                      0x22, 0x1108, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_DIAG_DAB_PHANTOM_ANT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_10",                      0x22, 0x1109, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM1_ANT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_11",                      0x22, 0x110a, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM2_ANT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_12",                      0x22, 0x110b, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_CRADLE_KEY })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_13",                      0x22, 0x110c, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_CRADLE_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_14",                      0x22, 0x110d, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_MIC_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_15",                      0x22, 0x110e, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_MIC_DIAG_2 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_16",                      0x22, 0x110f, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_TEMP_SENSE })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_17",                      0x22, 0x1110, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_DIAG_AUX_R })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_18",                      0x22, 0x1111, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_DIAG_AUX_L })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_19",                      0x22, 0x1112, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_TEMP_SENSOR_1 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_20",                      0x22, 0x1113, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_TEMP_SENSOR_2 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_21",                      0x22, 0x1114, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM_ANT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_22",                      0x22, 0x1115, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_PWM_AMP_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_23",                      0x22, 0x1116, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_PWM_DISPLAY_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_24",                      0x22, 0x1117, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_STEERING_WHEEL })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_25",                      0x22, 0x1118, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_U33S_CPU_SWC })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_26",                      0x22, 0x1119, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_FAN_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_27",                      0x22, 0x111a, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_TEMP_GPS })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_28",                      0x22, 0x111b, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_HALFCLASS_1 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_29",                      0x22, 0x111c, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_HALFCLASS_2 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_30",                      0x22, 0x111d, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_DIAG_PHANTOM_FM_ANT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_31",                      0x22, 0x111e, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_DISP_TEMP_SENSE })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_32",                      0x22, 0x111f, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GER_VAR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_33",                      0x22, 0x1120, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GPS_PHANTOM_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_34",                      0x22, 0x1121, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_PHANTOM_2_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_35",                      0x22, 0x1122, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_SWC_A })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_36",                      0x22, 0x1123, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_SWC_B })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_37",                      0x22, 0x1124, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_TOUCH_X_CO })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_38",                      0x22, 0x1125, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_TOUCH_Y_CO })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_39",                      0x22, 0x1126, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_XM_DAB_ANT_I_SENSE })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_40",                      0x22, 0x1127, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_CAMERA_VCC_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_41",                      0x22, 0x1128, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_MIC_VCC_DIAG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentADCRead,"SrvHandler_ADC_42",                      0x22, 0x1129, { (intptr_t) DIA_PROP_CM_ADC_DEVICE_GYRO_VDD_REF })

   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadSerialNumber0047",        0x22, 0x0047, { (intptr_t) DIA_PROP_CM_TEST_SERVICE_0047 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCDWackUp",                0x22, 0x1013, { (intptr_t) DIA_PROP_GPIO_CD_WACKUP })

   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCustomerSerialNumber",    0x22, 0x2002, { (intptr_t) DIA_PROP_CM_CUSTOMER_SERIAL_NR })
#endif
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCustomerSparePartNumber", 0x22, DIA_C_U16_DID_CM_CUSTOMER_PCB_PARTNUMBER,   { (intptr_t) DIA_PROP_CM_CUSTOMER_SPARE_PART_NR })

#if 0
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadMROutput",                0x22, 0x1006, { (intptr_t) DIA_PROP_GPIO_MR_OUNTPUT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadWORM_ID",                 0x22, 0x2007, { (intptr_t) DIA_PROP_VERSION_DATACARRIER_WORM_ID })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_POIEncryptionInfo",           0x22, 0x3107, { (intptr_t) DIA_PROP_CM_POI_ENCRYPTION_INFO })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_Systemidentification",        0x22, 0x2009, { (intptr_t) DIA_PROP_CM_SYSTEM_IDENTIFICATION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ConfigInfo",                  0x22, 0x3100, { (intptr_t) DIA_PROP_CM_CONF_INFO })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_DimmingParamet1",             0x22, 0x3103, { (intptr_t) DIA_PROP_CM_DIMMING_PARAMETER_SET_1 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_DimmingParamet2",             0x22, 0x3104, { (intptr_t) DIA_PROP_CM_DIMMING_PARAMETER_SET_2 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ADC_Reference_Voltage",       0x22, 0x3105, { (intptr_t) DIA_PROP_ADC_U_REF_REAL })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_EngTestMode",                 0x22, 0x3108, { (intptr_t) DIA_PROP_ENG_TEST_MODE })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_SpeedLimit",                  0x22, 0x3109, { (intptr_t) DIA_PROP_SPEED_LOCK })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_VehicleInfo",                 0x22, 0x3112, { (intptr_t) DIA_PROP_NISSAN_DEF_VEHICLE_INFO })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_CameraSystem",                0x22, 0x3113, { (intptr_t) DIA_PROP_NISSAN_DEF_CAMERA_SYSTEM })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_BTName",                      0x22, 0x3114, { (intptr_t) DIA_PROP_NISSAN_DEF_BTNAME })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_SysConf2",                    0x22, 0x3115, { (intptr_t) DIA_PROP_NISSAN_DEF_SYSTEM_CONFIG2 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ECO",                         0x22, 0x3116, { (intptr_t) DIA_PROP_NISSAN_DEF_ECOROUTE })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_SDS",                         0x22, 0x3117, { (intptr_t) DIA_PROP_NISSAN_DEF_SDS })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_SysConf1",                    0x22, 0x3118, { (intptr_t) DIA_PROP_NISSAN_DEF_SYSTEM_CONFIG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_Phone",                       0x22, 0x3119, { (intptr_t) DIA_PROP_NISSAN_DEF_PHONE })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_FM_AM",                       0x22, 0x311a, { (intptr_t) DIA_PROP_NISSAN_DEF_FMAMTUNER_PARAM_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_Audio",                       0x22, 0x311b, { (intptr_t) DIA_PROP_NISSAN_DEF_AUDIO_PARAM_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_DAB",                         0x22, 0x311d, { (intptr_t) DIA_PROP_NISSAN_DEF_DAB_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_PartNumber",                  0x22, 0x311f, { (intptr_t) DIA_PROP_NISSAN_DEF_PARTS_NUMBER })
#endif
#if 0
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_eMMC_Thresholds_Temperature", 0x22, 0x8110, { (intptr_t) DIA_PROP_ADC_THRESHOLDS_EMMC })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadECUSWBuildVersionLabel",  0x22, 0x7000, { (intptr_t) DIA_PROP_CM_ECU_SW_BUILD_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadBTSubModuleSWVersion",    0x22, 0x7001, { (intptr_t) DIA_PROP_VERSION_SW_BLUETOOTH })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadBTSubModuleHWVersion",    0x22, 0x7002, { (intptr_t) DIA_PROP_VERSION_HW_BLUETOOTH })
#endif
#if 0
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadHWConfigString",          0x22, 0x8100, { (intptr_t) DIA_PROP_CM_HW_CONFIG_STRING })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadNaviDefaultPosition",     0x22, 0x8300, { (intptr_t) DIA_PROP_CM_NAVIGATION_DEFAULT_POSITION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadNavi data sec key",       0x22, 0x8301, { (intptr_t) DIA_PROP_CM_NAVI_DATA_SEC_KEY })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadECUSparePartNumber",      0x22, 0xC000, { (intptr_t) DIA_PROP_CM_ECU_SPARE_PART_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadECUSerialNumber",         0x22, 0xC001, { (intptr_t) DIA_PROP_CM_ECU_SERIAL_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadODXFileIdentifier",       0x22, 0xC002, { (intptr_t) DIA_PROP_CM_ODX_FILE_IDENTIFIER })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadODXFileVersion",          0x22, 0xC003, { (intptr_t) DIA_PROP_CM_ODX_FILE_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadECUSWVersion",            0x22, 0xC004, { (intptr_t) DIA_PROP_CM_ECU_SW_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadECUHWVersion",            0x22, 0xC005, { (intptr_t) DIA_PROP_CM_ECU_HW_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadMainboardSparePartNumber",0x22, 0xC006, { (intptr_t) DIA_PROP_CM_MAINBOARD_SPARE_PART_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadMainboardSerialNumber",   0x22, 0xC007, { (intptr_t) DIA_PROP_CM_MAINBOARD_SERIAL_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCRIN",                    0x22, 0xC009, { (intptr_t) DIA_PROP_CRIN_IDENTIFICATION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadNavigationSWVersion",     0x22, 0x7005, { (intptr_t) DIA_PROP_CM_NAVIGATION_SW_VERSION })
#endif //STC2HI: TODO
  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadOutputLine",              0x22, DIA_C_U16_DID_AIVI_OUTPUT_LINE, { (intptr_t) DIA_PROP_GPIO_SYSTEM_AMP_ON_OUTPUT })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadOccurenceCounter",        0x22, DIA_C_U16_DID_AIVI_OCCURENCE_COUNTER, { (intptr_t) DIA_PROP_AIVI_OCCURENCE_COUNTER })
   ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_SCC",       0x22, DIA_C_U16_DID_RBCM_V850_TEMPERATURE,             DIA_EN_HEATCTRL_TEMPERATURE_ID_V850,   { (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_DVDDrive",  0x22, DIA_C_U16_DID_RBCM_DVD_DRIVER_TEMPERATURE,       DIA_EN_HEATCTRL_TEMPERATURE_ID_DVDDRIVE,   { (intptr_t) NULL })
  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_Panel",     0x22, DIA_C_U16_DID_RBCM_PANEL_TEMPERATURE,            DIA_EN_HEATCTRL_TEMPERATURE_ID_PANEL, { (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_CDDrive",   0x22, DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_TEMPERATURE,    DIA_EN_HEATCTRL_TEMPERATURE_ID_CDDRIVE,{ (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_eMMC",      0x22, DIA_C_U16_DID_RBCM_EMMC_TEMPERATURE,             DIA_EN_HEATCTRL_TEMPERATURE_ID_EMMC,{ (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_HeatSink",  0x22, DIA_C_U16_DID_RBCM_HEATSINK_TEMPERATURE,         DIA_EN_HEATCTRL_TEMPERATURE_ID_HEATSINK,{ (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_Amplifier", 0x22, DIA_C_U16_DID_RBCM_AMPLIFIER_TEMPERATURE,        DIA_EN_HEATCTRL_TEMPERATURE_ID_AMP,{ (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_GYRO",      0x22, DIA_C_U16_DID_RBCM_GYRO_TEMPERATURE,             DIA_EN_HEATCTRL_TEMPERATURE_ID_GYRO,   { (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_IMX",       0x22, DIA_C_U16_DID_RBCM_IMX_TEMPERATURE,              DIA_EN_HEATCTRL_TEMPERATURE_ID_IMX,{ (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_DISPLAY",   0x22, DIA_C_U16_DID_RBCM_DISPLAY_TEMPERATURE,          DIA_EN_HEATCTRL_TEMPERATURE_ID_PANEL,{ (intptr_t) NULL })
   ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_XmModule",  0x22, DIA_C_U16_DID_RBCM_XMMODULE_TEMPERATURE,         DIA_EN_HEATCTRL_TEMPERATURE_ID_XMMODULE,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_TvModule",  0x22, DIA_C_U16_DID_RBCM_TVMODULE_TEMPERATURE,         DIA_EN_HEATCTRL_TEMPERATURE_ID_TVMODULE,   { (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_TvModule2", 0x22, DIA_C_U16_DID_RBCM_TVMODULESLAVE_TEMPERATURE,    DIA_EN_HEATCTRL_TEMPERATURE_ID_TVMODULESLAVE,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureRead,"SrvHandler_ReadTemp_Display2",  0x22, DIA_C_U16_DID_RBCM_PANEL2_TEMPERATURE,           DIA_EN_HEATCTRL_TEMPERATURE_ID_PANEL2,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_Emmc",      0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_EMMC,      DIA_EN_HEATCTRL_TEMPERATURE_ID_EMMC     ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_HeatSink",  0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_HEAT_SINK, DIA_EN_HEATCTRL_TEMPERATURE_ID_HEATSINK ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_Gyro",      0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_GYRO,      DIA_EN_HEATCTRL_TEMPERATURE_ID_GYRO     ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_DvdDrive",  0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_DVD_DRIVE, DIA_EN_HEATCTRL_TEMPERATURE_ID_DVDDRIVE ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_CdDrive",   0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_CD_DRIVE,  DIA_EN_HEATCTRL_TEMPERATURE_ID_CDDRIVE  ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_Amplifier", 0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_AMPLIFIER, DIA_EN_HEATCTRL_TEMPERATURE_ID_AMP      ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_Display",   0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_DISPLAY,   DIA_EN_HEATCTRL_TEMPERATURE_ID_DISPLAY  ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_Imx",       0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_IMX,       DIA_EN_HEATCTRL_TEMPERATURE_ID_IMX      ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_Panel",     0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_PANEL,     DIA_EN_HEATCTRL_TEMPERATURE_ID_PANEL    ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerGenericTemperatureHistogramRead,"SrvHandler_ReadTempHistogram_Scc",       0x22, DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_SCC,       DIA_EN_HEATCTRL_TEMPERATURE_ID_V850     ,{})
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_1",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_1, DIA_EN_PROG_LOG_HISTORY_ID_N_1,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_2",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_2, DIA_EN_PROG_LOG_HISTORY_ID_N_2,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_3",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_3, DIA_EN_PROG_LOG_HISTORY_ID_N_3,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_4",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_4, DIA_EN_PROG_LOG_HISTORY_ID_N_4,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_5",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_5, DIA_EN_PROG_LOG_HISTORY_ID_N_5,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_6",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_6, DIA_EN_PROG_LOG_HISTORY_ID_N_6,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_7",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_7, DIA_EN_PROG_LOG_HISTORY_ID_N_7,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_8",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_8, DIA_EN_PROG_LOG_HISTORY_ID_N_8,{ (intptr_t) NULL })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandler_ProgrammingLogHistoric,"SrvHandler_ReadProgLog_Historic_N_9",   0x22, DIA_C_U16_DID_AIVI_PROGRAMMING_LOG_HISTORIC_N_9, DIA_EN_PROG_LOG_HISTORY_ID_N_9,{ (intptr_t) NULL })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSpeedLockout",        0x22, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT,         { (intptr_t) DIA_PROP_AIVI_SPEED_LOCKOUT })
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerVINIdentRead,       "SrvHandler_ReadVehicleIdentNumber",  0x22, DIA_C_U16_DID_AIVI_VIN,                   { (intptr_t) DIA_PROP_AIVI_VIN })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadMEXConfig",           0x22, DIA_C_U16_DID_AIVI_MEX_CONFIG,            { (intptr_t) DIA_PROP_AIVI_MEX_CONFIG })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadFactoryMode",         0x22, DIA_C_U16_DID_AIVI_FACTORY_MODE,          { (intptr_t) DIA_PROP_AIVI_FACTORY_MODE })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadConnectivityConfig",  0x22, DIA_C_U16_DID_AIVI_CONNECTIVITY_CONFIG,   { (intptr_t) DIA_PROP_AIVI_CONNECTIVITY_CONFIG })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadHmiConfig",           0x22, DIA_C_U16_DID_AIVI_HMI_CONFIG,            { (intptr_t) DIA_PROP_AIVI_HMI_CONFIG })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSoundVolConfig",      0x22, DIA_C_U16_DID_AIVI_SOUND_VOLUME_CONFIG,   { (intptr_t) DIA_PROP_AIVI_SOUND_VOLUME_CONFIG })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadRUC",               0x22, DIA_C_U16_DID_AIVI_CONFIG_FILE_REFERENCE_LINK_RUC,   { (intptr_t) DIA_PROP_VERSION_SW_CUSTOMER })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadAllianceSWReference", 0x22, DIA_C_U16_DID_AIVI_ALLIANCE_SW_REF,       { (intptr_t) DIA_PROP_VERSION_SW_CUSTOMER })
#endif

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_FanActivationCounter(), arSessionsCust_Def)
   ADD_SRVHDL_FOR_SPECIFIC_SESSION(OSAL_NEW dia_SrvHandler_FanActivationDuration(), arSessionsCust_Def)
#endif
   dia_SrvHandler_ReadCDCountInsert* p_getReadCDCountInsert = OSAL_NEW dia_SrvHandler_ReadCDCountInsert(); //DID 0x3005
   if(p_getReadCDCountInsert)
   {
      ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_getReadCDCountInsert,arSessionsCust_Def)

   }

  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_WifiMonitoring, "SrvHandler_WifiMonitoring",  0x22, DIA_C_U16_DID_AIVI_WIFI_MONITORING, { (intptr_t) NULL })

  /*####################################################################################################################*/
  /*################################################ CMC READ FEATURES START ###########################################*/
  /*################################################ CMC READ FEATURES START ###########################################*/
  /*################################################ CMC READ FEATURES START ###########################################*/
  /*####################################################################################################################*/
  
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerSoftwareSupplierIdentRead, 					"SrvHandler_SoftwareSupplierIdentRead", 			0x22, DIA_C_U16_DID_CENTER_CMC_19_SOFTWARE_SUPPLIER_INFO, 					{ (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerHardwareSupplierIdentRead, 					"SrvHandler_HardwareSupplierIdentRead", 			0x22, DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_SUPPLIER_INFO, 					{ (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerPrjSpecificIdentRegistryRead,  				"SrvHandler_ReadCustomerBootSwVersion",         	0x22, DIA_C_U16_DID_CENTER_CMC_19_BOOT_SW_VERSION_INFO,          			{ (intptr_t) DIA_PROP_CENTER_CMC_19_VERSION_SW_BOOT })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerInstallationContainerSwVersion,  			"SrvHandler_CISInstallationContainerSwVersion",     0x22, DIA_C_U16_DID_CENTER_CMC_19_SW_VERSION_INFO,          				{ (intptr_t) NULL }) 

  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadOverallCISSWVersion,  			            "SrvHandler_ReadOverallCISSWVersion",           0x22, DIA_C_U16_DID_CENTER_CMC_19_READ_OVERALL_CIS_SW_VERSION,              { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerComponentsSWVersionInfo,  			            "SrvHandler_ComponentsSWVersioninformation",           0x22, DIA_C_U16_DID_CENTER_CMC_19_COMPONENTS_SW_VERSION_INFO,        { (intptr_t) NULL })

  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadECUSparePartNumber",    			0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_HW_PART_NUMBER,       { (intptr_t) DIA_PROP_CM_ECU_SPARE_PART_NR })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadECUHWVersion",          			0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_HW_VERSION_NUMBER,    { (intptr_t) DIA_PROP_CM_ECU_HW_VERSION })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadECUSWBuildVersionLabel",			0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_SW_PART_NUMBER,       { (intptr_t) DIA_PROP_CM_ECU_SW_BUILD_VERSION })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadECUSWVersion",          			0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_SUPPLIER_ECU_SW_VERSION_NUMBER,    { (intptr_t) DIA_PROP_CM_ECU_SW_VERSION })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerPrjSpecificECUSerialNumberRead,				"SrvHandlerPrjSpecificECUSerialNumberRead", 		0x22, DIA_C_U16_DID_CENTER_CMC_19_ECU_SERIAL_NUMBER,        				{ (intptr_t) NULL})
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadHardwareVersionInformation",		0x22, DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_VERSION_INFO,           			{ (intptr_t) DIA_PROP_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadcustomerECUHWVersion",          	0x22, DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION,        			{ (intptr_t) DIA_PROP_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadHardwarePartNumber",            	0x22, DIA_C_U16_DID_CENTER_CMC_19_HARDWARE_PART_NUMBER,           			{ (intptr_t) DIA_PROP_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadCustomerSparePartNumber",       	0x22, DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER,     			{ (intptr_t) DIA_PROP_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER })
#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT  
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadVINOdometer",                   	0x22, DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER,                   			{ (intptr_t) DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER})
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadVINOdometerLimit",              	0x22, DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER_LIMIT,             			{ (intptr_t) DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER_LIMIT})
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadVINOriginal",                   	0x22, DIA_C_U16_DID_CENTER_CMC_19_VIN_ORIGINAL,                   			{ (intptr_t) DIA_PROP_CENTER_CMC_19_VIN_ORIGINAL})
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadVINCurrent",                    	0x22, DIA_C_U16_DID_CENTER_CMC_19_VIN_CURRENT,                    			{ (intptr_t) DIA_PROP_CENTER_CMC_19_VIN_CURRENT})
#endif
  ADD_NEW_SRVHDL(dia_SrvHandlerPrjSpecificActiveDiagInfoRead)
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerCompatibilityListRead,     					"SrvHandlerCompatibilityListRead", 					0x22, DIA_C_U16_DID_CENTER_CMC_19_COMPATIBILITY_LIST, 						{ (intptr_t)NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  		   					"SrvHandler_ReadConfigurationFingerprint",      	0x22, DIA_C_U16_DID_CENTER_CMC_19_CONFIGURATION_FINGERPRINT,      			{ (intptr_t) DIA_PROP_CENTER_CMC_19_FINGERPRINT_CONFIG })
  ADD_NEW_SRVHDL(dia_SrvHandler_Get_DAB_Tuner_Fieldstrength)
  ADD_NEW_SRVHDL(dia_SrvHandler_Get_FM_Tuner2_Fieldstrength)
  ADD_NEW_SRVHDL(dia_SrvHandler_Get_SXM_Tuner_Fieldstrength)
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength,				"dia_SrvHandler_Get_TunerAMFM_Fieldstrength",  		0x22, DIA_C_U16_DID_CENTER_CMC_19_TUNER_AM_FM_FIELDSTRENGTH, 				{ (intptr_t) NULL }) 
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength,				"dia_SrvHandler_Get_Weatherband_Fieldstrength",  	0x22, DIA_C_U16_DID_CENTER_CMC_19_WEATHERBAND_FIELDSTRENGTH, 				{ (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadSystemOperationTime,     				"dia_SrvHandler_ReadSystemOperationTime", 			0x22, DIA_C_U16_DID_CENTER_CMC_19_SYSTEM_OPERATION_TIME, 					{ (intptr_t) NULL }) 
  ADD_NEW_SRVHDL_NAME_SID_DID_01_PARAM_ARGLIST(dia_SrvHandlerTemperatureHistogramRead,			"SrvHandlerTemperatureHistogramRead",       		0x22, DIA_C_U16_DID_CENTER_CMC_19_TEMPERATURE_HISTOGRAM_IMX,       			DIA_EN_HEATCTRL_TEMPERATURE_ID_IMX      ,{})
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_MercedesTruckSoftware,  	  				"SrvHandler_ReadMercedesTruckSoftware",      		0x22, DIA_C_U16_DID_CENTER_CMC_19_MERCEDES_TRUCK_SOFTWARE_PART_NUMBER,      { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  	  					    "SrvHandler_CDReadPNMGroup10Configuration",      	0x22, DIA_C_U16_DID_CENTER_CMC_19_PNM_GROUP10_CONFIG,                       { (intptr_t) DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  	  					    "SrvHandler_CDDefReadPNMGroup10Configuration",      0x22, DIA_C_U16_DID_CENTER_CMC_19_CD_DEF_NVM_GROUP10_CONFIG,                { (intptr_t) DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG })

  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  	  					    "SrvHandler_ReadHistoricalInterrogationRec",      	0x22, DIA_C_U16_DID_CENTER_CMC_19_HISTORICLE_INTERROGATION_REC,             { (intptr_t) DIA_PROP_CENTER_CMC_19_HISTORICAL_INTERROGATON_RECORD })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,							"SrvHandler_ReadTesterIdentication",                0x22, DIA_C_U16_DID_CENTER_CMC_19_TESTER_IDENTIFICATION,    				{ (intptr_t) DIA_PROP_CENTER_CMC_19_SECURITY_TESTER_IDENTIFICATION })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadAmplifierConnectionStatus,				"dia_SrvHandler_ReadAmplifierConnectionStatus",  	0x22, DIA_C_U16_DID_CENTER_CMC_19_OABR_CONNECTION_STATUS_AMPLIFIER, 		{ (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_Get_TunerAMFMWB_Fieldstrength,				"dia_SrvHandler_Get_TunerAMFM_Fieldstrength",  		0x22, DIA_C_U16_DID_CENTER_CMC_19_TUNER_HD_FIELDSTRENGTH, 				    { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,                           "SrvHandler_CDReadDTCConfiguration",      	        0x22, DIA_C_U16_DID_CENTER_CMC_19_DTC_CONFIGURATION,                        { (intptr_t) DIA_PROP_CENTER_CMC_19_DTC_CONFIG })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerCVBSConnectionStatus,                       "dia_SrvHandlerCVBSConnectionStatus",      	        0x22, DIA_C_U16_DID_CENTER_CMC_19_CVBS_CONNECTION_STATUS,                   { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerPhoneBookMaxContactEntries,                 "dia_SrvHandlerPhoneBookMaxContactEntries",      	0x22, DIA_C_U16_DID_CENTER_CMC_19_PHONEBOOK_MAX_CONTACT_ENTRIES,            { (intptr_t) NULL })

  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadSubsystemNodeList,                      "dia_SrvHandlerReadSubsystemNodeList",   	        0x22, DIA_C_U16_DID_CENTER_CMC_19_SUBSYSTEM_NODE_LIST,                   { (intptr_t) NULL })

  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerAudioFileCounter,                           "dia_SrvHandlerAudioFileCounter",                   0x22, DIA_C_U16_DID_CENTER_CMC_19_AUDIO_FILES_COUNTER ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerVideoFileCounter,                           "dia_SrvHandlerVideoFileCounter",                   0x22, DIA_C_U16_DID_CENTER_CMC_19_VIDEO_FILES_COUNTER ,                     { (intptr_t) NULL })

  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadRunTimeSource,                           "dia_SrvHandlerReadRunTimeSource",                 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_AM ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadRunTimeSourceFM,                         "dia_SrvHandlerReadRunTimeSource",                 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_FM ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadRunTimeSourceDAB,                        "dia_SrvHandlerReadRunTimeSource",                 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_DAB ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadRunTimeSourceSXM,                        "dia_SrvHandlerReadRunTimeSource",                 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_SXM ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadRunTimeSourceWX,                         "dia_SrvHandlerReadRunTimeSource",                 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_WBD ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadRunTimeSource,                           "dia_SrvHandlerReadRunTimeSource",                 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_HD ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadRunTimeSourcePassMapOut,                 "dia_SrvHandlerReadRunTimeSource",                 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_PMO ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadRunTimeSourceRouteGuidance,              "dia_SrvHandlerReadRunTimeSource",                 0x22, DIA_C_U16_DID_CENTER_CMC_19_RUN_TIME_SOURCE_ARG ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadSPeechControlCounter,                    "dia_SrvHandlerReadSPeechControlCounter",          0x22, DIA_C_U16_DID_CENTER_CMC_19_SPEECH_CONTROL_COUNTER ,                  { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerReadSWDownloadPrivateKey,                    "dia_SrvHandlerReadSWDownloadPrivateKey",          0x22, DIA_C_U16_DID_CENTER_CMC_19_SW_DOWNLOAD_PRIVATE_KEY_STATUS ,          { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_DataCarrierVersionRead,                      "dia_SrvHandler_DataCarrierVersionRead",            0x22, DIA_C_U16_DID_CENTER_CMC_19_DATA_CARRIER_VERSION ,                     { (intptr_t) NULL })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerVehicleInformation,                          "SrvHandler_Vehicleinformation",                   0x22, DIA_C_U16_DID_CENTER_CMC_19_VEHICLE_INFO,                             { (intptr_t) NULL })



  /*####################################################################################################################*/
  /*################################################ CMC READ FEATURES END #############################################*/
  /*################################################ CMC READ FEATURES END #############################################*/
  /*################################################ CMC READ FEATURES END #############################################*/
  /*####################################################################################################################*/ 
   
   
   // Read Services for variable length parameter sets
   struct TestServices
   {
      tCString name;
      tU16 did;
      tU32 propID;
   };
   static const TestServices varLengthConfigItems[] =
   {
         {"SrvHandler_ReadPhone_ECNR_NBS",              DIA_C_U16_DID_AIVI_PHONE_ECNR_NBS_BASE_SCOPE2,   DIA_PROP_AID_DATASET_ECNR_BT_PHONE_NB},
         {"SrvHandler_ReadPhone_ECNR_WBS",              DIA_C_U16_DID_AIVI_PHONE_ECNR_WBS_BASE_SCOPE2,   DIA_PROP_AID_DATASET_ECNR_BT_PHONE_WB},
         {"SrvHandler_ReadCarplay_Phone_ECNR_NBS",      DIA_C_U16_DID_AIVI_CARPLAY_PHONE_ECNR_NBS,       DIA_PROP_AID_DATASET_ECNR_CP_PHONE_NB},
         {"SrvHandler_ReadCarplay_Phone_ECNR_WBS",      DIA_C_U16_DID_AIVI_CARPLAY_PHONE_ECNR_WBS,       DIA_PROP_AID_DATASET_ECNR_CP_PHONE_WB},
         {"SrvHandler_ReadCarplay_Facetime_ECNR_SWB",   DIA_C_U16_DID_AIVI_CARPLAY_FACETIME_ECNR_SWB,    DIA_PROP_AID_DATASET_ECNR_CP_FACETIME_SWB}
        ,{"SrvHandler_ReadAcoustic_Param",              DIA_C_U16_DID_AIVI_ACOUSTIC_PARAM_BASE_SCOPE2,   DIA_PROP_AIVI_ACOUSTIC_PARAM}   //valid for Scope 2.0, keep in Scope 2.1 also (due to customer request)
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
         ,{"SrvHandler_ReadVR_Param_Auto_Barge_In",     DIA_C_U16_DID_AIVI_VR_PARAM_AUTO_BARGE_IN_SCOPE2,DIA_PROP_AIVI_VR_PARAM}
#endif
   };

   for (tU32 i = 0; i < sizeof(varLengthConfigItems)/sizeof(TestServices); i++)
   {
      dia_ServiceHandler* pServiceHandler = OSAL_NEW dia_GenericConfigItemVarLengthRead(varLengthConfigItems[i].name,
            DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, varLengthConfigItems[i].did);
      if (pServiceHandler)
      {
         tU8 sessions[] = {0x01, 0x60}; //Default and Production Session
         void* args[] = {(void*) varLengthConfigItems[i].propID};
         (void) pEngineCustomer->bAddServiceHandler(pServiceHandler, sizeof(sessions)/sizeof(tU8), sessions, sizeof(args)/sizeof(void*), args);
      }
   }

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x27 (security access)
   //
   ////////////////////////////////////////////////////////////////////////////

// ADD_NEW_SRVHDL(dia_SrvHandlerGenericSecurityAccess)
   dia_SrvHandler_SecurityAccess* p_SecurityAccess = OSAL_NEW dia_SrvHandler_SecurityAccess();
         if(p_SecurityAccess)
         {
           ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_SecurityAccess,arSessionsDef)

         }
   dia_SrvHandlerGenericSecurityAccess* p_GenericSecurityAccess = OSAL_NEW dia_SrvHandlerGenericSecurityAccess();
         if(p_GenericSecurityAccess)
         {
           ADD_SRVHDL_FOR_SPECIFIC_SESSION(p_GenericSecurityAccess,arSessionsCust_Prog_ProdADR)

         }
   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x23 (read data by memory address)
   //
   ////////////////////////////////////////////////////////////////////////////

   //ADD_NEW_SRVHDL(dia_SrvHandler_ReadDataByMemory) //Moved to factoryPluginProductionServices

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x22 (read data by identifier - Implement service for Production related Identification and configuration data)
   //
   ////////////////////////////////////////////////////////////////////////////

   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSystemInformationCommon",         0x22, DIA_C_U16_DID_AIVI_SYSTEM_INFO_COMMON, { (intptr_t) DIA_PROP_AIVI_SYSTEM_INFO_COMMON })
  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadCameraSystem",                    0x22, DIA_C_U16_DID_AIVI_CAMERA_SYSTEM, { (intptr_t) DIA_PROP_AIVI_CAMERA_SYSTEM })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadECUsoftwareNumber",               0x22, DIA_C_U16_DID_AIVI_CM_ECU_SOFTWARE_NUMBER, { (intptr_t) DIA_PROP_AIVI_ECU_SW_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadECUsoftwareVersionNumber",        0x22, DIA_C_U16_DID_AIVI_CM_ECU_SOFTWARE_VERSION_NUMBER, { (intptr_t) DIA_PROP_AIVI_ECU_SW_VERSION_NUMBER })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadVehicleInformation",              0x22, DIA_C_U16_DID_AIVI_SYSTEM_VEHICLE_INFO, { (intptr_t) DIA_PROP_AIVI_VEHICLE_INFO })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadECORoute",                        0x22, DIA_C_U16_DID_AIVI_ECO_ROUTE, { (intptr_t) DIA_PROP_AIVI_ECO_ROUTE })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadBTName",                          0x22, DIA_C_U16_DID_AIVI_BT_NAME, { (intptr_t) DIA_PROP_CM_BT_NAME })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadConfigHashValue",                 0x22, DIA_C_U16_DID_AIVI_CONFIG_HASH_VALUE, { (intptr_t) DIA_PROP_AIVI_CONFIG_HASH_VALUE })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadConfigPartNumber",                0x22, DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER, { (intptr_t) DIA_PROP_AIVI_CONFIG_PARTS_NUMBER })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadConfigSystemSupplierNumber",      0x22, DIA_C_U16_DID_AIVI_CONFIG_SYSTEM_SUPPLIER_NR, { (intptr_t) DIA_PROP_AIVI_CONFIG_SYSTEM_SUPPLIER_NUMBER })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSensorConfigGyro",                0x22, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GYRO, { (intptr_t) DIA_PROP_AIVI_SENSOR_CONFIG_GYRO })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSensorConfigGNSS",                0x22, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GNSS, { (intptr_t) DIA_PROP_AIVI_SENSOR_CONFIG_GNSS })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadSensorConfigACC",                 0x22, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_ACC, { (intptr_t) DIA_PROP_AIVI_SENSOR_CONFIG_ACC })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadFMAMTunerParameterSet",           0x22, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadFMAMTunerParameterSet1",          0x22, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_01, { (intptr_t) DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET_01 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadFMAMTunerParameterSet2",          0x22, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_02, { (intptr_t) DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET_02 })
  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadAntennaParameterSet",             0x22, DIA_C_U16_DID_AIVI_ANTENNA_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_ANTENNA_PARAM_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDABParameterSet",                 0x22, DIA_C_U16_DID_AIVI_DAB_SET, { (intptr_t) DIA_PROP_AIVI_DAB_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadGenericTunerParameterSet",        0x22, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET })
// ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead   ,"SrvHandler_ReadCMExtendedVariantCoding",        0x22, DIA_C_U16_DID_CM_EXTENDED_VARIANT_CODING, { (intptr_t) DIA_PROP_CM_EXTENDED_VARIANT_CODING })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadGenericTunerParameterSet1",       0x22, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_01, { (intptr_t) DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET_01 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadGenericTunerParameterSet2",       0x22, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_02, { (intptr_t) DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET_02 })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadHDParameterSet",                  0x22, DIA_C_U16_DID_AIVI_HD_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_HD_PARAM_SET })
// ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadWifiName",                        0x22, DIA_C_U16_DID_AIVI_WIFI_NAME, { (intptr_t) DIA_PROP_AIVI_WIFI_NAME })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadAudioParameterSet",               0x22, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_AUDIO_PARAM_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadAudioParameterSet1",              0x22, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_01, { (intptr_t) DIA_PROP_AIVI_AUDIO_PARAM_SET_01 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadAudioParameterSet2",              0x22, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_02, { (intptr_t) DIA_PROP_AIVI_AUDIO_PARAM_SET_02 })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadAntitheftMapSelection",           0x22, DIA_C_U16_DID_AIVI_ANTITHEF_MAP_SELECTION, { (intptr_t) DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadWORM_ID",                         0x22, DIA_C_U16_DID_WORM_ID, { (intptr_t) DIA_PROP_VERSION_DATACARRIER_WORM_ID })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadVehiManECUHardwareNumber",        0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_ECU_HW_NR,       { (intptr_t) DIA_PROP_AIVI_VEH_MANUFACTURER_ECU_HW_NR       })
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadHWRefA",                          0x22, DIA_C_U16_DID_AIVI_HW_REF_A,       { (intptr_t) DIA_PROP_AIVI_HW_REF_A       })
#endif

   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_VehicleManufacurerSparePartNumber, "SrvHandler_ReadVehiManECUHardwareNumberRenault", 0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_R_NR, { (intptr_t) DIA_PROP_AIVI_VEH_MANUFACTURER_SPARE_PART_R_NR })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_VehicleManufacurerSparePartNumber, "SrvHandler_ReadVehiManECUHardwareNumberNissan",  0x22, DIA_C_U16_DID_AIVI_VEH_MANUFACTURER_SPARE_PART_N_NR, { (intptr_t) DIA_PROP_AIVI_VEH_MANUFACTURER_SPARE_PART_N_NR })

   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericWIFINameRead,"SrvHandlerGenericWIFINameRead",                  0x22, DIA_C_U16_DID_AIVI_WIFI_NAME, { (intptr_t) DIA_PROP_CM_WIFI_NAME_1, (intptr_t) DIA_PROP_CM_WIFI_NAME_2 })

   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefECORoute",                     0x22, DIA_C_U16_DID_AIVI_DEF_ECO_ROUTE, { (intptr_t) DIA_PROP_AIVI_DEF_ECO_ROUTE })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_ReadDefBTName",                       0x22, DIA_C_U16_DID_AIVI_DEF_BT_NAME, { (intptr_t) DIA_PROP_AIVI_DEF_BT_NAME })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadECUSparePartNumber",              0x22, DIA_C_U16_DID_RBCM_ECU_SPARE_PART_NUMBER,           { (intptr_t) DIA_PROP_CM_ECU_SPARE_PART_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadECUSerialNumber",                 0x22, DIA_C_U16_DID_RBCM_ECU_SERIAL_NUMBER,               { (intptr_t) DIA_PROP_CM_ECU_SERIAL_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadNaviUnit",                        0x22, DIA_C_U16_DID_AIVI_NAVI_UNIT,                       { (intptr_t) DIA_PROP_CM_NAVI_UNIT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadMainboardSparePartNumber",        0x22, DIA_C_U16_DID_RBCM_PCB_SPARE_PART_NUMBER,           { (intptr_t) DIA_PROP_CM_MAINBOARD_SPARE_PART_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadMainboardSerialNumber",           0x22, DIA_C_U16_DID_RBCM_PCB_SERIAL_NUMBER,               { (intptr_t) DIA_PROP_CM_MAINBOARD_SERIAL_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadECUSWBuildVersionLabel",          0x22, DIA_C_U16_DID_RBCM_ECU_SW_BUILD_VERSION_LABEL,      { (intptr_t) DIA_PROP_CM_ECU_SW_BUILD_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadBTSubModuleHWLoaderVersion",      0x22, DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_LOADER_VERSION,  { (intptr_t) DIA_PROP_VERSION_SW_BLUETOOTH_BOOTLOADER })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadNavigationSWVersion",             0x22, DIA_C_U16_DID_RBCM_NAVI_SW_VERSION,                 { (intptr_t) DIA_PROP_CM_NAVIGATION_SW_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,  "SrvHandler_ReadVariantID",                       0x22, DIA_C_U16_DID_CM_VARIANT_ID,                        { (intptr_t) DIA_PROP_CM_VARIANT_ID })


#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadLastDiagnosisError,"SrvHandler_ReadLastDiagnosisError",         0x22, DIA_C_U16_DID_LAST_DIAG_ERROR,                      { (intptr_t) DIA_PROP_CM_CONFIG_LAST_DIAG_ERROR })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_ReadAnonymousVIN,      "SrvHandler_ReadAnonymousVIN",               0x22, DIA_C_U16_DID_VIN_WMI_AND_VDS,                      { (intptr_t) NULL })
#endif

   //microphone
   {
      tU8 sessions[] = {0x60}; //Production

      //diagnosis via Audio
      //RTC-5990073 Cleanup Activitydia_ServiceHandler* pServiceHandlerMicAudio1 = OSAL_NEW dia_SrvHandlerMicrophoneConnectionInfo("dia_SrvHandlerMicrophoneConnectionInfo", 0x22, DIA_C_U16_DID_RBCM_MICROPHONE_CONNECTION_INFO_1, DIA_EN_MICROPHONE_1 );
      //RTC-5990073 Cleanup Activityif (pServiceHandlerMicAudio1)
      //RTC-5990073 Cleanup Activity{
      //RTC-5990073 Cleanup Activity   (void) pEngineCustomer->bAddServiceHandler(pServiceHandlerMicAudio1, sizeof(sessions)/sizeof(tU8), sessions, 0, NULL);

         //current measurement via Audio is impossible
      //RTC-5990073 Cleanup Activity   ((dia_SrvHandlerMicrophoneConnectionInfo*)pServiceHandlerMicAudio1)->SetCurrentMeasurementImpossible(TRUE);
      //RTC-5990073 Cleanup Activity}

      //diagnosis via Rvc
      dia_ServiceHandler* pServiceHandlerMicRvc1 = OSAL_NEW dia_SrvHandlerMicrophonePowerSupplyInfo("dia_SrvHandlerMicrophonePowerSupplyInfo", 0x22, DIA_C_U16_DID_RBCM_MIC_PS_INFO_1, DIA_EN_MICROPHONE_1 );
      if (pServiceHandlerMicRvc1)
      {
         (void) pEngineCustomer->bAddServiceHandler(pServiceHandlerMicRvc1, sizeof(sessions)/sizeof(tU8), sessions, 0, NULL);
      }
   }

   if ( dia_getProperty(DIA_PROP_CM_VARIANT_CODING,arVariantCoding, 32) == DIA_SUCCESS )
   {
      if((arVariantCoding[4] & 0x10) == 0x10 )
      {
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMRadioID",                     0x22, DIA_C_U16_DID_SXM_RADIO_ID, { (intptr_t) DIA_PROP_CM_SXM_SERIALNO_VER })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMSubModuleSWVersion",          0x22, DIA_C_U16_DID_SXM_SUBBMODULE_SW_VERSION, { (intptr_t) DIA_PROP_CM_SXM_SW_VER })
         ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentRead,   "SrvHandler_XMSubModuleHWVersion",          0x22, DIA_C_U16_DID_SXM_SUBBMODULE_HW_VERSION, { (intptr_t) DIA_PROP_CM_SXM_SXM_HW_VER })
      }
   }
#if !defined(VARIANT_S_FTR_ENABLE_RNAIVI) && !defined(VARIANT_S_FTR_ENABLE_RIVIE)
   ADD_NEW_SRVHDL(dia_SrvHandler_SecondaryOperationalReference) //only for scope1
#endif
   ADD_NEW_SRVHDL(dia_SrvHandler_ReadVehicleSnapShotData)
   ADD_NEW_SRVHDL(dia_SrvHandler_ReadVehicleTimeDomainData)


   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x2E (write data by identifier - Implement service for Production related Identification and configuration data)
   //
   ////////////////////////////////////////////////////////////////////////////

   ADD_NEW_SRVHDL(dia_AntitheftMapSelectionWrite)

   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWriteAIVI, "SrvHandler_WriteSystemInformationCommon",      0x2E, DIA_C_U16_DID_AIVI_SYSTEM_INFO_COMMON, { (intptr_t) DIA_PROP_AIVI_SYSTEM_INFO_COMMON })
  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,     "SrvHandler_WriteCameraSystem",                 0x2E, DIA_C_U16_DID_AIVI_CAMERA_SYSTEM, { (intptr_t) DIA_PROP_AIVI_CAMERA_SYSTEM })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWriteAIVI, "SrvHandler_WriteVehicleInformation",           0x2E, DIA_C_U16_DID_AIVI_SYSTEM_VEHICLE_INFO, { (intptr_t) DIA_PROP_AIVI_VEHICLE_INFO })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteECORoute",                     0x2E, DIA_C_U16_DID_AIVI_ECO_ROUTE, { (intptr_t) DIA_PROP_AIVI_ECO_ROUTE })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericBTNameWrite,  "SrvHandler_WriteBTName",                       0x2E, DIA_C_U16_DID_AIVI_BT_NAME, { (intptr_t) DIA_PROP_CM_BT_NAME, (intptr_t) AIVI_BT_NAME_LENGTH })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteConfigHashValue",              0x2E, DIA_C_U16_DID_AIVI_CONFIG_HASH_VALUE, { (intptr_t) DIA_PROP_AIVI_CONFIG_HASH_VALUE })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteConfigPartNumber",             0x2E, DIA_C_U16_DID_AIVI_CONFIG_PARTS_NUMBER, { (intptr_t) DIA_PROP_AIVI_CONFIG_PARTS_NUMBER })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigGyro",             0x2E, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GYRO, { (intptr_t) DIA_PROP_AIVI_SENSOR_CONFIG_GYRO })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigGNSS",             0x2E, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_GNSS, { (intptr_t) DIA_PROP_AIVI_SENSOR_CONFIG_GNSS })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigACC",              0x2E, DIA_C_U16_DID_AIVI_SENSOR_CONFIG_ACC, { (intptr_t) DIA_PROP_AIVI_SENSOR_CONFIG_ACC })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteFMAMTunerParameterSet",        0x2E, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteFMAMTunerParameterSet1",       0x2E, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_01, { (intptr_t) DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET_01 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteFMAMTunerParameterSet2",       0x2E, DIA_C_U16_DID_AIVI_FMAM_TUNER_PARAM_SET_02, { (intptr_t) DIA_PROP_AIVI_FMAM_TUNER_PARAM_SET_02 })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteAntennaParameterSet",          0x2E, DIA_C_U16_DID_AIVI_ANTENNA_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_ANTENNA_PARAM_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDABParameterSet",              0x2E, DIA_C_U16_DID_AIVI_DAB_SET, { (intptr_t) DIA_PROP_AIVI_DAB_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteGenericTunerParameterSet",     0x2E, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteGenericTunerParameterSet1",    0x2E, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_01, { (intptr_t) DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET_01 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteGenericTunerParameterSet2",    0x2E, DIA_C_U16_DID_AIVI_GENERIC_TUNER_PARAM_SET_02, { (intptr_t) DIA_PROP_AIVI_GENERIC_TUNER_PARAM_SET_02 })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteHDParameterSet",               0x2E, DIA_C_U16_DID_AIVI_HD_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_HD_PARAM_SET })
// ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteWifiName",                     0x2E, DIA_C_U16_DID_AIVI_WIFI_NAME, { (intptr_t) DIA_PROP_AIVI_WIFI_NAME })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericWIFINameWrite,"SrvHandlerGenericWIFINameWrite",               0x2E, DIA_C_U16_DID_AIVI_WIFI_NAME, { (intptr_t) DIA_PROP_CM_WIFI_NAME_1, (intptr_t) AIVI_WIFI_NAME_1_LENGTH, (intptr_t) DIA_PROP_CM_WIFI_NAME_2, (intptr_t) AIVI_WIFI_NAME_2_LENGTH })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteAudioParameterSet",            0x2E, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_AUDIO_PARAM_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteAudioParameterSet1",           0x2E, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_01, { (intptr_t) DIA_PROP_AIVI_AUDIO_PARAM_SET_01 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteAudioParameterSet2",           0x2E, DIA_C_U16_DID_AIVI_AUDIO_PARAM_SET_02, { (intptr_t) DIA_PROP_AIVI_AUDIO_PARAM_SET_02 })

   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteAudioSourceOffsetIn",          0x2E, DIA_C_U16_DID_AIVI_AUDIO_SOURCE_OFFSET_IN, { (intptr_t) DIA_PROP_AID_AUDIO_SOURCE_OFFSET })

   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteBTName",                       0x2E, DIA_C_U16_DID_RBCM_BT_NAME,           { (intptr_t) DIA_PROP_CM_BT_NAME })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCustomerECUPartNumber",        0x2E, DIA_C_U16_DID_RBCM_CUSTOMER_ECU_PART_NUMBER, { (intptr_t) DIA_PROP_CM_CUSTOMER_ECU_PART_NR })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSWUPD_VariantInfo",            0x2E, DIA_C_U16_DID_RBCM_CUSTOMER_SWUP_VARIANT_INFO, { (intptr_t) DIA_PROP_SW_UPD_VARIANT_INFO })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDimmingParametSet",            0x2E, DIA_C_U16_DID_RBCM_DIMMING_PARAMETER_SET,    { (intptr_t) DIA_PROP_CM_DIMMING_PARAMETER_SET })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteKeyIlluminationAlignmentCoeff",0x2E, DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_ALIGNMENT,{ (intptr_t) DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteKeyIlluminationAlignmentCoeff2",0x2E, DIA_C_U16_DID_AIVI_KEY_ILLUMINATION_ALIGNMENT_2,{ (intptr_t) DIA_PROP_AIVI_KEY_ILLUMINATION_ALIGNMENT_COEFF2 })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDispIlluminationAlignmentCoeff",0x2E, DIA_C_U16_DID_AIVI_DISP_ILLUMINATION_ALIGNMENT,{ (intptr_t) DIA_PROP_AIVI_DISP_ILLUMINATION_ALIGNMENT_COEFF })

  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteGenTunerParamSet",             0x2E, DIA_C_U16_DID_RBCM_GENERIC_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_GENERIC_TUNER_PARAM_SET })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteAntennaParamSet",              0x2E, DIA_C_U16_DID_RBCM_ANTENNA_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_ANTENNA_PARAMETER_SET })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteFmAmTunerParamSet",            0x2E, DIA_C_U16_DID_RBCM_FM_AM_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_FM_AM_TUNER_PARAMETER_SET })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDAB_Parameter_Set",            0x2E, DIA_C_U16_DID_RBCM_DAB_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_DAB_TUNER_PARAMETER_SET })

   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteNavDataCopyProtectionSecEccKey",0x2E, DIA_C_U16_DID_NAV_DATA_COPY_PROTECTION_SEC_ECC_KEY, { (intptr_t) DIA_PROP_CM_NAVI_DATA_SEC_KEY })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteNaviDefaultPosition",          0x2E, DIA_C_U16_DID_NAV_DEFAULT_POSITION, { (intptr_t) DIA_PROP_CM_NAVIGATION_DEFAULT_POSITION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigurationGNSS",      0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_GNSS, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_GNSS })
 //  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCMVariantCoding",              0x2E, DIA_C_U16_DID_CM_VARIANT_CODING, { (intptr_t) DIA_PROP_CM_VARIANT_CODING, (intptr_t) DIA_PROP_CM_VARIANT_CODING_SCC })
// ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCMExtendedVariantCoding", 0x2E, DIA_C_U16_DID_CM_EXTENDED_VARIANT_CODING, { (intptr_t) DIA_PROP_CM_EXTENDED_VARIANT_CODING })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigurationGyro",      0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_GYRO, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_GYRO })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSensorConfigurationACC",       0x2E, DIA_C_U16_DID_SENSOR_CONFIGURATION_ACC, { (intptr_t) DIA_PROP_CM_SENSOR_CONFIG_ACC })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCMConfigInfo",                 0x2E, DIA_C_U16_DID_CM_CONFIGURATION_INFO, { (intptr_t) DIA_PROP_CM_CONF_INFO })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteHDParameterSet",               0x2E, DIA_C_U16_DID_RBCM_HD_PARAMETER_SET, { (intptr_t) DIA_PROP_CM_HD_PARAMETER_SET })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteThermalTempThresholds",        0x2E, DIA_C_U16_DID_RBCM_THERMAL_MGNT_TEMPERATURE_THRESHOLDS, { (intptr_t) DIA_PROP_THERMALMNGMT_TEMPERATURE_THRESHOLDS })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteWiFiName_1",                   0x2E, DIA_C_U16_DID_RBCM_WIFI_NAME_1,        { (intptr_t) DIA_PROP_CM_WIFI_NAME_1 })
  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteWiFiName_2",                   0x2E, DIA_C_U16_DID_RBCM_WIFI_NAME_2,        { (intptr_t) DIA_PROP_CM_WIFI_NAME_2 })

   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSystemInformationCommon",   0x2E, DIA_C_U16_DID_AIVI_DEF_SYSTEM_INFO_COMMON, { (intptr_t) DIA_PROP_AIVI_DEF_SYSTEM_INFO_COMMON })
  // ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefCameraSystem",              0x2E, DIA_C_U16_DID_AIVI_DEF_CAMERA_SYSTEM, { (intptr_t) DIA_PROP_AIVI_DEF_CAMERA_SYSTEM })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefVehicleInformation",        0x2E, DIA_C_U16_DID_AIVI_DEF_SYSTEM_VEHICLE_INFO, { (intptr_t) DIA_PROP_AIVI_DEF_VEHICLE_INFO })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefECORoute",                  0x2E, DIA_C_U16_DID_AIVI_DEF_ECO_ROUTE, { (intptr_t) DIA_PROP_AIVI_DEF_ECO_ROUTE })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericBTNameWrite,  "SrvHandler_WriteDefBTName",                    0x2E, DIA_C_U16_DID_AIVI_DEF_BT_NAME, { (intptr_t) DIA_PROP_AIVI_DEF_BT_NAME, (intptr_t) AIVI_BT_NAME_LENGTH })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefConfigurationHashValue",    0x2E, DIA_C_U16_DID_AIVI_DEF_CONFIG_HASH_VALUE, { (intptr_t) DIA_PROP_AIVI_DEF_CONFIG_HASH_VALUE })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefConfigurationPartNumber",   0x2E, DIA_C_U16_DID_AIVI_DEF_CONFIG_PARTS_NUMBER, { (intptr_t) DIA_PROP_AIVI_DEF_CONFIG_PARTS_NUMBER })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSensorConfigGyro",          0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GYRO, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GYRO })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSensorConfigGNSS",          0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_GNSS, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_GNSS })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSensorConfigACC",           0x2E, DIA_C_U16_DID_AIVI_DEF_SENSOR_CONFIG_ACC, { (intptr_t) DIA_PROP_AIVI_DEF_SENSOR_CONFIG_ACC })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefFMAMTunerParamSet",         0x2E, DIA_C_U16_DID_AIVI_DEF_FMAM_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_FMAM_TUNER_PARAM_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefAntennaParamSet",           0x2E, DIA_C_U16_DID_AIVI_DEF_ANTENNA_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_ANTENNA_PARAM_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefDABParameterSet",           0x2E, DIA_C_U16_DID_AIVI_DEF_DAB_SET, { (intptr_t) DIA_PROP_AIVI_DEF_DAB_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefGenericTunerParamSet",      0x2E, DIA_C_U16_DID_AIVI_DEF_GENERIC_TUNER_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_GENERIC_TUNER_PARAM_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefHDParamSet",                0x2E, DIA_C_U16_DID_AIVI_DEF_HD_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_HD_PARAM_SET })
// ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefWifiName",                  0x2E, DIA_C_U16_DID_AIVI_DEF_WIFI_NAME, { (intptr_t) DIA_PROP_AIVI_DEF_WIFI_NAME })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericWIFINameWrite,"SrvHandler_WriteDefWifiName",                  0x2E, DIA_C_U16_DID_AIVI_DEF_WIFI_NAME, { (intptr_t) DIA_PROP_AIVI_DEF_WIFI_NAME_1, (intptr_t) AIVI_WIFI_NAME_1_LENGTH, (intptr_t) DIA_PROP_AIVI_DEF_WIFI_NAME_2, (intptr_t) AIVI_WIFI_NAME_1_LENGTH })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefAntiThefMapSelection",      0x2E, DIA_C_U16_DID_AIVI_DEF_ANTITHEF_MAP_SELECTION, { (intptr_t) DIA_PROP_AIVI_DEF_ANTITHEF_MAP_SELECTION })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefAudioParamSet",             0x2E, DIA_C_U16_DID_AIVI_DEF_AUDIO_PARAM_SET, { (intptr_t) DIA_PROP_AIVI_DEF_AUDIO_PARAM_SET })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefAcousticParam",             0x2E, DIA_C_U16_DID_AIVI_DEF_ACOUSTIC_PARAM, { (intptr_t) DIA_PROP_AIVI_DEF_ACOUSTIC_PARAM })
  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefPhoneECNRWBS",              0x2E, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_WBS, { (intptr_t) DIA_PROP_AIVI_DEF_PHONE_ECNR_WBS })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefPhoneECNRNBS",              0x2E, DIA_C_U16_DID_AIVI_DEF_PHONE_ECNR_NBS, { (intptr_t) DIA_PROP_AIVI_DEF_PHONE_ECNR_NBS })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefMEXConfig",                 0x2E, DIA_C_U16_DID_AIVI_DEF_MEX_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_MEX_CONFIG })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefFactoryMode",               0x2E, DIA_C_U16_DID_AIVI_DEF_FACTORY_MODE, { (intptr_t) DIA_PROP_AIVI_DEF_FACTORY_MODE })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefConnectivityConfig",        0x2E, DIA_C_U16_DID_AIVI_DEF_CONNECTIVITY_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_CONNECTIVITY_CONFIG })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefHmiConfig",                 0x2E, DIA_C_U16_DID_AIVI_DEF_HMI_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_HMI_CONFIG })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefSoundVolConfig",            0x2E, DIA_C_U16_DID_AIVI_DEF_SOUND_VOLUME_CONFIG, { (intptr_t) DIA_PROP_AIVI_DEF_SOUND_VOLUME_CONFIG })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteDefDrmTunerParameterSet",      0x2E, DIA_C_U16_DID_AIVI_DEF_DRM_TUNER_PARAMETER_SET, { (intptr_t) DIA_PROP_AIVI_DEF_DRM_TUNER_PARAMETER_SET })
#ifdef VARIANT_P_DIAGNOSIS_COMMON_DIAG_CMPRODUCTION
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_CustomerAndBuildSWVersion_Write,   "SrvHandler_CustomerAndBuildSWVersion_Write", 0x2E, DIA_C_U16_DID_CM_CUSTOMER_AND_BUILD_SW_VERSION, { (intptr_t) DIA_PROP_CM_ECU_SW_VERSION, (intptr_t) DIA_PROP_CM_ECU_SW_BUILD_VERSION})
#endif
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteECUSparePartNumber",           0x2E, DIA_C_U16_DID_RBCM_ECU_SPARE_PART_NUMBER, { (intptr_t) DIA_PROP_CM_ECU_SPARE_PART_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteECUSerialNumber",              0x2E, DIA_C_U16_DID_RBCM_ECU_SERIAL_NUMBER, { (intptr_t) DIA_PROP_CM_ECU_SERIAL_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteNaviUnit",                     0x2E, DIA_C_U16_DID_AIVI_NAVI_UNIT, { (intptr_t) DIA_PROP_CM_NAVI_UNIT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteECUHWVersion",                 0x2E, DIA_C_U16_DID_RBCM_ECU_HW_VERSION, { (intptr_t) DIA_PROP_CM_ECU_HW_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteMainboardSparePartNumber",     0x2E, DIA_C_U16_DID_RBCM_PCB_SPARE_PART_NUMBER, { (intptr_t) DIA_PROP_CM_MAINBOARD_SPARE_PART_NR })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteMainboardSerialNumber",        0x2E, DIA_C_U16_DID_RBCM_PCB_SERIAL_NUMBER, { (intptr_t) DIA_PROP_CM_MAINBOARD_SERIAL_NR })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteImmobilizer",                  0x2E, 0x3200, { (intptr_t) DIA_PROP_CM_IMMOBILIZER })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSpeedLockout",                 0x2E, DIA_C_U16_DID_AIVI_SPEED_LOCKOUT, { (intptr_t) DIA_PROP_AIVI_SPEED_LOCKOUT })
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite   ,"SrvHandler_WriteNextTemperatureHistogram",0x2E, DIA_C_U16_DID_RBCM_WRITE_NEXT_TEMPERATURE_HISTOGRAM, { (intptr_t) DIA_PROP_NEXT_TEMPERATURE_HISTOGRAM })

   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerVINIdentWrite,       "SrvHandler_WriteVehicleIdentNumber",           0x2E, DIA_C_U16_DID_AIVI_VIN,                    { (intptr_t) DIA_PROP_AIVI_VIN }) //WriteDataByIdentifier - VIN
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteMEXConfig",                    0x2E, DIA_C_U16_DID_AIVI_MEX_CONFIG,             { (intptr_t) DIA_PROP_AIVI_MEX_CONFIG })
  //RTC-5990073 Cleanup Activity ADD_NEW_SRVHDL_NAME_SID_DID_PROPID(dia_SrvHandler_WriteFactoryMode,    "SrvHandler_WriteFactoryMode",                  0x2E, DIA_C_U16_DID_AIVI_FACTORY_MODE,           DIA_PROP_AIVI_FACTORY_MODE )
   //RTC-5990073 Cleanup ActivityADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteConnectivityConfig",           0x2E, DIA_C_U16_DID_AIVI_CONNECTIVITY_CONFIG,    { (intptr_t) DIA_PROP_AIVI_CONNECTIVITY_CONFIG })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteHmiConfig",                    0x2E, DIA_C_U16_DID_AIVI_HMI_CONFIG,             { (intptr_t) DIA_PROP_AIVI_HMI_CONFIG })
   //ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteSoundVolConfig",               0x2E, DIA_C_U16_DID_AIVI_SOUND_VOLUME_CONFIG,    { (intptr_t) DIA_PROP_AIVI_SOUND_VOLUME_CONFIG })

   // Center CM C-19
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WritecustomerECUHWVersion",         0x2E, DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION,        { (intptr_t) DIA_PROP_CENTER_CMC_19_CUSTOMER_ECU_HW_VERSION })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteCustomerSparePartNumber",      0x2E, DIA_C_U16_DID_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER,     { (intptr_t) DIA_PROP_CENTER_CMC_19_CUSTOMER_SPARE_PART_NUMBER })
#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_CONCEPT
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_GenericVinOdometerWrite,   "SrvHandler_WriteVINOdometer",           0x2E, DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER,                   { (intptr_t) DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_GenericVinOdometerWrite,   "SrvHandler_WriteVINOdometerLimit",      0x2E, DIA_C_U16_DID_CENTER_CMC_19_VIN_ODOMETER_LIMIT,             { (intptr_t) DIA_PROP_CENTER_CMC_19_VIN_ODOMETER_COUNTER_LIMIT })
   ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandler_VinCurrentWrite,    "dia_SrvHandler_VinCurrentWrite",               0x2E, DIA_C_U16_DID_CENTER_CMC_19_VIN_CURRENT,                    { (intptr_t) DIA_PROP_CENTER_CMC_19_VIN_CURRENT })
#endif  
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WriteConfigurationFingerprint",     0x2E, DIA_C_U16_DID_CENTER_CMC_19_CONFIGURATION_FINGERPRINT,      { (intptr_t) DIA_PROP_CENTER_CMC_19_FINGERPRINT_CONFIG  })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_CDWritePNMGroup10Configuration",    0x2E, DIA_C_U16_DID_CENTER_CMC_19_PNM_GROUP10_CONFIG,     { (intptr_t) DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG})
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_CDDefWritePNMGroup10Configuration", 0x2E, DIA_C_U16_DID_CENTER_CMC_19_CD_DEF_NVM_GROUP10_CONFIG,     { (intptr_t) DIA_PROP_CENTER_CMC_19_CD_PNM_GROUP_10_CONFIG })
  ADD_NEW_SRVHDL_NAME_SID_DID_ARGLIST(dia_SrvHandlerGenericIdentWrite,   "SrvHandler_WritecustomerDTCConfiguration",     0x2E, DIA_C_U16_DID_CENTER_CMC_19_DTC_CONFIGURATION,        { (intptr_t) DIA_PROP_CENTER_CMC_19_DTC_CONFIG })



   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x2F (ioctrl by identifier);
   //
   // concrete ioctrls are created in method dia_FactoryPluginIOControls()
   //
   ////////////////////////////////////////////////////////////////////////////
   //ADD_NEW_SRVHDL(dia_SrvHandlerGenericIOCtrlByIdentifier)
   ADD_NEW_SRVHDL(dia_SrvHandlerGenericIOCtrlByIdentifierIVI)

   // Special handling for IOControl ADR3 SetSignalQuality which is simply routed to the Tuner via Container message
//   ADD_NEW_SRVHDL(dia_IOCtrlADR3SetSignalQuality)

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x31 (routine control)
   //
   // concrete routines are created in method dia_FactoryPluginRoutineControls()
   //
   ////////////////////////////////////////////////////////////////////////////

   // generic routine control service handler for CM production diagnosis (really UDS conform)
//   ADD_NEW_SRVHDL(dia_SrvHandlerGenericRoutineCtrl)
#if 0 //STC2HI: TODO
   // generic routine control service handler for Nissan customer diagnosis (not really UDS conform; differen message format))
   ADD_NEW_SRVHDL(dia_SrvHandlerGenericRoutineCtrlNissan)

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x3B (write data by local identifier)
   //
   ////////////////////////////////////////////////////////////////////////////

   ADD_SRVHDL_NISSAN_03(dia_VehicleInfoWrite,                                                                                 0x3B, 0x12, DIA_PROP_NISSAN_VEHICLE_INFO,        DIA_SUPPORTED_LOCID_DATA_C_BIT6)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigItemWrite,"SrvHandler_CAMERA_SYSTEM",                  0x3B, 0x13, DIA_PROP_NISSAN_CAMERA_SYSTEM,       DIA_SUPPORTED_LOCID_DATA_C_BIT5)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigItemWrite,"SrvHandler_BTNAME",                         0x3B, 0x14, DIA_PROP_NISSAN_BTNAME,              DIA_SUPPORTED_LOCID_DATA_C_BIT4)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigItemWrite,"SrvHandler_ECOROUTE",                       0x3B, 0x16, DIA_PROP_NISSAN_ECOROUTE,            DIA_SUPPORTED_LOCID_DATA_C_BIT2)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigItemWrite,"SrvHandler_SDS",                            0x3B, 0x17, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_C_BIT1)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigItemWrite,"SrvHandler_PHONE",                          0x3B, 0x19, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_D_BIT7)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigItemWrite,"SrvHandler_DAB",                            0x3B, 0x1D, DIA_PROP_NISSAN_DAB_SET,             DIA_SUPPORTED_LOCID_DATA_D_BIT3)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigItemWrite,"SrvHandler_PARTS_NUMBER",                   0x3B, 0x1C, DIA_PROP_NISSAN_PARTS_NUMBER,        DIA_SUPPORTED_LOCID_DATA_D_BIT4)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigItemWrite,"SrvHandler_PARTS_NUMBER",                   0x3B, 0x1F, DIA_PROP_NISSAN_PARTS_NUMBER,        DIA_SUPPORTED_LOCID_DATA_D_BIT1)

   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_THREE_PARAM_ARGLIST(dia_GenericConfigItemWrite,"SrvHandler_SYSTEM_CONFIG2",      0x3B, 0x15, DIA_PROP_NISSAN_SYSTEM_CONFIG2,      DIA_SUPPORTED_LOCID_DATA_C_BIT3, DIA_EN_TESTCONDITION_CONFIG_UPDATE_NISSAN_SYSTEM_CONFIG2,      { (intptr_t) DIA_PROP_NISSAN_SYSTEM_CONFIG2 })
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_THREE_PARAM_ARGLIST(dia_GenericConfigItemWrite,"SrvHandler_SYSTEM_CONFIG",       0x3B, 0x18, DIA_PROP_NISSAN_SYSTEM_CONFIG,       DIA_SUPPORTED_LOCID_DATA_C_BIT0, DIA_EN_TESTCONDITION_CONFIG_UPDATE_NISSAN_SYSTEM_CONFIG,       { (intptr_t) DIA_PROP_NISSAN_SYSTEM_CONFIG })
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_THREE_PARAM_ARGLIST(dia_GenericConfigItemWrite,"SrvHandler_FMAMTUNER_PARAM_SET", 0x3B, 0x1A, DIA_PROP_NISSAN_FMAMTUNER_PARAM_SET, DIA_SUPPORTED_LOCID_DATA_D_BIT6, DIA_EN_TESTCONDITION_CONFIG_UPDATE_NISSAN_FMAMTUNER_PARAM_SET, { (intptr_t) DIA_PROP_NISSAN_FMAMTUNER_PARAM_SET })
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_THREE_PARAM_ARGLIST(dia_GenericConfigItemWrite,"SrvHandler_AUDIO_PARAM_SET",     0x3B, 0x1B, DIA_PROP_NISSAN_AUDIO_PARAM_SET,     DIA_SUPPORTED_LOCID_DATA_D_BIT5, DIA_EN_TESTCONDITION_CONFIG_UPDATE_NISSAN_AUDIO_PARAM_SET,     { (intptr_t) DIA_PROP_NISSAN_AUDIO_PARAM_SET })
#ifdef __ENABLE_FEATURE_NISSAN_CONFIG_SPLIT_LONG_LIDS__
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x21, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_A_BIT7)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x22, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_A_BIT6)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x23, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_A_BIT5)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x24, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_A_BIT4)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x25, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_A_BIT3)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x26, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_A_BIT2)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x27, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_A_BIT1)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x28, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_A_BIT0)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_SDS",                        0x3B, 0x29, DIA_PROP_NISSAN_SDS,                 DIA_SUPPORTED_LOCID_DATA_B_BIT7)

   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x2A, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_B_BIT6)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x2B, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_B_BIT5)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x2C, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_B_BIT4)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x2D, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_B_BIT3)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x2E, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_B_BIT2)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x2F, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_B_BIT1)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x30, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_B_BIT0)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x31, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_C_BIT7)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_PHONE",                      0x3B, 0x32, DIA_PROP_NISSAN_PHONE,               DIA_SUPPORTED_LOCID_DATA_C_BIT6)

   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_AUDIO",                      0x3B, 0x34, DIA_PROP_NISSAN_AUDIO_PARAM_01,     DIA_SUPPORTED_LOCID_DATA_C_BIT4)
   ADD_NEW_NISSAN_SRVHDL_NISSAN_NAME_SID_DID_02_PARAM(dia_GenericConfigLongItemWrite,"SrvHandler_AUDIO",                      0x3B, 0x35, DIA_PROP_NISSAN_AUDIO_PARAM_02,     DIA_SUPPORTED_LOCID_DATA_C_BIT3)
#endif

#endif //STC2HI: TODO

   ////////////////////////////////////////////////////////////////////////////
   //
   // Service 0x85 (control fault memory)
   //
   ////////////////////////////////////////////////////////////////////////////

   ADD_NEW_SRVHDL_DID(dia_SrvHandlerGenericControlFaultMemory, 1)
   ADD_NEW_SRVHDL_DID(dia_SrvHandlerGenericControlFaultMemory, 2)

   ////////////////////////////////////////////////////////////////////////////
   //
   // Misc. (e.g. service handlers associated with multiple services)
   //
   ////////////////////////////////////////////////////////////////////////////

#if 0 //STC2HI: TODO

   // read supported local identifiers (NISSAN)
   ADD_NEW_SRVHDL(dia_ReadSupportedLocalIdentifiers)

#endif //STC2HI: TODO

   DIA_TR_SM("#####################################################");
   DIA_TR_SM("# QUERY FOR ADR3 SESSION ...");
   DIA_TR_SM("#####################################################");

   // install handler that forwards ADR3 requests to the ADR3 while ADR3 session is active
   dia_Session* pSessionADR = 0;
   if ( pEngineCustomer->querySession(&pSessionADR,0x61) == DIA_SUCCESS )
   {
      DIA_TR_SM("#####################################################");
      DIA_TR_SM("# ADDING SERVICES FOR ADR3 SESSION ...");
      DIA_TR_SM("#####################################################");

      ADD_SRVHDL_FOR_SPECIFIC_SESSION((dia_SessionADR*) pSessionADR, arSessionsProdADR)
   }

   DIA_TR_SM("#####################################################");
   DIA_TR_SM("# QUERY FOR SUBSYSTEM SESSION ...");
   DIA_TR_SM("#####################################################");

   //! install handler that forwards subsystem diagnostic requests to 
   //! the connected subsystem while subsystem session is active
   dia_Session* pSessionSubsystem = 0;
   if ( DIA_SUCCESS == pEngineCustomer->querySession(&pSessionSubsystem, DIA_C_U8_UDS_SESSION_SUBSYSTEM ))
   {
      DIA_TR_SM("#####################################################");
      DIA_TR_SM("# ADDING SERVICES FOR SUBSYSTEM SESSION ...");
      DIA_TR_SM("#####################################################");

      dia_SubsystemDiagnosisRequestRouter *pSubsystemDiagnosisRequestRouter = new dia_SubsystemDiagnosisRequestRouter();

      ADD_SRVHDL_FOR_SPECIFIC_SESSION(pSubsystemDiagnosisRequestRouter, arSessionSubsystem)
   }

   ADD_NEW_SRVHDL(dia_SrvHandler_XCPMonitoring)
   return DIA_SUCCESS;
}

/*lint -restore */

//------------------------------------------------------------------------------

dia_Session*
dia_FactoryProjectPlugin::makeSession ( tU8 sessionID, dia_EngineServer& rEngine )
{
   dia_tclFnctTrace oTrace("dia_FactoryProjectPlugin::makeSession");

   dia_Session* pSession = 0;

   switch ( sessionID )
   {
   case 0x61:
      {
         dia_SessionADR* pSessionADR = OSAL_NEW dia_SessionADR(sessionID,rEngine);
         if ( pSessionADR )
         {
            pSessionADR->initialize();
            pSession = pSessionADR;
         }
      }
      break;
   case DIA_C_U8_UDS_SESSION_SUBSYSTEM:
      {
    	  dia_SessionSubsystem* pSessionSubsystem = OSAL_NEW dia_SessionSubsystem(sessionID,rEngine);
         if ( pSessionSubsystem )
         {
             //pSessionSubsystem->initialize();
             pSession = pSessionSubsystem;
         }
      }
      break;
   default:
      pSession = OSAL_NEW dia_Session(sessionID,rEngine);
      break;
   }

   return pSession;
}

//------------------------------------------------------------------------------

dia_IDriver*
dia_FactoryProjectPlugin::makeDriver ( dia_enDriverType driverID )
{
   dia_IDriver* pDriver = 0;

   switch ( driverID )
   {
   case DIA_EN_DRVTYPE_TRACE:
      {
         std::map<dia_enDriverType,dia_IDriver*>::iterator iter = mDriverMap.find(DIA_EN_DRVTYPE_TRACE);
         if ( iter != mDriverMap.end() )
         {
            pDriver = iter->second;
         }
         else
         {
            dia_OSALDriver* pDrvTrace = OSAL_NEW dia_OSALDriver(OSAL_C_STRING_DEVICE_TRACE);
            dia_OSALDriverTrace* pDrvTraceDecorator = OSAL_NEW dia_OSALDriverTrace(pDrvTrace);
            mDriverMap[DIA_EN_DRVTYPE_TRACE] = pDrvTraceDecorator;
            pDriver = pDrvTraceDecorator;
            mDriverRep.push_back(pDrvTraceDecorator);
            mDriverRep.push_back(pDrvTrace);
            pDrvTrace = 0;          //lint !e423 Warning: no creation of memory leak in assignment, because object is destroyed in tearDown method
            pDrvTraceDecorator = 0; //lint !e423 Warning: no creation of memory leak in assignment, because object is destroyed in tearDown method
         } //lint !e438 Warning: last value assigned to variable pDrvTrace and pDrvTraceDecorator not used
      }
      break;

   default:
      break;
   }

   return pDriver;
}

//------------------------------------------------------------------------------

dia_ITimer*
dia_FactoryProjectPlugin::makeTimer ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryProjectPlugin::makeTimer");
#if 0
   dia_Timer* pTimer = OSAL_NEW dia_Timer;
   if ( pTimer )
   {
      dia_OSALTimer* pOSALTimer = OSAL_NEW dia_OSALTimer(*pTimer);
      if ( pOSALTimer )
      {
         pTimer->assignBody(*pOSALTimer);
      }
      else
      {
         OSAL_DELETE pTimer;
         pTimer = 0;
      }
   }

   return pTimer;
#endif
   return 0;
}
