/*!
 * \file       dia_UdsHelpersSpm.cpp
 *
 * \brief      Functions to convert between UDS- and diag-format for SPM-specific types
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/generic/dia_ToUdsHelpers.h"
#include "common/services/uds/production/dia_UdsHelpersSpm.h"

namespace dia {
bool dia_diaToUds(dia_tSpmTimeDate const &dia, std::vector<tU8>& uds) {
   dia_u16ToUds((uint16_t)dia.mYear, uds);
   dia_u8ToUds(dia.mMonth, uds);
   dia_u8ToUds(dia.mDay, uds);
   dia_u8ToUds(dia.mHour, uds);
   dia_u8ToUds(dia.mMinute, uds);
   dia_u8ToUds(dia.mSecond, uds);
   return true;
}

// assemble answer
bool dia_diaToUds(dia_tSpmSVPSwVersionInfo const &dia, std::vector<tU8>& uds) {
   dia_stringToUds(dia.mCustomerVersion.c_str(), dia.mCustomerVersion.size(), dia.mCustomerVersion.size(), uds);
   dia_u8ToUds('_', uds);
   dia_stringToUds(dia.mBuildVersion.c_str(), dia.mBuildVersion.size(), dia.mBuildVersion.size(), uds);
   dia_u8ToUds('_', uds);
   dia_stringToUds(dia.mBuildVersionLabel.c_str(), dia.mBuildVersionLabel.size(), dia.mBuildVersionLabel.size(), uds);
   //zero-terminate
   dia_u8ToUds(0, uds);
   return true;
}


bool dia_diaToUds(dia_tSpmResetCounterStatus  const &dia, std::vector<tU8>& uds) {
   dia_u8ToUds(dia.mLastResetReason, uds);
   dia_u32ToUds(dia.mApApplicationError, uds);
   dia_u32ToUds(dia.mApSoftware, uds);
   dia_u32ToUds(dia.mApEcuReset, uds);
   dia_u32ToUds(dia.mApDownload, uds);
   dia_u32ToUds(dia.mApDownloadError, uds);
   dia_u32ToUds(dia.mApOvertemperature, uds);
   dia_u32ToUds(dia.mApUser, uds);
   dia_u32ToUds(dia.mApLcmIntern, uds);
   dia_u32ToUds(dia.mApWarmstartCount, uds);
   dia_u32ToUds(dia.mApPowerOnCount, uds);
   dia_u32ToUds(dia.mApPowerLossCount, uds);
   dia_u32ToUds(dia.mApPowerOffCount, uds);
   dia_u32ToUds(dia.mApSccCount, uds);
   dia_u32ToUds(dia.mApUnknownCount, uds);
   dia_u32ToUds(dia.mSccHwWdtCount, uds);
   dia_u32ToUds(dia.mSccPowerOnCount, uds);
   dia_u32ToUds(dia.mSccColdstartCount, uds);
   dia_u32ToUds(dia.mSccAppmodeChangeCount, uds);
   dia_u32ToUds(dia.mSccDuringLpwCount, uds);
   dia_u32ToUds(dia.mSccDuringPllOszCount, uds);
   dia_u32ToUds(dia.mSccDuringSWCount, uds);
   dia_u32ToUds(dia.mSccWarmstartCount, uds);

   return true;
}

bool dia_diaToUds(dia_tSpmSVPSubStateElement  const &dia, std::vector<tU8>& uds) {
   dia_u32ToUds(dia.mMask, uds);
   dia_u32ToUds(dia.mData, uds);

   return true;
}


bool dia_diaToUds(dia_tSpmSVPStateHistoryElement  const &dia, std::vector<tU8>& uds) {
   dia_diaToUds(dia.mTimeDate, uds);
   dia_u32ToUds(dia.mSystemState, uds);
   dia_u8ToUds(dia.mEntryType, uds);
   dia_u32ToUds(dia.mWakeUpReason, uds);
   dia_u8ToUds(dia.mResetReason, uds);
   DIA_VEC_TO_UDS(dia_tSpmSVPSubStateElement, dia.mSubStatesList, uds, 3);

   return true;
}

bool dia_diaToUds(dia_tSpmStatisticData const &dia, std::vector<tU8>& uds) {
   dia_u32ToUds(dia.mMaxValue, uds);
   dia_u32ToUds(dia.mAvgValue, uds);
   dia_u32ToUds(dia.mMinValue, uds);

   return true;
}

bool dia_diaToUds(dia_eSpmSystemState const &dia, std::vector<tU8>& uds) {
   
   uint32_t udsState=(uint32_t)dia;
   dia_u32ToUds(udsState, uds);
   return true;
}

bool dia_diaToUds(dia_tSpmSVPWakeupReasonElement  const &dia, std::vector<tU8>& uds) {
   dia_diaToUds(dia.mTimeDate, uds);
   dia_u32ToUds(dia.mReason, uds);
   return true;
}

bool dia_diaToUds(dia_tSpmSVPResetElement  const &dia, std::vector<tU8>& uds) {
   dia_diaToUds(dia.mTimeDate, uds);
   dia_u8ToUds(dia.mReason, uds);
   return true;
}


}
