/**
 * \file    dia_SrvHandler_WriteDataByMemory.h
 *
 * \brief   This file contains the definition of the dia_SrvHandler_WriteDataByMemory class,
 *          that provides a generic service handler that can be used to process
 *          write requests for the ConfigManager.
 *
 * \author  shw2abt
 * \date    2012/05/04
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef dia_SrvHandler_WriteDataByMemory_H_
#define dia_SrvHandler_WriteDataByMemory_H_

/**
 * \class   dia_SrvHandler_WriteDataByMemory
 *
 * \brief   Generic service handler to process Identification request
 *
 *          This class provides a generic service handler that can be used to process
 *          identification requests that need to write one or more properties into
 *          the ConfigManager module.
 *
 * \ingroup diaServicesCommon
 */

class dia_SrvHandler_WriteDataByMemory
    : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_WriteDataByMemory);

public:
   /**
    *
    * \brief      class constructor
    *
    * \return     none
    */
   dia_SrvHandler_WriteDataByMemory ( tVoid );

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandler_WriteDataByMemory ( tVoid );

   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    *
    * \return     none
    */
   virtual tVoid vProcessRequest ( const std::vector<tArgsType>& vecArgs );
};

#endif /* dia_SrvHandler_WriteDataByMemory_H_ */
