/*
 * dia_SrvHandler_WriteDataByMemory.cpp
 *
 *  Created on: 08.05.2012
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

// TTFis: DIA_REQ UDS 08 3D 12 00 01 02 14 15
#ifndef dia_SrvHandler_WriteDataByMemory_H_
#include "dia_SrvHandler_WriteDataByMemory.h"
#endif

#ifndef __INCLUDED_DIA_NATIVE_KDS_INTERFACE__
#include "common/framework/config/dia_IKDS.h"
#endif

#define MSG_DATA_OFFSET            3 // Offset from  oDiagMsgBuffer-start to 1st data-byte (e.g. MemorySize-Byte)

//-----------------------------------------------------------------------------

dia_SrvHandler_WriteDataByMemory::dia_SrvHandler_WriteDataByMemory ( tVoid )
   : dia_ServiceHandlerUDS("dia_SrvHandler_WriteDataByMemory",DIA_C_U8_UDS_SID_WRITE_MEMORY_BY_ADDRESS,(tU8) 0x12)
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteDataByMemory::dia_SrvHandler_WriteDataByMemory(tCString,tU8,tU8)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_WriteDataByMemory::~dia_SrvHandler_WriteDataByMemory ( tVoid )
{}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_WriteDataByMemory::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteDataByMemory::vOnProcessRequest");
   /* SrvHandler Defines according to CDD-File */
   /*------------------------------------------*/

   // Init
   tU8 u8kdsData[DIA_PROP_LENGTH_MAX] = { 0 };
   (tVoid) ::memset(u8kdsData, 0, DIA_PROP_LENGTH_MAX);

   tDiaResult retCode = DIA_FAILED;

   // extraction the message data
   tU8 u8KDSAddress[2] = { 0 };
   (tVoid) ::memset(u8KDSAddress, 0, 2);
   u8KDSAddress[0] = oDiagMsgBuffer().u8GetData(0 +MSG_DATA_OFFSET); // -> Target-Address in the KDS (Group)
   u8KDSAddress[1] = oDiagMsgBuffer().u8GetData(1 +MSG_DATA_OFFSET); // -> ID inside the Group
   tU16 u16KDSAddress = U8_2_U16(u8KDSAddress[0], u8KDSAddress[1]);
   tU8  u8KDS_Size = oDiagMsgBuffer().u8GetData(2 +MSG_DATA_OFFSET);

   if ( oDiagMsgBuffer().u8GetData(0) != oDiagMsgBuffer().u16GetDataLength() )
   {
      DIA_TR_ERR("### dia_SrvHandler_WriteDataByMemory::Error: Msg Length Check ###");
      DIA_TR_ERR("Size in KDS = %d", u8KDS_Size);
      DIA_TR_ERR("DataLen (1) = %d", oDiagMsgBuffer().u8GetData(0));
      DIA_TR_ERR("DataLen (2) = %d", oDiagMsgBuffer().u16GetDataLength());
      vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
      return;
   }

   // write buffer-data into u8kdsData array
   for ( tU16 i=0; i<u8KDS_Size; i++ ){
      u8kdsData[i] = oDiagMsgBuffer().u8GetData(static_cast<tU16>(i +(3+MSG_DATA_OFFSET)));
   }

   dia_IKDS* pKDS = 0;
   if (queryConfMgrInterface<dia_IKDS>(&pKDS) == DIA_SUCCESS) {
      DIA_TR_INF("dia_SrvHandler_WriteDataByMemory::vProcessRequest - Try WriteDataByMemory entry 0x%04x with length %d",u16KDSAddress,u8KDS_Size);
      if (pKDS->writeKDS(u16KDSAddress, u8kdsData, u8KDS_Size) == DIA_SUCCESS) {
         DIA_TR_INF("dia_SrvHandler_WriteDataByMemory::vProcessRequest: WriteDataByMemory SUCCESSFUL");
         retCode = DIA_SUCCESS;
      } else {
         DIA_TR_INF("dia_SrvHandler_WriteDataByMemory::vProcessRequest: WriteDataByMemory FAIL");
      }
   } else {
      DIA_TR_ERR("dia_SrvHandler_WriteDataByMemory::vProcessRequest - Requesting ConfigManager interface failed");
   }
   // FINISH WITH WRITING -> Build answer message

   // "RETURN"
   if (retCode == DIA_SUCCESS) {
      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(5);
      vResReadyAndQuit();
   } else {
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

