/*
 * dia_SrvHandler_WireSpeedInformation_Get.cpp
 *
 *  Created on: 27.07.2012
 *      Author:
 */
// TTFis:\> DIA_REQ UDS 03 22 10 08

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SrvHandler_WireSpeedInformation_Get.h"

#define DATA_START 3
#define DATA_LENGTH 2
#define RESPONSE_BYTE_1 0
#define RESPONSE_BYTE_2 1
#define BYTE_SIZE 8


//-----------------------------------------------------------------------------

dia_SrvHandler_WireSpeedInformation_Get::dia_SrvHandler_WireSpeedInformation_Get ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_WireSpeedInformation_Get",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_WIRE_SPEED_INFORMATION /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_WireSpeedInformation_Get::dia_SrvHandler_WireSpeedInformation_Get(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_WireSpeedInformation_Get::~dia_SrvHandler_WireSpeedInformation_Get ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ISensorListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_WireSpeedInformation_Get::~dia_SrvHandler_WireSpeedInformation_Get !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_WireSpeedInformation_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WireSpeedInformation_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISensor* pInterface = 0;
   if ( querySysAdapterInterface<dia_ISensor>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (tVoid) setSysAdapterListener<dia_ISensorListener>(this);
         if ( pInterface->getOdometerCount()== DIA_SUCCESS )
         {
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_WireSpeedInformation_Get::vProcessRequest - getOdometerCount() failed.");
         }
         DIA_TR_INF("dia_SrvHandler_WireSpeedInformation_Get::vProcessRequest - check SA connection %d",pInterface->getUID() );
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_WireSpeedInformation_Get::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ISensorListener>(this);
      DIA_TR_ERR("dia_SrvHandler_WireSpeedInformation_Get ---  SEND TO SPM SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_WireSpeedInformation_Get::vOnGalaCounter (tU16 galaCounter)
{
   dia_tclFnctTrace trc("dia_SrvHandler_WireSpeedInformation_Get:vOnGalaCounter");

//   if (galaCounter ...) {
      (tVoid) unsetSysAdapterListener<dia_ISensorListener>(this);

      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (tVoid) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + RESPONSE_BYTE_1, ((tU8) (galaCounter >> BYTE_SIZE)));
      (tVoid) oDiagMsgBuffer().vSetDataU8((tS16) DATA_START + RESPONSE_BYTE_2, (((tU8) galaCounter)));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_WireSpeedInformation_Get::vOnGalaCounter (%d / 0x%04x) SUCCESSFUL.",galaCounter, galaCounter);
//   } else {
//      DIA_TR_INF("dia_SrvHandler_WireSpeedInformation_Get::vOnGalaCounter FAIL");
//      // Sending back the Negative answer
//      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
//   }
}

