/*
 * dia_SrvHandler_WireDimmingInfo_Get.cpp
 *
 *  Created on: 27.07.2012
 *      Author: shw2abt
 *
 * TTFis:\> DIA_REQ UDS 03 22 10 07
 *
 * -----------------------------------------------------------------------------------
 * Date 			| Author			 | Modification                               |
 * 01.12.15    		| sbr5kor	  		 | AIVI-12208 & CMG3G-8222                    |
 * ------------------------------------------------------------------------------------
 */

#include "dia_SrvHandler_WireDimmingInfo_Get.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_WireDimmingInfo_Get::dia_SrvHandler_WireDimmingInfo_Get ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_WireDimmingInfo_Get",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_WIRE_DIMMING_INFORMATION /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_WireDimmingInfo_Get::dia_SrvHandler_WireDimmingInfo_Get(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_WireDimmingInfo_Get::~dia_SrvHandler_WireDimmingInfo_Get ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_WireDimmingInfo_Get::~dia_SrvHandler_WireDimmingInfo_Get !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_WireDimmingInfo_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WireDimmingInfo_Get::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_IDimming* pInterface = 0;
   if ( querySysAdapterInterface<dia_IDimming>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_WireDimmingInfo_Get::vProcessRequest - querySysAdapterInterface OK");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_WireDimmingInfo_Get::vProcessRequest - pInterface OK");
         (tVoid) setSysAdapterListener<dia_IDimmingListener>(this);
         if ( pInterface->getDimmingPWM() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF("dia_SrvHandler_WireDimmingInfo_Get::vProcessRequest - getWireDimmingInformation() failed.");
         }
         DIA_TR_INF("dia_SrvHandler_WireDimmingInfo_Get::vProcessRequest - check SA connection %d", pInterface->getUID() );
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_WireDimmingInfo_Get::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
      DIA_TR_ERR(" ---  SEND TO DIMMING SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

/******************************************************************************
* FUNCTION:    vOnDimmingPWM
*
* DESCRIPTION: Response handling Function
*
* PARAMETER:   tU16 - pwmRate
*
* RETURNVALUE: VOID
*
******************************************************************************/

tVoid
dia_SrvHandler_WireDimmingInfo_Get::vOnDimmingPWM ( tU16 pwmRate )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WireDimmingInfo_Get:vOnDimmingPWM");

   (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);

   if ( pwmRate <= 1000 )
   {
      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) (pwmRate >> 8)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, (((tU8) pwmRate)   ));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_WireDimmingInfo_Get::vOnDimmingPWM SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_WireDimmingInfo_Get::vOnDimmingPWM FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//------------------------------------------------------------------------------

tVoid
dia_SrvHandler_WireDimmingInfo_Get::vOnTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WireDimmingInfo_Get::vOnTimeout");
   (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}
